/*
 * Decompiled with CFR 0.152.
 */
package io.trino.likematcher;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.likematcher.DFA;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

record NFA(State start, State accept, List<State> states, Map<Integer, List<Transition>> transitions) {
    NFA {
        Objects.requireNonNull(start, "start is null");
        Objects.requireNonNull(accept, "accept is null");
        states = ImmutableList.copyOf(states);
        transitions = ImmutableMap.copyOf(transitions);
    }

    public DFA toDfa() {
        HashMap<Set, DFA.State> activeStates = new HashMap<Set, DFA.State>();
        DFA.Builder builder = new DFA.Builder();
        DFA.State failed = builder.addFailState();
        for (int i = 0; i < 256; ++i) {
            builder.addTransition(failed, i, failed);
        }
        Set<State> initial = this.transitiveClosure(Set.of(this.start));
        ArrayDeque<Set<State>> queue = new ArrayDeque<Set<State>>();
        queue.add(initial);
        DFA.State dfaStartState = builder.addStartState(this.makeLabel(initial), initial.contains(this.accept));
        activeStates.put(initial, dfaStartState);
        HashSet<Set> visited = new HashSet<Set>();
        while (!queue.isEmpty()) {
            Set current = (Set)queue.poll();
            if (!visited.add(current)) continue;
            for (int byteValue = 0; byteValue < 256; ++byteValue) {
                HashSet<State> next = new HashSet<State>();
                for (State nfaState : current) {
                    for (Transition transition : this.transitions(nfaState)) {
                        Prefix prefixTransition;
                        Value valueTransition;
                        Condition condition = transition.condition();
                        State target = this.states.get(transition.target());
                        if (condition instanceof Value && (valueTransition = (Value)condition).value() == (byte)byteValue) {
                            next.add(target);
                            continue;
                        }
                        if (!(condition instanceof Prefix) || byteValue >>> 8 - (prefixTransition = (Prefix)condition).bits() != prefixTransition.prefix()) continue;
                        next.add(target);
                    }
                }
                DFA.State from = (DFA.State)activeStates.get(current);
                DFA.State to = failed;
                if (!next.isEmpty()) {
                    Set<State> closure = this.transitiveClosure(next);
                    to = activeStates.computeIfAbsent(closure, nfaStates -> builder.addState(this.makeLabel((Set<State>)nfaStates), nfaStates.contains(this.accept)));
                    queue.add(closure);
                }
                builder.addTransition(from, byteValue, to);
            }
        }
        return builder.build();
    }

    private List<Transition> transitions(State state) {
        return this.transitions.getOrDefault(state.id(), (List<Transition>)ImmutableList.of());
    }

    private Set<State> transitiveClosure(Set<State> states) {
        HashSet<State> result = new HashSet<State>();
        ArrayDeque<State> queue = new ArrayDeque<State>(states);
        while (!queue.isEmpty()) {
            State state = (State)queue.poll();
            if (result.contains(state)) continue;
            this.transitions(state).stream().filter(transition -> transition.condition() instanceof Epsilon).forEach(transition -> {
                State target = this.states.get(transition.target());
                result.add(target);
                queue.add(target);
            });
        }
        result.addAll(states);
        return result;
    }

    private String makeLabel(Set<State> states) {
        return "{" + states.stream().map(State::id).map(Object::toString).sorted().collect(Collectors.joining(",")) + "}";
    }

    public record State(int id) {
        @Override
        public String toString() {
            return "(" + this.id + ")";
        }
    }

    record Transition(int target, Condition condition) {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static interface Condition {
    }

    record Value(byte value) implements Condition
    {
    }

    record Prefix(int prefix, int bits) implements Condition
    {
    }

    record Epsilon() implements Condition
    {
    }

    public static class Builder {
        private int nextId;
        private State start;
        private State accept;
        private final List<State> states = new ArrayList<State>();
        private final Map<Integer, List<Transition>> transitions = new HashMap<Integer, List<Transition>>();

        public State addState() {
            State state = new State(this.nextId++);
            this.states.add(state);
            return state;
        }

        public State addStartState() {
            Preconditions.checkState((this.start == null ? 1 : 0) != 0, (Object)"Start state is already set");
            this.start = this.addState();
            return this.start;
        }

        public void setAccept(State state) {
            Preconditions.checkState((this.accept == null ? 1 : 0) != 0, (Object)"Accept state is already set");
            this.accept = state;
        }

        public void addTransition(State from, Condition condition, State to) {
            this.transitions.computeIfAbsent(from.id(), key -> new ArrayList()).add(new Transition(to.id(), condition));
        }

        public NFA build() {
            return new NFA(this.start, this.accept, this.states, this.transitions);
        }
    }
}

