/*
 * Decompiled with CFR 0.152.
 */
package io.trino.memory;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import io.trino.memory.MemoryInfo;
import io.trino.spi.QueryId;
import io.trino.spi.memory.MemoryAllocation;
import io.trino.spi.memory.MemoryPoolInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.weakref.jmx.Managed;

@ThreadSafe
public class ClusterMemoryPool {
    @GuardedBy(value="this")
    private long totalDistributedBytes;
    @GuardedBy(value="this")
    private long reservedDistributedBytes;
    @GuardedBy(value="this")
    private long reservedRevocableDistributedBytes;
    @GuardedBy(value="this")
    private int nodes;
    @GuardedBy(value="this")
    private int blockedNodes;
    @GuardedBy(value="this")
    private int assignedQueries;
    @GuardedBy(value="this")
    private final Map<QueryId, Long> queryMemoryReservations = new HashMap<QueryId, Long>();
    @GuardedBy(value="this")
    private final Map<QueryId, List<MemoryAllocation>> queryMemoryAllocations = new HashMap<QueryId, List<MemoryAllocation>>();
    @GuardedBy(value="this")
    private final Map<QueryId, Long> queryMemoryRevocableReservations = new HashMap<QueryId, Long>();

    public synchronized MemoryPoolInfo getInfo() {
        return new MemoryPoolInfo(this.totalDistributedBytes, this.reservedDistributedBytes, this.reservedRevocableDistributedBytes, (Map)ImmutableMap.copyOf(this.queryMemoryReservations), (Map)ImmutableMap.copyOf(this.queryMemoryAllocations), (Map)ImmutableMap.copyOf(this.queryMemoryRevocableReservations), (Map)ImmutableMap.of(), (Map)ImmutableMap.of());
    }

    @Managed
    public synchronized long getTotalDistributedBytes() {
        return this.totalDistributedBytes;
    }

    @Managed
    public synchronized long getFreeDistributedBytes() {
        return this.totalDistributedBytes - this.reservedDistributedBytes - this.reservedRevocableDistributedBytes;
    }

    @Managed
    public synchronized long getReservedDistributedBytes() {
        return this.reservedDistributedBytes;
    }

    @Managed
    public synchronized long getReservedRevocableDistributedBytes() {
        return this.reservedRevocableDistributedBytes;
    }

    @Managed
    public synchronized int getNodes() {
        return this.nodes;
    }

    @Managed
    public synchronized int getBlockedNodes() {
        return this.blockedNodes;
    }

    @Managed
    public synchronized int getAssignedQueries() {
        return this.assignedQueries;
    }

    public synchronized Map<QueryId, Long> getQueryMemoryReservations() {
        return ImmutableMap.copyOf(this.queryMemoryReservations);
    }

    public synchronized Map<QueryId, Long> getQueryMemoryRevocableReservations() {
        return ImmutableMap.copyOf(this.queryMemoryRevocableReservations);
    }

    public synchronized void update(List<MemoryInfo> memoryInfos, int assignedQueries) {
        this.nodes = 0;
        this.blockedNodes = 0;
        this.totalDistributedBytes = 0L;
        this.reservedDistributedBytes = 0L;
        this.reservedRevocableDistributedBytes = 0L;
        this.assignedQueries = assignedQueries;
        this.queryMemoryReservations.clear();
        this.queryMemoryAllocations.clear();
        this.queryMemoryRevocableReservations.clear();
        for (MemoryInfo info : memoryInfos) {
            MemoryPoolInfo poolInfo = info.getPool();
            ++this.nodes;
            if (poolInfo.getFreeBytes() + poolInfo.getReservedRevocableBytes() <= 0L) {
                ++this.blockedNodes;
            }
            this.totalDistributedBytes += poolInfo.getMaxBytes();
            this.reservedDistributedBytes += poolInfo.getReservedBytes();
            this.reservedRevocableDistributedBytes += poolInfo.getReservedRevocableBytes();
            for (Map.Entry entry : poolInfo.getQueryMemoryReservations().entrySet()) {
                this.queryMemoryReservations.merge((QueryId)entry.getKey(), (Long)entry.getValue(), Long::sum);
            }
            for (Map.Entry entry : poolInfo.getQueryMemoryAllocations().entrySet()) {
                this.queryMemoryAllocations.merge((QueryId)entry.getKey(), (List)entry.getValue(), this::mergeQueryAllocations);
            }
            for (Map.Entry entry : poolInfo.getQueryMemoryRevocableReservations().entrySet()) {
                this.queryMemoryRevocableReservations.merge((QueryId)entry.getKey(), (Long)entry.getValue(), Long::sum);
            }
        }
    }

    private List<MemoryAllocation> mergeQueryAllocations(List<MemoryAllocation> left, List<MemoryAllocation> right) {
        Objects.requireNonNull(left, "left is null");
        Objects.requireNonNull(right, "right is null");
        HashMap<String, MemoryAllocation> mergedAllocations = new HashMap<String, MemoryAllocation>();
        for (MemoryAllocation allocation : left) {
            mergedAllocations.put(allocation.getTag(), allocation);
        }
        for (MemoryAllocation allocation : right) {
            mergedAllocations.merge(allocation.getTag(), allocation, (a, b) -> new MemoryAllocation(a.getTag(), a.getAllocation() + b.getAllocation()));
        }
        return new ArrayList<MemoryAllocation>(mergedAllocations.values());
    }

    public synchronized String toString() {
        return MoreObjects.toStringHelper((Object)this).add("totalDistributedBytes", this.totalDistributedBytes).add("freeDistributedBytes", this.getFreeDistributedBytes()).add("reservedDistributedBytes", this.reservedDistributedBytes).add("reservedRevocableDistributedBytes", this.reservedRevocableDistributedBytes).add("nodes", this.nodes).add("blockedNodes", this.blockedNodes).add("assignedQueries", this.assignedQueries).add("queryMemoryReservations", this.queryMemoryReservations).add("queryMemoryAllocations", this.queryMemoryAllocations).add("queryMemoryRevocableReservations", this.queryMemoryRevocableReservations).toString();
    }
}

