/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.trino.connector.CatalogHandle;
import io.trino.connector.ConnectorServices;
import io.trino.metadata.CatalogMetadata;
import io.trino.metadata.CatalogTransaction;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.transaction.IsolationLevel;
import io.trino.transaction.InternalConnector;
import io.trino.transaction.TransactionId;
import java.util.Objects;

public class Catalog {
    private final String catalogName;
    private final CatalogHandle catalogHandle;
    private final String connectorName;
    private final ConnectorServices catalogConnector;
    private final ConnectorServices informationSchemaConnector;
    private final ConnectorServices systemConnector;

    public Catalog(String catalogName, CatalogHandle catalogHandle, String connectorName, ConnectorServices catalogConnector, ConnectorServices informationSchemaConnector, ConnectorServices systemConnector) {
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
        this.catalogHandle = Objects.requireNonNull(catalogHandle, "catalogHandle is null");
        Preconditions.checkArgument((!catalogHandle.getType().isInternal() ? 1 : 0) != 0, (Object)"Internal catalogName not allowed");
        this.connectorName = Objects.requireNonNull(connectorName, "connectorName is null");
        this.catalogConnector = Objects.requireNonNull(catalogConnector, "catalogConnector is null");
        this.informationSchemaConnector = Objects.requireNonNull(informationSchemaConnector, "informationSchemaConnector is null");
        this.systemConnector = Objects.requireNonNull(systemConnector, "systemConnector is null");
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public CatalogHandle getCatalogHandle() {
        return this.catalogHandle;
    }

    public String getConnectorName() {
        return this.connectorName;
    }

    public CatalogMetadata beginTransaction(TransactionId transactionId, IsolationLevel isolationLevel, boolean readOnly, boolean autoCommitContext) {
        CatalogTransaction catalogTransaction = Catalog.beginTransaction(this.catalogConnector, transactionId, isolationLevel, readOnly, autoCommitContext);
        CatalogTransaction informationSchemaTransaction = Catalog.beginTransaction(this.informationSchemaConnector, transactionId, isolationLevel, readOnly, autoCommitContext);
        CatalogTransaction systemTransaction = Catalog.beginTransaction(this.systemConnector, transactionId, isolationLevel, readOnly, autoCommitContext);
        return new CatalogMetadata(this.catalogName, catalogTransaction, informationSchemaTransaction, systemTransaction, this.catalogConnector.getSecurityManagement(), this.catalogConnector.getCapabilities());
    }

    private static CatalogTransaction beginTransaction(ConnectorServices connectorServices, TransactionId transactionId, IsolationLevel isolationLevel, boolean readOnly, boolean autoCommitContext) {
        Connector connector = connectorServices.getConnector();
        ConnectorTransactionHandle transactionHandle = connector instanceof InternalConnector ? ((InternalConnector)connector).beginTransaction(transactionId, isolationLevel, readOnly) : connector.beginTransaction(isolationLevel, readOnly, autoCommitContext);
        return new CatalogTransaction(connectorServices.getCatalogHandle(), connector, transactionHandle);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("catalogName", (Object)this.catalogName).add("catalogHandle", (Object)this.catalogHandle).toString();
    }
}

