/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.airlift.log.Logger;
import io.trino.Session;
import io.trino.connector.CatalogHandle;
import io.trino.metadata.CatalogTransaction;
import io.trino.metadata.QualifiedObjectName;
import io.trino.spi.connector.CatalogSchemaName;
import io.trino.spi.connector.ConnectorCapabilities;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorTransactionHandle;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class CatalogMetadata {
    private final String catalogName;
    private static final Logger log = Logger.get(CatalogMetadata.class);
    private static final String INFORMATION_SCHEMA_NAME = "information_schema";
    private final CatalogTransaction catalogTransaction;
    private final CatalogTransaction informationSchemaTransaction;
    private final CatalogTransaction systemTransaction;
    private final SecurityManagement securityManagement;
    private final Set<ConnectorCapabilities> connectorCapabilities;

    public CatalogMetadata(String catalogName, CatalogTransaction catalogTransaction, CatalogTransaction informationSchemaTransaction, CatalogTransaction systemTransaction, SecurityManagement securityManagement, Set<ConnectorCapabilities> connectorCapabilities) {
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
        this.catalogTransaction = Objects.requireNonNull(catalogTransaction, "catalogTransaction is null");
        this.informationSchemaTransaction = Objects.requireNonNull(informationSchemaTransaction, "informationSchemaTransaction is null");
        this.systemTransaction = Objects.requireNonNull(systemTransaction, "systemTransaction is null");
        this.securityManagement = Objects.requireNonNull(securityManagement, "securityManagement is null");
        this.connectorCapabilities = Objects.requireNonNull(connectorCapabilities, "connectorCapabilities is null");
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public CatalogHandle getCatalogHandle() {
        return this.catalogTransaction.getCatalogHandle();
    }

    public boolean isSingleStatementWritesOnly() {
        return this.catalogTransaction.isSingleStatementWritesOnly();
    }

    public ConnectorMetadata getMetadata(Session session) {
        return this.catalogTransaction.getConnectorMetadata(session);
    }

    public ConnectorMetadata getMetadataFor(Session session, CatalogHandle catalogHandle) {
        if (catalogHandle.equals(this.catalogTransaction.getCatalogHandle())) {
            return this.catalogTransaction.getConnectorMetadata(session);
        }
        if (catalogHandle.equals(this.informationSchemaTransaction.getCatalogHandle())) {
            return this.informationSchemaTransaction.getConnectorMetadata(session);
        }
        if (catalogHandle.equals(this.systemTransaction.getCatalogHandle())) {
            return this.systemTransaction.getConnectorMetadata(session);
        }
        throw new IllegalArgumentException("Unknown catalog handle: " + catalogHandle);
    }

    public ConnectorTransactionHandle getTransactionHandleFor(CatalogHandle.CatalogHandleType catalogHandleType) {
        switch (catalogHandleType) {
            case NORMAL: {
                return this.catalogTransaction.getTransactionHandle();
            }
            case INFORMATION_SCHEMA: {
                return this.informationSchemaTransaction.getTransactionHandle();
            }
            case SYSTEM: {
                return this.systemTransaction.getTransactionHandle();
            }
        }
        throw new IllegalArgumentException("Unknown catalog handle: " + catalogHandleType);
    }

    public ConnectorTransactionHandle getTransactionHandleFor(CatalogHandle catalogHandle) {
        if (catalogHandle.equals(this.catalogTransaction.getCatalogHandle())) {
            return this.catalogTransaction.getTransactionHandle();
        }
        if (catalogHandle.equals(this.informationSchemaTransaction.getCatalogHandle())) {
            return this.informationSchemaTransaction.getTransactionHandle();
        }
        if (catalogHandle.equals(this.systemTransaction.getCatalogHandle())) {
            return this.systemTransaction.getTransactionHandle();
        }
        throw new IllegalArgumentException("Unknown catalog handle: " + catalogHandle);
    }

    public CatalogHandle getConnectorHandleForSchema(CatalogSchemaName schema) {
        if (schema.getSchemaName().equals(INFORMATION_SCHEMA_NAME)) {
            return this.informationSchemaTransaction.getCatalogHandle();
        }
        return this.catalogTransaction.getCatalogHandle();
    }

    public CatalogHandle getCatalogHandle(Session session, QualifiedObjectName table) {
        if (table.getSchemaName().equals(INFORMATION_SCHEMA_NAME)) {
            return this.informationSchemaTransaction.getCatalogHandle();
        }
        if (this.systemTransaction.getConnectorMetadata(session).getTableHandle(session.toConnectorSession(this.systemTransaction.getCatalogHandle()), table.asSchemaTableName()) != null) {
            return this.systemTransaction.getCatalogHandle();
        }
        return this.catalogTransaction.getCatalogHandle();
    }

    public void commit() {
        this.informationSchemaTransaction.commit();
        this.systemTransaction.commit();
        this.catalogTransaction.commit();
    }

    public void abort() {
        CatalogMetadata.safeAbort(this.informationSchemaTransaction);
        CatalogMetadata.safeAbort(this.systemTransaction);
        CatalogMetadata.safeAbort(this.catalogTransaction);
    }

    private static void safeAbort(CatalogTransaction transaction) {
        try {
            transaction.abort();
        }
        catch (Exception e) {
            log.error((Throwable)e, "Connector threw exception on abort");
        }
    }

    public List<CatalogHandle> listCatalogHandles() {
        return ImmutableList.of((Object)this.informationSchemaTransaction.getCatalogHandle(), (Object)this.systemTransaction.getCatalogHandle(), (Object)this.catalogTransaction.getCatalogHandle());
    }

    public SecurityManagement getSecurityManagement() {
        return this.securityManagement;
    }

    public Set<ConnectorCapabilities> getConnectorCapabilities() {
        return this.connectorCapabilities;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("catalogName", (Object)this.catalogName).add("catalogHandle", (Object)this.getCatalogHandle()).toString();
    }

    public static enum SecurityManagement {
        SYSTEM,
        CONNECTOR;

    }
}

