/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.SetMultimap;
import io.trino.connector.CatalogHandle;
import io.trino.metadata.AllNodes;
import io.trino.metadata.InternalNode;
import io.trino.metadata.NodeState;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;

public interface InternalNodeManager {
    public Set<InternalNode> getNodes(NodeState var1);

    public Set<InternalNode> getActiveCatalogNodes(CatalogHandle var1);

    public NodesSnapshot getActiveNodesSnapshot();

    public InternalNode getCurrentNode();

    public Set<InternalNode> getCoordinators();

    public AllNodes getAllNodes();

    public void refreshNodes();

    public void addNodeChangeListener(Consumer<AllNodes> var1);

    public void removeNodeChangeListener(Consumer<AllNodes> var1);

    public static class NodesSnapshot {
        private final Set<InternalNode> allNodes;
        private final Optional<SetMultimap<CatalogHandle, InternalNode>> connectorNodes;

        public NodesSnapshot(Set<InternalNode> allActiveNodes, Optional<SetMultimap<CatalogHandle, InternalNode>> activeNodesByCatalogName) {
            Objects.requireNonNull(allActiveNodes, "allActiveNodes is null");
            Objects.requireNonNull(activeNodesByCatalogName, "activeNodesByCatalogName is null");
            this.allNodes = ImmutableSet.copyOf(allActiveNodes);
            this.connectorNodes = activeNodesByCatalogName.map(ImmutableSetMultimap::copyOf);
        }

        public Set<InternalNode> getAllNodes() {
            return this.allNodes;
        }

        public Set<InternalNode> getConnectorNodes(CatalogHandle catalogHandle) {
            return this.connectorNodes.map(map -> map.get((Object)catalogHandle)).orElse(this.allNodes);
        }
    }
}

