/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.slice.Slice;
import io.trino.Session;
import io.trino.connector.CatalogHandle;
import io.trino.metadata.AnalyzeMetadata;
import io.trino.metadata.AnalyzeTableHandle;
import io.trino.metadata.CatalogInfo;
import io.trino.metadata.InsertTableHandle;
import io.trino.metadata.MaterializedViewDefinition;
import io.trino.metadata.MergeHandle;
import io.trino.metadata.OperatorNotFoundException;
import io.trino.metadata.OutputTableHandle;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.QualifiedTablePrefix;
import io.trino.metadata.RedirectionAwareTableHandle;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.ResolvedIndex;
import io.trino.metadata.TableExecuteHandle;
import io.trino.metadata.TableFunctionHandle;
import io.trino.metadata.TableHandle;
import io.trino.metadata.TableLayout;
import io.trino.metadata.TableMetadata;
import io.trino.metadata.TableProperties;
import io.trino.metadata.TableSchema;
import io.trino.metadata.TableVersion;
import io.trino.metadata.ViewDefinition;
import io.trino.metadata.ViewInfo;
import io.trino.spi.connector.AggregateFunction;
import io.trino.spi.connector.AggregationApplicationResult;
import io.trino.spi.connector.BeginTableExecuteResult;
import io.trino.spi.connector.CatalogSchemaName;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorCapabilities;
import io.trino.spi.connector.ConnectorOutputMetadata;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.ConstraintApplicationResult;
import io.trino.spi.connector.JoinApplicationResult;
import io.trino.spi.connector.JoinStatistics;
import io.trino.spi.connector.JoinType;
import io.trino.spi.connector.LimitApplicationResult;
import io.trino.spi.connector.MaterializedViewFreshness;
import io.trino.spi.connector.ProjectionApplicationResult;
import io.trino.spi.connector.RowChangeParadigm;
import io.trino.spi.connector.SampleApplicationResult;
import io.trino.spi.connector.SampleType;
import io.trino.spi.connector.SortItem;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.connector.TableColumnsMetadata;
import io.trino.spi.connector.TableFunctionApplicationResult;
import io.trino.spi.connector.TableScanRedirectApplicationResult;
import io.trino.spi.connector.TopNApplicationResult;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.function.AggregationFunctionMetadata;
import io.trino.spi.function.FunctionMetadata;
import io.trino.spi.function.OperatorType;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.security.GrantInfo;
import io.trino.spi.security.Identity;
import io.trino.spi.security.Privilege;
import io.trino.spi.security.RoleGrant;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.statistics.ComputedStatistics;
import io.trino.spi.statistics.TableStatistics;
import io.trino.spi.statistics.TableStatisticsMetadata;
import io.trino.spi.type.Type;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.planner.PartitioningHandle;
import io.trino.sql.tree.QualifiedName;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;

public interface Metadata {
    public Set<ConnectorCapabilities> getConnectorCapabilities(Session var1, CatalogHandle var2);

    public boolean catalogExists(Session var1, String var2);

    public boolean schemaExists(Session var1, CatalogSchemaName var2);

    public List<String> listSchemaNames(Session var1, String var2);

    public Optional<TableHandle> getTableHandle(Session var1, QualifiedObjectName var2);

    public Optional<SystemTable> getSystemTable(Session var1, QualifiedObjectName var2);

    public Optional<TableExecuteHandle> getTableHandleForExecute(Session var1, TableHandle var2, String var3, Map<String, Object> var4);

    public Optional<TableLayout> getLayoutForTableExecute(Session var1, TableExecuteHandle var2);

    public BeginTableExecuteResult<TableExecuteHandle, TableHandle> beginTableExecute(Session var1, TableExecuteHandle var2, TableHandle var3);

    public void finishTableExecute(Session var1, TableExecuteHandle var2, Collection<Slice> var3, List<Object> var4);

    public void executeTableExecute(Session var1, TableExecuteHandle var2);

    public TableProperties getTableProperties(Session var1, TableHandle var2);

    public TableHandle makeCompatiblePartitioning(Session var1, TableHandle var2, PartitioningHandle var3);

    public Optional<PartitioningHandle> getCommonPartitioning(Session var1, PartitioningHandle var2, PartitioningHandle var3);

    public Optional<Object> getInfo(Session var1, TableHandle var2);

    public TableSchema getTableSchema(Session var1, TableHandle var2);

    public TableMetadata getTableMetadata(Session var1, TableHandle var2);

    public TableStatistics getTableStatistics(Session var1, TableHandle var2);

    public List<QualifiedObjectName> listTables(Session var1, QualifiedTablePrefix var2);

    public Map<String, ColumnHandle> getColumnHandles(Session var1, TableHandle var2);

    public ColumnMetadata getColumnMetadata(Session var1, TableHandle var2, ColumnHandle var3);

    public List<TableColumnsMetadata> listTableColumns(Session var1, QualifiedTablePrefix var2);

    public void createSchema(Session var1, CatalogSchemaName var2, Map<String, Object> var3, TrinoPrincipal var4);

    public void dropSchema(Session var1, CatalogSchemaName var2);

    public void renameSchema(Session var1, CatalogSchemaName var2, String var3);

    public void setSchemaAuthorization(Session var1, CatalogSchemaName var2, TrinoPrincipal var3);

    public void createTable(Session var1, String var2, ConnectorTableMetadata var3, boolean var4);

    public void renameTable(Session var1, TableHandle var2, QualifiedObjectName var3);

    public void setTableProperties(Session var1, TableHandle var2, Map<String, Optional<Object>> var3);

    public void setTableComment(Session var1, TableHandle var2, Optional<String> var3);

    public void setViewComment(Session var1, QualifiedObjectName var2, Optional<String> var3);

    public void setViewColumnComment(Session var1, QualifiedObjectName var2, String var3, Optional<String> var4);

    public void setColumnComment(Session var1, TableHandle var2, ColumnHandle var3, Optional<String> var4);

    public void renameColumn(Session var1, TableHandle var2, ColumnHandle var3, String var4);

    public void addColumn(Session var1, TableHandle var2, ColumnMetadata var3);

    public void setTableAuthorization(Session var1, CatalogSchemaTableName var2, TrinoPrincipal var3);

    public void dropColumn(Session var1, TableHandle var2, ColumnHandle var3);

    public void dropTable(Session var1, TableHandle var2);

    public void truncateTable(Session var1, TableHandle var2);

    public Optional<TableLayout> getNewTableLayout(Session var1, String var2, ConnectorTableMetadata var3);

    public OutputTableHandle beginCreateTable(Session var1, String var2, ConnectorTableMetadata var3, Optional<TableLayout> var4);

    public Optional<ConnectorOutputMetadata> finishCreateTable(Session var1, OutputTableHandle var2, Collection<Slice> var3, Collection<ComputedStatistics> var4);

    public Optional<TableLayout> getInsertLayout(Session var1, TableHandle var2);

    public TableStatisticsMetadata getStatisticsCollectionMetadataForWrite(Session var1, CatalogHandle var2, ConnectorTableMetadata var3);

    public AnalyzeMetadata getStatisticsCollectionMetadata(Session var1, TableHandle var2, Map<String, Object> var3);

    public AnalyzeTableHandle beginStatisticsCollection(Session var1, TableHandle var2);

    public void finishStatisticsCollection(Session var1, AnalyzeTableHandle var2, Collection<ComputedStatistics> var3);

    public void cleanupQuery(Session var1);

    public InsertTableHandle beginInsert(Session var1, TableHandle var2, List<ColumnHandle> var3);

    public boolean supportsMissingColumnsOnInsert(Session var1, TableHandle var2);

    public Optional<ConnectorOutputMetadata> finishInsert(Session var1, InsertTableHandle var2, Collection<Slice> var3, Collection<ComputedStatistics> var4);

    public boolean delegateMaterializedViewRefreshToConnector(Session var1, QualifiedObjectName var2);

    public ListenableFuture<Void> refreshMaterializedView(Session var1, QualifiedObjectName var2);

    public InsertTableHandle beginRefreshMaterializedView(Session var1, TableHandle var2, List<TableHandle> var3);

    public Optional<ConnectorOutputMetadata> finishRefreshMaterializedView(Session var1, TableHandle var2, InsertTableHandle var3, Collection<Slice> var4, Collection<ComputedStatistics> var5, List<TableHandle> var6);

    public ColumnHandle getDeleteRowIdColumnHandle(Session var1, TableHandle var2);

    public ColumnHandle getUpdateRowIdColumnHandle(Session var1, TableHandle var2, List<ColumnHandle> var3);

    public Optional<TableHandle> applyDelete(Session var1, TableHandle var2);

    public OptionalLong executeDelete(Session var1, TableHandle var2);

    public TableHandle beginDelete(Session var1, TableHandle var2);

    public void finishDelete(Session var1, TableHandle var2, Collection<Slice> var3);

    public TableHandle beginUpdate(Session var1, TableHandle var2, List<ColumnHandle> var3);

    public void finishUpdate(Session var1, TableHandle var2, Collection<Slice> var3);

    public RowChangeParadigm getRowChangeParadigm(Session var1, TableHandle var2);

    public ColumnHandle getMergeRowIdColumnHandle(Session var1, TableHandle var2);

    public Optional<PartitioningHandle> getUpdateLayout(Session var1, TableHandle var2);

    public MergeHandle beginMerge(Session var1, TableHandle var2);

    public void finishMerge(Session var1, MergeHandle var2, Collection<Slice> var3, Collection<ComputedStatistics> var4);

    public Optional<CatalogHandle> getCatalogHandle(Session var1, String var2);

    public List<CatalogInfo> listCatalogs(Session var1);

    public List<QualifiedObjectName> listViews(Session var1, QualifiedTablePrefix var2);

    public Map<QualifiedObjectName, ViewInfo> getViews(Session var1, QualifiedTablePrefix var2);

    default public boolean isView(Session session, QualifiedObjectName viewName) {
        return this.getView(session, viewName).isPresent();
    }

    public Optional<ViewDefinition> getView(Session var1, QualifiedObjectName var2);

    public Map<String, Object> getSchemaProperties(Session var1, CatalogSchemaName var2);

    public Optional<TrinoPrincipal> getSchemaOwner(Session var1, CatalogSchemaName var2);

    public void createView(Session var1, QualifiedObjectName var2, ViewDefinition var3, boolean var4);

    public void renameView(Session var1, QualifiedObjectName var2, QualifiedObjectName var3);

    public void setViewAuthorization(Session var1, CatalogSchemaTableName var2, TrinoPrincipal var3);

    public void dropView(Session var1, QualifiedObjectName var2);

    public Optional<ResolvedIndex> resolveIndex(Session var1, TableHandle var2, Set<ColumnHandle> var3, Set<ColumnHandle> var4, TupleDomain<ColumnHandle> var5);

    public Optional<LimitApplicationResult<TableHandle>> applyLimit(Session var1, TableHandle var2, long var3);

    public Optional<ConstraintApplicationResult<TableHandle>> applyFilter(Session var1, TableHandle var2, Constraint var3);

    public Optional<ProjectionApplicationResult<TableHandle>> applyProjection(Session var1, TableHandle var2, List<ConnectorExpression> var3, Map<String, ColumnHandle> var4);

    public Optional<SampleApplicationResult<TableHandle>> applySample(Session var1, TableHandle var2, SampleType var3, double var4);

    public Optional<AggregationApplicationResult<TableHandle>> applyAggregation(Session var1, TableHandle var2, List<AggregateFunction> var3, Map<String, ColumnHandle> var4, List<List<ColumnHandle>> var5);

    public Optional<JoinApplicationResult<TableHandle>> applyJoin(Session var1, JoinType var2, TableHandle var3, TableHandle var4, ConnectorExpression var5, Map<String, ColumnHandle> var6, Map<String, ColumnHandle> var7, JoinStatistics var8);

    public Optional<TopNApplicationResult<TableHandle>> applyTopN(Session var1, TableHandle var2, long var3, List<SortItem> var5, Map<String, ColumnHandle> var6);

    public Optional<TableFunctionApplicationResult<TableHandle>> applyTableFunction(Session var1, TableFunctionHandle var2);

    default public void validateScan(Session session, TableHandle table) {
    }

    public boolean isCatalogManagedSecurity(Session var1, String var2);

    public boolean roleExists(Session var1, String var2, Optional<String> var3);

    public void createRole(Session var1, String var2, Optional<TrinoPrincipal> var3, Optional<String> var4);

    public void dropRole(Session var1, String var2, Optional<String> var3);

    public Set<String> listRoles(Session var1, Optional<String> var2);

    public Set<RoleGrant> listRoleGrants(Session var1, Optional<String> var2, TrinoPrincipal var3);

    public void grantRoles(Session var1, Set<String> var2, Set<TrinoPrincipal> var3, boolean var4, Optional<TrinoPrincipal> var5, Optional<String> var6);

    public void revokeRoles(Session var1, Set<String> var2, Set<TrinoPrincipal> var3, boolean var4, Optional<TrinoPrincipal> var5, Optional<String> var6);

    public Set<RoleGrant> listApplicableRoles(Session var1, TrinoPrincipal var2, Optional<String> var3);

    public Set<String> listEnabledRoles(Identity var1);

    public Set<String> listEnabledRoles(Session var1, String var2);

    public void grantSchemaPrivileges(Session var1, CatalogSchemaName var2, Set<Privilege> var3, TrinoPrincipal var4, boolean var5);

    public void denySchemaPrivileges(Session var1, CatalogSchemaName var2, Set<Privilege> var3, TrinoPrincipal var4);

    public void revokeSchemaPrivileges(Session var1, CatalogSchemaName var2, Set<Privilege> var3, TrinoPrincipal var4, boolean var5);

    public void grantTablePrivileges(Session var1, QualifiedObjectName var2, Set<Privilege> var3, TrinoPrincipal var4, boolean var5);

    public void denyTablePrivileges(Session var1, QualifiedObjectName var2, Set<Privilege> var3, TrinoPrincipal var4);

    public void revokeTablePrivileges(Session var1, QualifiedObjectName var2, Set<Privilege> var3, TrinoPrincipal var4, boolean var5);

    public List<GrantInfo> listTablePrivileges(Session var1, QualifiedTablePrefix var2);

    public Collection<FunctionMetadata> listFunctions(Session var1);

    public ResolvedFunction decodeFunction(QualifiedName var1);

    public ResolvedFunction resolveFunction(Session var1, QualifiedName var2, List<TypeSignatureProvider> var3);

    public ResolvedFunction resolveOperator(Session var1, OperatorType var2, List<? extends Type> var3) throws OperatorNotFoundException;

    default public ResolvedFunction getCoercion(Session session, Type fromType, Type toType) {
        return this.getCoercion(session, OperatorType.CAST, fromType, toType);
    }

    public ResolvedFunction getCoercion(Session var1, OperatorType var2, Type var3, Type var4);

    public ResolvedFunction getCoercion(Session var1, QualifiedName var2, Type var3, Type var4);

    public boolean isAggregationFunction(Session var1, QualifiedName var2);

    public FunctionMetadata getFunctionMetadata(Session var1, ResolvedFunction var2);

    public AggregationFunctionMetadata getAggregationFunctionMetadata(Session var1, ResolvedFunction var2);

    public void createMaterializedView(Session var1, QualifiedObjectName var2, MaterializedViewDefinition var3, boolean var4, boolean var5);

    public void dropMaterializedView(Session var1, QualifiedObjectName var2);

    public List<QualifiedObjectName> listMaterializedViews(Session var1, QualifiedTablePrefix var2);

    public Map<QualifiedObjectName, ViewInfo> getMaterializedViews(Session var1, QualifiedTablePrefix var2);

    default public boolean isMaterializedView(Session session, QualifiedObjectName viewName) {
        return this.getMaterializedView(session, viewName).isPresent();
    }

    public Optional<MaterializedViewDefinition> getMaterializedView(Session var1, QualifiedObjectName var2);

    public MaterializedViewFreshness getMaterializedViewFreshness(Session var1, QualifiedObjectName var2);

    public void renameMaterializedView(Session var1, QualifiedObjectName var2, QualifiedObjectName var3);

    public void setMaterializedViewProperties(Session var1, QualifiedObjectName var2, Map<String, Optional<Object>> var3);

    public Optional<TableScanRedirectApplicationResult> applyTableScanRedirect(Session var1, TableHandle var2);

    public RedirectionAwareTableHandle getRedirectionAwareTableHandle(Session var1, QualifiedObjectName var2);

    public RedirectionAwareTableHandle getRedirectionAwareTableHandle(Session var1, QualifiedObjectName var2, Optional<TableVersion> var3, Optional<TableVersion> var4);

    public boolean supportsReportingWrittenBytes(Session var1, TableHandle var2);

    public boolean supportsReportingWrittenBytes(Session var1, QualifiedObjectName var2, Map<String, Object> var3);

    public Optional<TableHandle> getTableHandle(Session var1, QualifiedObjectName var2, Optional<TableVersion> var3, Optional<TableVersion> var4);
}

