/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.trino.connector.CatalogHandle;
import io.trino.spi.connector.ConnectorOutputTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.SchemaTableName;
import java.util.Objects;

public final class OutputTableHandle {
    private final CatalogHandle catalogHandle;
    private final SchemaTableName tableName;
    private final ConnectorTransactionHandle transactionHandle;
    private final ConnectorOutputTableHandle connectorHandle;

    @JsonCreator
    public OutputTableHandle(@JsonProperty(value="catalogHandle") CatalogHandle catalogHandle, @JsonProperty(value="tableName") SchemaTableName tableName, @JsonProperty(value="transactionHandle") ConnectorTransactionHandle transactionHandle, @JsonProperty(value="connectorHandle") ConnectorOutputTableHandle connectorHandle) {
        this.catalogHandle = Objects.requireNonNull(catalogHandle, "catalogHandle is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.transactionHandle = Objects.requireNonNull(transactionHandle, "transactionHandle is null");
        this.connectorHandle = Objects.requireNonNull(connectorHandle, "connectorHandle is null");
    }

    @JsonProperty
    public CatalogHandle getCatalogHandle() {
        return this.catalogHandle;
    }

    @JsonProperty
    public SchemaTableName getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public ConnectorTransactionHandle getTransactionHandle() {
        return this.transactionHandle;
    }

    @JsonProperty
    public ConnectorOutputTableHandle getConnectorHandle() {
        return this.connectorHandle;
    }

    public int hashCode() {
        return Objects.hash(this.catalogHandle, this.transactionHandle, this.connectorHandle);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        OutputTableHandle other = (OutputTableHandle)obj;
        return Objects.equals(this.catalogHandle, other.catalogHandle) && Objects.equals(this.transactionHandle, other.transactionHandle) && Objects.equals(this.connectorHandle, other.connectorHandle);
    }

    public String toString() {
        return this.catalogHandle + ":" + this.connectorHandle;
    }
}

