/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.concurrent.MoreFutures;
import io.airlift.slice.Slice;
import io.trino.operator.Operator;
import io.trino.operator.OperatorContext;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.connector.UpdatablePageSource;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;

public abstract class AbstractRowChangeOperator
implements Operator {
    private static final List<Type> TYPES = ImmutableList.of((Object)BigintType.BIGINT, (Object)VarbinaryType.VARBINARY);
    private final OperatorContext operatorContext;
    protected State state = State.RUNNING;
    protected long rowCount;
    private boolean closed;
    protected ListenableFuture<Collection<Slice>> finishFuture;
    private ListenableFuture<Void> blockedFutureView;
    private Supplier<Optional<UpdatablePageSource>> pageSource = Optional::empty;

    public AbstractRowChangeOperator(OperatorContext operatorContext) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public void finish() {
        if (this.state == State.RUNNING) {
            this.state = State.FINISHING;
            this.finishFuture = MoreFutures.toListenableFuture((CompletableFuture)this.pageSource().finish());
            this.blockedFutureView = AbstractRowChangeOperator.asVoid(this.finishFuture);
        }
    }

    private static <T> ListenableFuture<Void> asVoid(ListenableFuture<T> future) {
        return Futures.transform(future, v -> null, (Executor)MoreExecutors.directExecutor());
    }

    @Override
    public boolean isFinished() {
        return this.state == State.FINISHED;
    }

    @Override
    public boolean needsInput() {
        return this.state == State.RUNNING;
    }

    @Override
    public abstract void addInput(Page var1);

    @Override
    public ListenableFuture<Void> isBlocked() {
        if (this.blockedFutureView == null) {
            return NOT_BLOCKED;
        }
        return this.blockedFutureView;
    }

    @Override
    public Page getOutput() {
        if (this.state != State.FINISHING || !this.finishFuture.isDone()) {
            return null;
        }
        this.state = State.FINISHED;
        Collection fragments = (Collection)MoreFutures.getFutureValue(this.finishFuture);
        PageBuilder page = new PageBuilder(fragments.size() + 1, TYPES);
        BlockBuilder rowsBuilder = page.getBlockBuilder(0);
        BlockBuilder fragmentBuilder = page.getBlockBuilder(1);
        page.declarePosition();
        BigintType.BIGINT.writeLong(rowsBuilder, this.rowCount);
        fragmentBuilder.appendNull();
        for (Slice fragment : fragments) {
            page.declarePosition();
            rowsBuilder.appendNull();
            VarbinaryType.VARBINARY.writeSlice(fragmentBuilder, fragment);
        }
        return page.build();
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            if (this.finishFuture != null) {
                this.finishFuture.cancel(true);
            } else {
                this.pageSource.get().ifPresent(UpdatablePageSource::abort);
                this.abort();
            }
        }
    }

    public void setPageSource(Supplier<Optional<UpdatablePageSource>> pageSource) {
        this.pageSource = Objects.requireNonNull(pageSource, "pageSource is null");
    }

    protected UpdatablePageSource pageSource() {
        Optional<UpdatablePageSource> source = this.pageSource.get();
        Preconditions.checkState((boolean)source.isPresent(), (Object)"pageSource not set");
        return source.get();
    }

    protected void abort() {
    }

    protected static enum State {
        RUNNING,
        FINISHING,
        FINISHED;

    }
}

