/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.minmaxn;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import io.airlift.slice.SizeOf;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import java.lang.invoke.MethodHandle;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class TypedHeap {
    private static final int INSTANCE_SIZE = Math.toIntExact(ClassLayout.parseClass(TypedHeap.class).instanceSize());
    private static final int COMPACT_THRESHOLD_BYTES = 32768;
    private static final int COMPACT_THRESHOLD_RATIO = 3;
    private final boolean min;
    private final MethodHandle compare;
    private final Type elementType;
    private final int capacity;
    private int positionCount;
    private final int[] heapIndex;
    private BlockBuilder heapBlockBuilder;

    public TypedHeap(boolean min, MethodHandle compare, Type elementType, int capacity) {
        this.min = min;
        this.compare = Objects.requireNonNull(compare, "compare is null");
        this.elementType = Objects.requireNonNull(elementType, "elementType is null");
        this.capacity = capacity;
        this.heapIndex = new int[capacity];
        this.heapBlockBuilder = elementType.createBlockBuilder(null, capacity);
    }

    private TypedHeap(boolean min, MethodHandle compare, Type elementType, int capacity, int positionCount, int[] heapIndex, BlockBuilder heapBlockBuilder) {
        this.min = min;
        this.compare = Objects.requireNonNull(compare, "compare is null");
        this.elementType = Objects.requireNonNull(elementType, "elementType is null");
        this.capacity = capacity;
        this.positionCount = positionCount;
        this.heapIndex = heapIndex;
        this.heapBlockBuilder = heapBlockBuilder;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public long getEstimatedSize() {
        return (long)INSTANCE_SIZE + (this.heapBlockBuilder == null ? 0L : this.heapBlockBuilder.getRetainedSizeInBytes()) + SizeOf.sizeOf((int[])this.heapIndex);
    }

    public boolean isEmpty() {
        return this.positionCount == 0;
    }

    public void serialize(BlockBuilder out) {
        BlockBuilder blockBuilder = out.beginBlockEntry();
        BigintType.BIGINT.writeLong(blockBuilder, (long)this.capacity);
        BlockBuilder elements = blockBuilder.beginBlockEntry();
        for (int i = 0; i < this.positionCount; ++i) {
            this.elementType.appendTo((Block)this.heapBlockBuilder, this.heapIndex[i], elements);
        }
        blockBuilder.closeEntry();
        out.closeEntry();
    }

    public static TypedHeap deserialize(boolean min, MethodHandle compare, Type elementType, Block rowBlock) {
        int capacity = Math.toIntExact(BigintType.BIGINT.getLong(rowBlock, 0));
        int[] heapIndex = new int[capacity];
        BlockBuilder heapBlockBuilder = elementType.createBlockBuilder(null, capacity);
        Block heapBlock = new ArrayType(elementType).getObject(rowBlock, 1);
        for (int position = 0; position < heapBlock.getPositionCount(); ++position) {
            heapIndex[position] = position;
            elementType.appendTo(heapBlock, position, heapBlockBuilder);
        }
        return new TypedHeap(min, compare, elementType, capacity, heapBlock.getPositionCount(), heapIndex, heapBlockBuilder);
    }

    public void popAllReverse(BlockBuilder resultBlockBuilder) {
        int[] indexes = new int[this.positionCount];
        while (this.positionCount > 0) {
            indexes[this.positionCount - 1] = this.heapIndex[0];
            --this.positionCount;
            this.heapIndex[0] = this.heapIndex[this.positionCount];
            this.siftDown();
        }
        for (int index : indexes) {
            this.elementType.appendTo((Block)this.heapBlockBuilder, index, resultBlockBuilder);
        }
    }

    public void popAll(BlockBuilder resultBlockBuilder) {
        while (this.positionCount > 0) {
            this.pop(resultBlockBuilder);
        }
    }

    public void pop(BlockBuilder resultBlockBuilder) {
        this.elementType.appendTo((Block)this.heapBlockBuilder, this.heapIndex[0], resultBlockBuilder);
        this.remove();
    }

    private void remove() {
        --this.positionCount;
        this.heapIndex[0] = this.heapIndex[this.positionCount];
        this.siftDown();
    }

    public void add(Block block, int position) {
        Preconditions.checkArgument((!block.isNull(position) ? 1 : 0) != 0);
        if (this.positionCount == this.capacity) {
            if (this.keyGreaterThanOrEqual((Block)this.heapBlockBuilder, this.heapIndex[0], block, position)) {
                return;
            }
            this.heapIndex[0] = this.heapBlockBuilder.getPositionCount();
            this.elementType.appendTo(block, position, this.heapBlockBuilder);
            this.siftDown();
        } else {
            this.heapIndex[this.positionCount] = this.heapBlockBuilder.getPositionCount();
            ++this.positionCount;
            this.elementType.appendTo(block, position, this.heapBlockBuilder);
            this.siftUp();
        }
        this.compactIfNecessary();
    }

    public void addAll(TypedHeap other) {
        for (int i = 0; i < other.positionCount; ++i) {
            this.add((Block)other.heapBlockBuilder, other.heapIndex[i]);
        }
    }

    public void addAll(Block block) {
        for (int i = 0; i < block.getPositionCount(); ++i) {
            this.add(block, i);
        }
    }

    private void siftDown() {
        int leftPosition;
        int position = 0;
        while ((leftPosition = position * 2 + 1) < this.positionCount) {
            int smallerChildPosition;
            int rightPosition = leftPosition + 1;
            if (rightPosition >= this.positionCount) {
                smallerChildPosition = leftPosition;
            } else {
                int n = smallerChildPosition = this.keyGreaterThanOrEqual((Block)this.heapBlockBuilder, this.heapIndex[leftPosition], (Block)this.heapBlockBuilder, this.heapIndex[rightPosition]) ? rightPosition : leftPosition;
            }
            if (this.keyGreaterThanOrEqual((Block)this.heapBlockBuilder, this.heapIndex[smallerChildPosition], (Block)this.heapBlockBuilder, this.heapIndex[position])) break;
            int swapTemp = this.heapIndex[position];
            this.heapIndex[position] = this.heapIndex[smallerChildPosition];
            this.heapIndex[smallerChildPosition] = swapTemp;
            position = smallerChildPosition;
        }
    }

    private void siftUp() {
        int parentPosition;
        int position = this.positionCount - 1;
        while (position != 0 && !this.keyGreaterThanOrEqual((Block)this.heapBlockBuilder, this.heapIndex[position], (Block)this.heapBlockBuilder, this.heapIndex[parentPosition = (position - 1) / 2])) {
            int swapTemp = this.heapIndex[position];
            this.heapIndex[position] = this.heapIndex[parentPosition];
            this.heapIndex[parentPosition] = swapTemp;
            position = parentPosition;
        }
    }

    private void compactIfNecessary() {
        if (this.heapBlockBuilder.getSizeInBytes() < 32768L || this.heapBlockBuilder.getPositionCount() / this.positionCount < 3) {
            return;
        }
        BlockBuilder newHeapBlockBuilder = this.elementType.createBlockBuilder(null, this.heapBlockBuilder.getPositionCount());
        for (int i = 0; i < this.positionCount; ++i) {
            this.elementType.appendTo((Block)this.heapBlockBuilder, this.heapIndex[i], newHeapBlockBuilder);
            this.heapIndex[i] = i;
        }
        this.heapBlockBuilder = newHeapBlockBuilder;
    }

    private boolean keyGreaterThanOrEqual(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        try {
            long result = this.compare.invokeExact(leftBlock, leftPosition, rightBlock, rightPosition);
            return this.min ? result < 0L : result > 0L;
        }
        catch (Throwable throwable) {
            Throwables.throwIfUnchecked((Throwable)throwable);
            throw new RuntimeException(throwable);
        }
    }

    public TypedHeap copy() {
        BlockBuilder heapBlockBuilderCopy = null;
        if (this.heapBlockBuilder != null) {
            heapBlockBuilderCopy = (BlockBuilder)this.heapBlockBuilder.copyRegion(0, this.heapBlockBuilder.getPositionCount());
        }
        return new TypedHeap(this.min, this.compare, this.elementType, this.capacity, this.positionCount, (int[])this.heapIndex.clone(), heapBlockBuilderCopy);
    }
}

