/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.multimapagg;

import io.trino.operator.aggregation.BlockBuilderCopier;
import io.trino.operator.aggregation.multimapagg.MultimapAggregationState;
import io.trino.operator.aggregation.multimapagg.MultimapAggregationStateConsumer;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AccumulatorState;
import io.trino.spi.type.Type;
import io.trino.type.TypeUtils;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class SingleMultimapAggregationState
implements MultimapAggregationState {
    private static final int INSTANCE_SIZE = Math.toIntExact(ClassLayout.parseClass(SingleMultimapAggregationState.class).instanceSize());
    private static final int EXPECTED_ENTRIES = 10;
    private static final int EXPECTED_ENTRY_SIZE = 16;
    private final Type keyType;
    private final Type valueType;
    private BlockBuilder keyBlockBuilder;
    private BlockBuilder valueBlockBuilder;

    public SingleMultimapAggregationState(Type keyType, Type valueType) {
        this.keyType = Objects.requireNonNull(keyType);
        this.valueType = Objects.requireNonNull(valueType);
        this.keyBlockBuilder = keyType.createBlockBuilder(null, 10, TypeUtils.expectedValueSize(keyType, 16));
        this.valueBlockBuilder = valueType.createBlockBuilder(null, 10, TypeUtils.expectedValueSize(valueType, 16));
    }

    private SingleMultimapAggregationState(Type keyType, Type valueType, BlockBuilder keyBlockBuilder, BlockBuilder valueBlockBuilder) {
        this.keyType = keyType;
        this.valueType = valueType;
        this.keyBlockBuilder = keyBlockBuilder;
        this.valueBlockBuilder = valueBlockBuilder;
    }

    @Override
    public void add(Block key, Block value, int position) {
        this.keyType.appendTo(key, position, this.keyBlockBuilder);
        this.valueType.appendTo(value, position, this.valueBlockBuilder);
    }

    @Override
    public void forEach(MultimapAggregationStateConsumer consumer) {
        for (int i = 0; i < this.keyBlockBuilder.getPositionCount(); ++i) {
            consumer.accept((Block)this.keyBlockBuilder, (Block)this.valueBlockBuilder, i);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.keyBlockBuilder.getPositionCount() == 0;
    }

    @Override
    public int getEntryCount() {
        return this.keyBlockBuilder.getPositionCount();
    }

    public long getEstimatedSize() {
        return (long)INSTANCE_SIZE + this.keyBlockBuilder.getRetainedSizeInBytes() + this.valueBlockBuilder.getRetainedSizeInBytes();
    }

    @Override
    public void reset() {
        this.keyBlockBuilder = this.keyBlockBuilder.newBlockBuilderLike(null);
        this.valueBlockBuilder = this.valueBlockBuilder.newBlockBuilderLike(null);
    }

    public AccumulatorState copy() {
        return new SingleMultimapAggregationState(this.keyType, this.valueType, BlockBuilderCopier.copyBlockBuilder(this.keyType, this.keyBlockBuilder), BlockBuilderCopier.copyBlockBuilder(this.valueType, this.valueBlockBuilder));
    }
}

