/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.exchange;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import io.airlift.slice.XxHash64;
import io.airlift.units.DataSize;
import io.trino.Session;
import io.trino.operator.BucketPartitionFunction;
import io.trino.operator.HashGenerator;
import io.trino.operator.InterpretedHashGenerator;
import io.trino.operator.PartitionFunction;
import io.trino.operator.PrecomputedHashGenerator;
import io.trino.operator.exchange.BroadcastExchanger;
import io.trino.operator.exchange.LocalExchangeMemoryManager;
import io.trino.operator.exchange.LocalExchangeSink;
import io.trino.operator.exchange.LocalExchangeSource;
import io.trino.operator.exchange.LocalExchanger;
import io.trino.operator.exchange.LocalPartitionGenerator;
import io.trino.operator.exchange.PartitioningExchanger;
import io.trino.operator.exchange.PassthroughExchanger;
import io.trino.operator.exchange.RandomExchanger;
import io.trino.operator.exchange.ScaleWriterExchanger;
import io.trino.spi.Page;
import io.trino.spi.connector.ConnectorPartitioningHandle;
import io.trino.spi.type.Type;
import io.trino.sql.planner.MergePartitioningHandle;
import io.trino.sql.planner.NodePartitioningManager;
import io.trino.sql.planner.PartitioningHandle;
import io.trino.sql.planner.SystemPartitioningHandle;
import io.trino.type.BlockTypeOperators;
import java.io.Closeable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class LocalExchange {
    private final Supplier<LocalExchanger> exchangerSupplier;
    private final List<LocalExchangeSource> sources;
    private final LocalExchangeMemoryManager memoryManager;
    @GuardedBy(value="this")
    private boolean allSourcesFinished;
    @GuardedBy(value="this")
    private boolean noMoreSinkFactories;
    @GuardedBy(value="this")
    private final Set<LocalExchangeSinkFactory> openSinkFactories = new HashSet<LocalExchangeSinkFactory>();
    @GuardedBy(value="this")
    private final Set<LocalExchangeSink> sinks = new HashSet<LocalExchangeSink>();
    @GuardedBy(value="this")
    private int nextSourceIndex;

    public LocalExchange(NodePartitioningManager nodePartitioningManager, Session session, int defaultConcurrency, PartitioningHandle partitioning, List<Integer> partitionChannels, List<Type> partitionChannelTypes, Optional<Integer> partitionHashChannel, DataSize maxBufferedBytes, BlockTypeOperators blockTypeOperators, Supplier<Long> physicalWrittenBytesSupplier, DataSize writerMinSize) {
        ImmutableList.Builder sources = ImmutableList.builder();
        int bufferCount = LocalExchange.computeBufferCount(partitioning, defaultConcurrency, partitionChannels);
        for (int i = 0; i < bufferCount; ++i) {
            sources.add((Object)new LocalExchangeSource(source -> this.checkAllSourcesFinished()));
        }
        this.sources = sources.build();
        List buffers = (List)this.sources.stream().map(buffer -> buffer::addPage).collect(ImmutableList.toImmutableList());
        this.memoryManager = new LocalExchangeMemoryManager(maxBufferedBytes.toBytes());
        if (partitioning.equals(SystemPartitioningHandle.SINGLE_DISTRIBUTION)) {
            this.exchangerSupplier = () -> new BroadcastExchanger(buffers, this.memoryManager);
        } else if (partitioning.equals(SystemPartitioningHandle.FIXED_BROADCAST_DISTRIBUTION)) {
            this.exchangerSupplier = () -> new BroadcastExchanger(buffers, this.memoryManager);
        } else if (partitioning.equals(SystemPartitioningHandle.FIXED_ARBITRARY_DISTRIBUTION)) {
            this.exchangerSupplier = () -> new RandomExchanger(buffers, this.memoryManager);
        } else if (partitioning.equals(SystemPartitioningHandle.FIXED_PASSTHROUGH_DISTRIBUTION)) {
            Iterator<LocalExchangeSource> sourceIterator = this.sources.iterator();
            this.exchangerSupplier = () -> {
                Preconditions.checkState((boolean)sourceIterator.hasNext(), (Object)"no more sources");
                return new PassthroughExchanger((LocalExchangeSource)sourceIterator.next(), maxBufferedBytes.toBytes() / (long)bufferCount, this.memoryManager::updateMemoryUsage);
            };
        } else if (partitioning.equals(SystemPartitioningHandle.SCALED_WRITER_DISTRIBUTION)) {
            this.exchangerSupplier = () -> new ScaleWriterExchanger(buffers, this.memoryManager, maxBufferedBytes.toBytes(), physicalWrittenBytesSupplier, writerMinSize);
        } else if (partitioning.equals(SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION) || partitioning.getCatalogHandle().isPresent() || partitioning.getConnectorHandle() instanceof MergePartitioningHandle) {
            this.exchangerSupplier = () -> {
                Function<Page, Page> partitionPagePreparer;
                PartitionFunction partitionFunction = LocalExchange.createPartitionFunction(nodePartitioningManager, session, blockTypeOperators, partitioning, bufferCount, partitionChannels, partitionChannelTypes, partitionHashChannel);
                if (LocalExchange.isSystemPartitioning(partitioning)) {
                    partitionPagePreparer = Function.identity();
                } else {
                    int[] partitionChannelsArray = Ints.toArray((Collection)partitionChannels);
                    partitionPagePreparer = page -> page.getColumns(partitionChannelsArray);
                }
                return new PartitioningExchanger(buffers, this.memoryManager, partitionPagePreparer, partitionFunction);
            };
        } else {
            throw new IllegalArgumentException("Unsupported local exchange partitioning " + partitioning);
        }
    }

    public int getBufferCount() {
        return this.sources.size();
    }

    public long getBufferedBytes() {
        return this.memoryManager.getBufferedBytes();
    }

    public synchronized LocalExchangeSinkFactory createSinkFactory() {
        Preconditions.checkState((!this.noMoreSinkFactories ? 1 : 0) != 0, (Object)"No more sink factories already set");
        LocalExchangeSinkFactory newFactory = new LocalExchangeSinkFactory(this);
        this.openSinkFactories.add(newFactory);
        return newFactory;
    }

    public synchronized LocalExchangeSource getNextSource() {
        Preconditions.checkState((this.nextSourceIndex < this.sources.size() ? 1 : 0) != 0, (Object)"All operators already created");
        LocalExchangeSource result = this.sources.get(this.nextSourceIndex);
        ++this.nextSourceIndex;
        return result;
    }

    @VisibleForTesting
    LocalExchangeSource getSource(int partitionIndex) {
        return this.sources.get(partitionIndex);
    }

    private static PartitionFunction createPartitionFunction(NodePartitioningManager nodePartitioningManager, Session session, BlockTypeOperators blockTypeOperators, PartitioningHandle partitioning, int partitionCount, List<Integer> partitionChannels, List<Type> partitionChannelTypes, Optional<Integer> partitionHashChannel) {
        Preconditions.checkArgument((Integer.bitCount(partitionCount) == 1 ? 1 : 0) != 0, (Object)"partitionCount must be a power of 2");
        if (LocalExchange.isSystemPartitioning(partitioning)) {
            HashGenerator hashGenerator = partitionHashChannel.isPresent() ? new PrecomputedHashGenerator(partitionHashChannel.get()) : new InterpretedHashGenerator(partitionChannelTypes, Ints.toArray(partitionChannels), blockTypeOperators);
            return new LocalPartitionGenerator(hashGenerator, partitionCount);
        }
        int bucketCount = nodePartitioningManager.getBucketCount(session, partitioning);
        int[] bucketToPartition = new int[bucketCount];
        for (int bucket = 0; bucket < bucketCount; ++bucket) {
            int hashedBucket = (int)XxHash64.hash((long)Long.reverse(bucket));
            bucketToPartition[bucket] = hashedBucket & partitionCount - 1;
        }
        ConnectorPartitioningHandle connectorPartitioningHandle = partitioning.getConnectorHandle();
        if (connectorPartitioningHandle instanceof MergePartitioningHandle) {
            MergePartitioningHandle handle = (MergePartitioningHandle)connectorPartitioningHandle;
            return handle.getPartitionFunction((scheme, types) -> nodePartitioningManager.getPartitionFunction(session, scheme, types, bucketToPartition), partitionChannelTypes, bucketToPartition);
        }
        return new BucketPartitionFunction(nodePartitioningManager.getBucketFunction(session, partitioning, partitionChannelTypes, bucketCount), bucketToPartition);
    }

    private static boolean isSystemPartitioning(PartitioningHandle partitioning) {
        return partitioning.getConnectorHandle() instanceof SystemPartitioningHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAllSourcesFinished() {
        ImmutableList openSinks;
        LocalExchange.checkNotHoldsLock(this);
        if (!this.sources.stream().allMatch(LocalExchangeSource::isFinished)) {
            return;
        }
        LocalExchange localExchange = this;
        synchronized (localExchange) {
            this.allSourcesFinished = true;
            openSinks = ImmutableList.copyOf(this.sinks);
            this.sinks.clear();
        }
        openSinks.forEach(LocalExchangeSink::finish);
        this.checkAllSinksComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LocalExchangeSink createSink(LocalExchangeSinkFactory factory) {
        LocalExchange.checkNotHoldsLock(this);
        LocalExchange localExchange = this;
        synchronized (localExchange) {
            Preconditions.checkState((boolean)this.openSinkFactories.contains(factory), (Object)"Factory is already closed");
            if (this.allSourcesFinished) {
                return LocalExchangeSink.finishedLocalExchangeSink();
            }
            LocalExchanger exchanger = this.exchangerSupplier.get();
            LocalExchangeSink sink = new LocalExchangeSink(exchanger, this::sinkFinished);
            this.sinks.add(sink);
            return sink;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sinkFinished(LocalExchangeSink sink) {
        LocalExchange.checkNotHoldsLock(this);
        LocalExchange localExchange = this;
        synchronized (localExchange) {
            this.sinks.remove(sink);
        }
        this.checkAllSinksComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void noMoreSinkFactories() {
        LocalExchange.checkNotHoldsLock(this);
        LocalExchange localExchange = this;
        synchronized (localExchange) {
            this.noMoreSinkFactories = true;
        }
        this.checkAllSinksComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sinkFactoryClosed(LocalExchangeSinkFactory sinkFactory) {
        LocalExchange.checkNotHoldsLock(this);
        LocalExchange localExchange = this;
        synchronized (localExchange) {
            this.openSinkFactories.remove(sinkFactory);
        }
        this.checkAllSinksComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAllSinksComplete() {
        LocalExchange.checkNotHoldsLock(this);
        LocalExchange localExchange = this;
        synchronized (localExchange) {
            if (!(this.noMoreSinkFactories && this.openSinkFactories.isEmpty() && this.sinks.isEmpty())) {
                return;
            }
        }
        this.sources.forEach(LocalExchangeSource::finish);
    }

    private static void checkNotHoldsLock(Object lock) {
        Preconditions.checkState((!Thread.holdsLock(lock) ? 1 : 0) != 0, (Object)"Cannot execute this method while holding a lock");
    }

    private static int computeBufferCount(PartitioningHandle partitioning, int defaultConcurrency, List<Integer> partitionChannels) {
        int bufferCount;
        if (partitioning.equals(SystemPartitioningHandle.SINGLE_DISTRIBUTION)) {
            bufferCount = 1;
            Preconditions.checkArgument((boolean)partitionChannels.isEmpty(), (Object)"Gather exchange must not have partition channels");
        } else if (partitioning.equals(SystemPartitioningHandle.FIXED_BROADCAST_DISTRIBUTION)) {
            bufferCount = defaultConcurrency;
            Preconditions.checkArgument((boolean)partitionChannels.isEmpty(), (Object)"Broadcast exchange must not have partition channels");
        } else if (partitioning.equals(SystemPartitioningHandle.FIXED_ARBITRARY_DISTRIBUTION)) {
            bufferCount = defaultConcurrency;
            Preconditions.checkArgument((boolean)partitionChannels.isEmpty(), (Object)"Arbitrary exchange must not have partition channels");
        } else if (partitioning.equals(SystemPartitioningHandle.FIXED_PASSTHROUGH_DISTRIBUTION)) {
            bufferCount = defaultConcurrency;
            Preconditions.checkArgument((boolean)partitionChannels.isEmpty(), (Object)"Passthrough exchange must not have partition channels");
        } else if (partitioning.equals(SystemPartitioningHandle.SCALED_WRITER_DISTRIBUTION)) {
            bufferCount = defaultConcurrency;
            Preconditions.checkArgument((boolean)partitionChannels.isEmpty(), (Object)"Scaled writer exchange must not have partition channels");
        } else if (partitioning.equals(SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION) || partitioning.getCatalogHandle().isPresent() || partitioning.getConnectorHandle() instanceof MergePartitioningHandle) {
            bufferCount = defaultConcurrency;
        } else {
            throw new IllegalArgumentException("Unsupported local exchange partitioning " + partitioning);
        }
        return bufferCount;
    }

    @ThreadSafe
    public static class LocalExchangeSinkFactory
    implements Closeable {
        private final LocalExchange exchange;

        private LocalExchangeSinkFactory(LocalExchange exchange) {
            this.exchange = Objects.requireNonNull(exchange, "exchange is null");
        }

        public LocalExchangeSink createSink() {
            return this.exchange.createSink(this);
        }

        public LocalExchangeSinkFactory duplicate() {
            return this.exchange.createSinkFactory();
        }

        @Override
        public void close() {
            this.exchange.sinkFactoryClosed(this);
        }

        public void noMoreSinkFactories() {
            this.exchange.noMoreSinkFactories();
        }
    }
}

