/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.join.unspilled;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import io.trino.operator.join.LookupSource;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.type.BigintType;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.stream.IntStream;
import javax.annotation.Nullable;

public class JoinProbe {
    private final int[] probeOutputChannels;
    private final Page page;
    private final long[] joinPositionCache;
    private int position = -1;

    private JoinProbe(int[] probeOutputChannels, Page page, Page probePage, LookupSource lookupSource, @Nullable Block probeHashBlock) {
        this.probeOutputChannels = Objects.requireNonNull(probeOutputChannels, "probeOutputChannels is null");
        this.page = Objects.requireNonNull(page, "page is null");
        this.joinPositionCache = JoinProbe.fillCache(lookupSource, page, probeHashBlock, probePage);
    }

    public int[] getOutputChannels() {
        return this.probeOutputChannels;
    }

    public boolean advanceNextPosition() {
        Verify.verify((++this.position <= this.page.getPositionCount() ? 1 : 0) != 0, (String)"already finished", (Object[])new Object[0]);
        return !this.isFinished();
    }

    public boolean isFinished() {
        return this.position == this.page.getPositionCount();
    }

    public long getCurrentJoinPosition() {
        return this.joinPositionCache[this.position];
    }

    public int getPosition() {
        return this.position;
    }

    public Page getPage() {
        return this.page;
    }

    private static long[] fillCache(LookupSource lookupSource, Page page, Block probeHashBlock, Page probePage) {
        int positionCount = page.getPositionCount();
        List nullableBlocks = (List)IntStream.range(0, probePage.getChannelCount()).mapToObj(i -> probePage.getBlock(i)).filter(Block::mayHaveNull).collect(ImmutableList.toImmutableList());
        long[] joinPositionCache = new long[positionCount];
        if (!nullableBlocks.isEmpty()) {
            Arrays.fill(joinPositionCache, -1L);
            boolean[] isNull = new boolean[positionCount];
            int nonNullCount = JoinProbe.getIsNull(nullableBlocks, positionCount, isNull);
            if (nonNullCount < positionCount) {
                int[] positions = new int[nonNullCount];
                nonNullCount = 0;
                for (int i2 = 0; i2 < positionCount; ++i2) {
                    if (!isNull[i2]) {
                        positions[nonNullCount] = i2;
                    }
                    nonNullCount += isNull[i2] ? 0 : 1;
                }
                if (probeHashBlock != null) {
                    long[] hashes = new long[positionCount];
                    for (int i3 = 0; i3 < positionCount; ++i3) {
                        hashes[i3] = BigintType.BIGINT.getLong(probeHashBlock, i3);
                    }
                    lookupSource.getJoinPosition(positions, probePage, page, hashes, joinPositionCache);
                } else {
                    lookupSource.getJoinPosition(positions, probePage, page, joinPositionCache);
                }
                return joinPositionCache;
            }
        }
        int[] positions = new int[positionCount];
        for (int i4 = 0; i4 < positionCount; ++i4) {
            positions[i4] = i4;
        }
        if (probeHashBlock != null) {
            long[] hashes = new long[positionCount];
            for (int i5 = 0; i5 < positionCount; ++i5) {
                hashes[i5] = BigintType.BIGINT.getLong(probeHashBlock, i5);
            }
            lookupSource.getJoinPosition(positions, probePage, page, hashes, joinPositionCache);
        } else {
            lookupSource.getJoinPosition(positions, probePage, page, joinPositionCache);
        }
        return joinPositionCache;
    }

    private static int getIsNull(List<Block> nullableBlocks, int positionCount, boolean[] isNull) {
        int position;
        for (int i = 0; i < nullableBlocks.size() - 1; ++i) {
            Block block = nullableBlocks.get(i);
            for (position = 0; position < positionCount; ++position) {
                int n = position;
                isNull[n] = isNull[n] | block.isNull(position);
            }
        }
        int nonNullCount = 0;
        Block lastBlock = nullableBlocks.get(nullableBlocks.size() - 1);
        for (position = 0; position < positionCount; ++position) {
            int n = position;
            isNull[n] = isNull[n] | lastBlock.isNull(position);
            nonNullCount += isNull[position] ? 0 : 1;
        }
        return nonNullCount;
    }

    public static class JoinProbeFactory {
        private final int[] probeOutputChannels;
        private final int[] probeJoinChannels;
        private final int probeHashChannel;

        public JoinProbeFactory(List<Integer> probeOutputChannels, List<Integer> probeJoinChannels, OptionalInt probeHashChannel) {
            this.probeOutputChannels = Ints.toArray((Collection)Objects.requireNonNull(probeOutputChannels, "probeOutputChannels is null"));
            this.probeJoinChannels = Ints.toArray((Collection)Objects.requireNonNull(probeJoinChannels, "probeJoinChannels is null"));
            this.probeHashChannel = Objects.requireNonNull(probeHashChannel, "probeHashChannel is null").orElse(-1);
        }

        public JoinProbe createJoinProbe(Page page, LookupSource lookupSource) {
            Page probePage = page.getLoadedPage(this.probeJoinChannels);
            return new JoinProbe(this.probeOutputChannels, page, probePage, lookupSource, this.probeHashChannel >= 0 ? page.getBlock(this.probeHashChannel).getLoadedBlock() : null);
        }
    }
}

