/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.output;

import io.airlift.slice.SizeOf;
import io.trino.operator.output.PositionsAppender;
import io.trino.operator.output.PositionsAppenderUtil;
import io.trino.spi.block.Block;
import io.trino.spi.block.IntArrayBlock;
import io.trino.spi.block.RunLengthEncodedBlock;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Arrays;
import java.util.Optional;
import org.openjdk.jol.info.ClassLayout;

public class IntPositionsAppender
implements PositionsAppender {
    private static final int INSTANCE_SIZE = Math.toIntExact(ClassLayout.parseClass(IntPositionsAppender.class).instanceSize());
    private static final Block NULL_VALUE_BLOCK = new IntArrayBlock(1, Optional.of(new boolean[]{true}), new int[1]);
    private boolean initialized;
    private int initialEntryCount;
    private int positionCount;
    private boolean hasNullValue;
    private boolean hasNonNullValue;
    private boolean[] valueIsNull = new boolean[0];
    private int[] values = new int[0];
    private long retainedSizeInBytes;
    private long sizeInBytes;

    public IntPositionsAppender(int expectedEntries) {
        this.initialEntryCount = Math.max(expectedEntries, 1);
        this.updateRetainedSize();
    }

    @Override
    public void append(IntArrayList positions, Block block) {
        if (positions.isEmpty()) {
            return;
        }
        int[] positionArray = positions.elements();
        int positionsSize = positions.size();
        this.ensureCapacity(this.positionCount + positionsSize);
        if (block.mayHaveNull()) {
            for (int i = 0; i < positionsSize; ++i) {
                int position = positionArray[i];
                boolean isNull = block.isNull(position);
                int positionIndex = this.positionCount + i;
                if (isNull) {
                    this.valueIsNull[positionIndex] = true;
                    this.hasNullValue = true;
                    continue;
                }
                this.values[positionIndex] = block.getInt(position, 0);
                this.hasNonNullValue = true;
            }
            this.positionCount += positionsSize;
        } else {
            for (int i = 0; i < positionsSize; ++i) {
                int position = positionArray[i];
                this.values[this.positionCount + i] = block.getInt(position, 0);
            }
            this.positionCount += positionsSize;
            this.hasNonNullValue = true;
        }
        this.updateSize(positionsSize);
    }

    @Override
    public void appendRle(Block block, int rlePositionCount) {
        if (rlePositionCount == 0) {
            return;
        }
        int sourcePosition = 0;
        this.ensureCapacity(this.positionCount + rlePositionCount);
        if (block.isNull(sourcePosition)) {
            Arrays.fill(this.valueIsNull, this.positionCount, this.positionCount + rlePositionCount, true);
            this.hasNullValue = true;
        } else {
            int value = block.getInt(sourcePosition, 0);
            Arrays.fill(this.values, this.positionCount, this.positionCount + rlePositionCount, value);
            this.hasNonNullValue = true;
        }
        this.positionCount += rlePositionCount;
        this.updateSize(rlePositionCount);
    }

    @Override
    public Block build() {
        Object result = this.hasNonNullValue ? new IntArrayBlock(this.positionCount, this.hasNullValue ? Optional.of(this.valueIsNull) : Optional.empty(), this.values) : RunLengthEncodedBlock.create((Block)NULL_VALUE_BLOCK, (int)this.positionCount);
        this.reset();
        return result;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return this.retainedSizeInBytes;
    }

    @Override
    public long getSizeInBytes() {
        return this.sizeInBytes;
    }

    private void reset() {
        this.initialEntryCount = PositionsAppenderUtil.calculateBlockResetSize(this.positionCount);
        this.initialized = false;
        this.valueIsNull = new boolean[0];
        this.values = new int[0];
        this.positionCount = 0;
        this.sizeInBytes = 0L;
        this.hasNonNullValue = false;
        this.hasNullValue = false;
        this.updateRetainedSize();
    }

    private void ensureCapacity(int capacity) {
        int newSize;
        if (this.values.length >= capacity) {
            return;
        }
        if (this.initialized) {
            newSize = PositionsAppenderUtil.calculateNewArraySize(this.values.length);
        } else {
            newSize = this.initialEntryCount;
            this.initialized = true;
        }
        newSize = Math.max(newSize, capacity);
        this.valueIsNull = Arrays.copyOf(this.valueIsNull, newSize);
        this.values = Arrays.copyOf(this.values, newSize);
        this.updateRetainedSize();
    }

    private void updateSize(long positionsSize) {
        this.sizeInBytes += 5L * positionsSize;
    }

    private void updateRetainedSize() {
        this.retainedSizeInBytes = (long)INSTANCE_SIZE + SizeOf.sizeOf((boolean[])this.valueIsNull) + SizeOf.sizeOf((int[])this.values);
    }
}

