/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.output;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.slice.Slice;
import io.trino.execution.buffer.OutputBuffer;
import io.trino.execution.buffer.PageSplitterUtil;
import io.trino.execution.buffer.PagesSerde;
import io.trino.execution.buffer.PagesSerdeFactory;
import io.trino.operator.DriverContext;
import io.trino.operator.Operator;
import io.trino.operator.OperatorContext;
import io.trino.operator.OperatorFactory;
import io.trino.operator.OutputFactory;
import io.trino.spi.Page;
import io.trino.spi.type.Type;
import io.trino.sql.planner.plan.PlanNodeId;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public class TaskOutputOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final OutputBuffer outputBuffer;
    private final Function<Page, Page> pagePreprocessor;
    private final PagesSerde serde;
    private ListenableFuture<Void> isBlocked = NOT_BLOCKED;
    private boolean finished;

    public TaskOutputOperator(OperatorContext operatorContext, OutputBuffer outputBuffer, Function<Page, Page> pagePreprocessor, PagesSerdeFactory serdeFactory) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.outputBuffer = Objects.requireNonNull(outputBuffer, "outputBuffer is null");
        this.pagePreprocessor = Objects.requireNonNull(pagePreprocessor, "pagePreprocessor is null");
        this.serde = serdeFactory.createPagesSerde();
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public void finish() {
        this.finished = true;
    }

    @Override
    public boolean isFinished() {
        return this.finished && this.isBlocked().isDone();
    }

    @Override
    public ListenableFuture<Void> isBlocked() {
        if (this.isBlocked.isDone()) {
            this.isBlocked = this.outputBuffer.isFull();
            if (this.isBlocked.isDone()) {
                this.isBlocked = NOT_BLOCKED;
            }
        }
        return this.isBlocked;
    }

    @Override
    public boolean needsInput() {
        return !this.finished && this.isBlocked().isDone();
    }

    @Override
    public void addInput(Page page) {
        Objects.requireNonNull(page, "page is null");
        if (page.getPositionCount() == 0) {
            return;
        }
        page = this.pagePreprocessor.apply(page);
        this.outputBuffer.enqueue(this.splitAndSerializePage(page));
        this.operatorContext.recordOutput(page.getSizeInBytes(), page.getPositionCount());
    }

    private List<Slice> splitAndSerializePage(Page page) {
        List<Page> split = PageSplitterUtil.splitPage(page, 0x100000L);
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)split.size());
        try (PagesSerde.PagesSerdeContext context = this.serde.newContext();){
            for (Page p : split) {
                builder.add((Object)this.serde.serialize(context, p));
            }
        }
        return builder.build();
    }

    @Override
    public Page getOutput() {
        return null;
    }

    public static class TaskOutputOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final OutputBuffer outputBuffer;
        private final Function<Page, Page> pagePreprocessor;
        private final PagesSerdeFactory serdeFactory;

        public TaskOutputOperatorFactory(int operatorId, PlanNodeId planNodeId, OutputBuffer outputBuffer, Function<Page, Page> pagePreprocessor, PagesSerdeFactory serdeFactory) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.outputBuffer = Objects.requireNonNull(outputBuffer, "outputBuffer is null");
            this.pagePreprocessor = Objects.requireNonNull(pagePreprocessor, "pagePreprocessor is null");
            this.serdeFactory = Objects.requireNonNull(serdeFactory, "serdeFactory is null");
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, TaskOutputOperator.class.getSimpleName());
            return new TaskOutputOperator(operatorContext, this.outputBuffer, this.pagePreprocessor, this.serdeFactory);
        }

        @Override
        public void noMoreOperators() {
        }

        @Override
        public OperatorFactory duplicate() {
            return new TaskOutputOperatorFactory(this.operatorId, this.planNodeId, this.outputBuffer, this.pagePreprocessor, this.serdeFactory);
        }
    }

    public static class TaskOutputFactory
    implements OutputFactory {
        private final OutputBuffer outputBuffer;

        public TaskOutputFactory(OutputBuffer outputBuffer) {
            this.outputBuffer = Objects.requireNonNull(outputBuffer, "outputBuffer is null");
        }

        @Override
        public OperatorFactory createOutputOperator(int operatorId, PlanNodeId planNodeId, List<Type> types, Function<Page, Page> pagePreprocessor, PagesSerdeFactory serdeFactory) {
            return new TaskOutputOperatorFactory(operatorId, planNodeId, this.outputBuffer, pagePreprocessor, serdeFactory);
        }
    }
}

