/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import io.trino.operator.aggregation.TypedSet;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.PageBuilder;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.Convention;
import io.trino.spi.function.Description;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorDependency;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlNullable;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.function.TypeParameters;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.type.BlockTypeOperators;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.List;

@ScalarFunction(value="multimap_from_entries")
@Description(value="Construct a multimap from an array of entries")
public final class MultimapFromEntriesFunction {
    private static final String NAME = "multimap_from_entries";
    private static final int INITIAL_ENTRY_COUNT = 128;
    private final PageBuilder pageBuilder;
    private IntList[] entryIndicesList;

    @TypeParameters(value={@TypeParameter(value="K"), @TypeParameter(value="V")})
    public MultimapFromEntriesFunction(@TypeParameter(value="map(K,array(V))") Type mapType) {
        this.pageBuilder = new PageBuilder((List)ImmutableList.of((Object)mapType));
        this.initializeEntryIndicesList(128);
    }

    @TypeParameters(value={@TypeParameter(value="K"), @TypeParameter(value="V")})
    @SqlType(value="map(K,array(V))")
    @SqlNullable
    public Block multimapFromEntries(@TypeParameter(value="map(K,array(V))") MapType mapType, @OperatorDependency(operator=OperatorType.IS_DISTINCT_FROM, argumentTypes={"K", "K"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) BlockTypeOperators.BlockPositionIsDistinctFrom keysDistinctOperator, @OperatorDependency(operator=OperatorType.HASH_CODE, argumentTypes={"K"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) BlockTypeOperators.BlockPositionHashCode keyHashCode, @SqlType(value="array(row(K,V))") Block mapEntries) {
        int entryCount;
        Type keyType = mapType.getKeyType();
        Type valueType = ((ArrayType)mapType.getValueType()).getElementType();
        RowType mapEntryType = RowType.anonymous((List)ImmutableList.of((Object)keyType, (Object)valueType));
        if (this.pageBuilder.isFull()) {
            this.pageBuilder.reset();
        }
        if ((entryCount = mapEntries.getPositionCount()) > this.entryIndicesList.length) {
            this.initializeEntryIndicesList(entryCount);
        }
        TypedSet keySet = TypedSet.createDistinctTypedSet(keyType, keysDistinctOperator, keyHashCode, entryCount, NAME);
        for (int i = 0; i < entryCount; ++i) {
            if (mapEntries.isNull(i)) {
                this.clearEntryIndices(keySet.size());
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "map entry cannot be null");
            }
            Block mapEntryBlock = mapEntryType.getObject(mapEntries, i);
            if (mapEntryBlock.isNull(0)) {
                this.clearEntryIndices(keySet.size());
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "map key cannot be null");
            }
            if (keySet.add(mapEntryBlock, 0)) {
                this.entryIndicesList[keySet.size() - 1].add(i);
                continue;
            }
            this.entryIndicesList[keySet.positionOf(mapEntryBlock, 0)].add(i);
        }
        BlockBuilder multimapBlockBuilder = this.pageBuilder.getBlockBuilder(0);
        BlockBuilder mapWriter = multimapBlockBuilder.beginBlockEntry();
        for (int i = 0; i < keySet.size(); ++i) {
            keyType.appendTo(mapEntryType.getObject(mapEntries, this.entryIndicesList[i].getInt(0)), 0, mapWriter);
            BlockBuilder valuesArray = mapWriter.beginBlockEntry();
            IntListIterator intListIterator = this.entryIndicesList[i].iterator();
            while (intListIterator.hasNext()) {
                int entryIndex = (Integer)intListIterator.next();
                valueType.appendTo(mapEntryType.getObject(mapEntries, entryIndex), 1, valuesArray);
            }
            mapWriter.closeEntry();
        }
        multimapBlockBuilder.closeEntry();
        this.pageBuilder.declarePosition();
        this.clearEntryIndices(keySet.size());
        return mapType.getObject((Block)multimapBlockBuilder, multimapBlockBuilder.getPositionCount() - 1);
    }

    private void clearEntryIndices(int entryCount) {
        Verify.verify((entryCount <= this.entryIndicesList.length ? 1 : 0) != 0);
        for (int i = 0; i < entryCount; ++i) {
            this.entryIndicesList[i].clear();
        }
    }

    private void initializeEntryIndicesList(int entryCount) {
        this.entryIndicesList = new IntList[entryCount];
        for (int i = 0; i < this.entryIndicesList.length; ++i) {
            this.entryIndicesList[i] = new IntArrayList();
        }
    }
}

