/*
 * Decompiled with CFR 0.152.
 */
package io.trino.split;

import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.connector.CatalogHandle;
import io.trino.connector.CatalogServiceProvider;
import io.trino.execution.QueryManagerConfig;
import io.trino.metadata.TableHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.DynamicFilter;
import io.trino.split.BufferingSplitSource;
import io.trino.split.ConnectorAwareSplitSource;
import io.trino.split.SplitSource;
import java.util.Objects;
import javax.inject.Inject;

public class SplitManager {
    private final CatalogServiceProvider<ConnectorSplitManager> splitManagerProvider;
    private final int minScheduleSplitBatchSize;

    @Inject
    public SplitManager(CatalogServiceProvider<ConnectorSplitManager> splitManagerProvider, QueryManagerConfig config) {
        this.splitManagerProvider = Objects.requireNonNull(splitManagerProvider, "splitManagerProvider is null");
        this.minScheduleSplitBatchSize = config.getMinScheduleSplitBatchSize();
    }

    public SplitSource getSplits(Session session, TableHandle table, DynamicFilter dynamicFilter, Constraint constraint) {
        CatalogHandle catalogHandle = table.getCatalogHandle();
        ConnectorSplitManager splitManager = this.splitManagerProvider.getService(catalogHandle);
        if (!SystemSessionProperties.isAllowPushdownIntoConnectors(session)) {
            dynamicFilter = DynamicFilter.EMPTY;
        }
        ConnectorSession connectorSession = session.toConnectorSession(catalogHandle);
        ConnectorSplitSource source = splitManager.getSplits(table.getTransaction(), connectorSession, table.getConnectorHandle(), dynamicFilter, constraint);
        SplitSource splitSource = new ConnectorAwareSplitSource(catalogHandle, source);
        if (this.minScheduleSplitBatchSize > 1) {
            splitSource = new BufferingSplitSource(splitSource, this.minScheduleSplitBatchSize);
        }
        return splitSource;
    }
}

