/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceUtf8;
import io.airlift.slice.Slices;
import io.trino.Session;
import io.trino.connector.CatalogServiceProvider;
import io.trino.metadata.AnalyzePropertyManager;
import io.trino.metadata.OperatorNotFoundException;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.SessionPropertyManager;
import io.trino.metadata.TableFunctionRegistry;
import io.trino.metadata.TableProceduresPropertyManager;
import io.trino.metadata.TableProceduresRegistry;
import io.trino.metadata.TablePropertyManager;
import io.trino.security.AllowAllAccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorType;
import io.trino.spi.predicate.DiscreteValues;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.NullableValue;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.Ranges;
import io.trino.spi.predicate.SortedRangeSet;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.predicate.ValueSet;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeUtils;
import io.trino.spi.type.VarcharType;
import io.trino.sql.ExpressionUtils;
import io.trino.sql.InterpretedFunctionInvoker;
import io.trino.sql.PlannerContext;
import io.trino.sql.analyzer.StatementAnalyzerFactory;
import io.trino.sql.parser.SqlParser;
import io.trino.sql.planner.DeterminismEvaluator;
import io.trino.sql.planner.ExpressionInterpreter;
import io.trino.sql.planner.LiteralEncoder;
import io.trino.sql.planner.NoOpSymbolResolver;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.TypeAnalyzer;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.BetweenPredicate;
import io.trino.sql.tree.BooleanLiteral;
import io.trino.sql.tree.Cast;
import io.trino.sql.tree.ComparisonExpression;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.InListExpression;
import io.trino.sql.tree.InPredicate;
import io.trino.sql.tree.IsNotNullPredicate;
import io.trino.sql.tree.IsNullPredicate;
import io.trino.sql.tree.LikePredicate;
import io.trino.sql.tree.LogicalExpression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.NotExpression;
import io.trino.sql.tree.NullLiteral;
import io.trino.sql.tree.StringLiteral;
import io.trino.sql.tree.SymbolReference;
import io.trino.transaction.NoOpTransactionManager;
import io.trino.type.LikeFunctions;
import io.trino.type.TypeCoercion;
import java.lang.invoke.MethodHandle;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class DomainTranslator {
    private final PlannerContext plannerContext;
    private final LiteralEncoder literalEncoder;

    public DomainTranslator(PlannerContext plannerContext) {
        this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
        this.literalEncoder = new LiteralEncoder(plannerContext);
    }

    public Expression toPredicate(Session session, TupleDomain<Symbol> tupleDomain) {
        if (tupleDomain.isNone()) {
            return BooleanLiteral.FALSE_LITERAL;
        }
        Map domains = (Map)tupleDomain.getDomains().get();
        return domains.entrySet().stream().map(entry -> this.toPredicate(session, (Domain)entry.getValue(), ((Symbol)entry.getKey()).toSymbolReference())).collect(Collectors.collectingAndThen(ImmutableList.toImmutableList(), expressions -> ExpressionUtils.combineConjuncts(this.plannerContext.getMetadata(), (Collection<Expression>)expressions)));
    }

    private Expression toPredicate(Session session, Domain domain, SymbolReference reference) {
        if (domain.getValues().isNone()) {
            return domain.isNullAllowed() ? new IsNullPredicate((Expression)reference) : BooleanLiteral.FALSE_LITERAL;
        }
        if (domain.getValues().isAll()) {
            return domain.isNullAllowed() ? BooleanLiteral.TRUE_LITERAL : new NotExpression((Expression)new IsNullPredicate((Expression)reference));
        }
        ArrayList<Expression> disjuncts = new ArrayList<Expression>();
        disjuncts.addAll((Collection)domain.getValues().getValuesProcessor().transform(ranges -> this.extractDisjuncts(session, domain.getType(), (Ranges)ranges, reference), discreteValues -> this.extractDisjuncts(session, domain.getType(), (DiscreteValues)discreteValues, reference), allOrNone -> {
            throw new IllegalStateException("Case should not be reachable");
        }));
        if (domain.isNullAllowed()) {
            disjuncts.add((Expression)new IsNullPredicate((Expression)reference));
        }
        return ExpressionUtils.combineDisjunctsWithDefault(this.plannerContext.getMetadata(), disjuncts, (Expression)BooleanLiteral.TRUE_LITERAL);
    }

    private Expression processRange(Session session, Type type, Range range, SymbolReference reference) {
        if (range.isAll()) {
            return BooleanLiteral.TRUE_LITERAL;
        }
        if (DomainTranslator.isBetween(range)) {
            return new BetweenPredicate((Expression)reference, this.literalEncoder.toExpression(session, range.getLowBoundedValue(), type), this.literalEncoder.toExpression(session, range.getHighBoundedValue(), type));
        }
        ArrayList<Expression> rangeConjuncts = new ArrayList<Expression>();
        if (!range.isLowUnbounded()) {
            rangeConjuncts.add((Expression)new ComparisonExpression(range.isLowInclusive() ? ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL : ComparisonExpression.Operator.GREATER_THAN, (Expression)reference, this.literalEncoder.toExpression(session, range.getLowBoundedValue(), type)));
        }
        if (!range.isHighUnbounded()) {
            rangeConjuncts.add((Expression)new ComparisonExpression(range.isHighInclusive() ? ComparisonExpression.Operator.LESS_THAN_OR_EQUAL : ComparisonExpression.Operator.LESS_THAN, (Expression)reference, this.literalEncoder.toExpression(session, range.getHighBoundedValue(), type)));
        }
        Preconditions.checkState((!rangeConjuncts.isEmpty() ? 1 : 0) != 0);
        return ExpressionUtils.combineConjuncts(this.plannerContext.getMetadata(), rangeConjuncts);
    }

    private Expression combineRangeWithExcludedPoints(Session session, Type type, SymbolReference reference, Range range, List<Expression> excludedPoints) {
        if (excludedPoints.isEmpty()) {
            return this.processRange(session, type, range, reference);
        }
        NotExpression excludedPointsExpression = new NotExpression((Expression)new InPredicate((Expression)reference, (Expression)new InListExpression(excludedPoints)));
        if (excludedPoints.size() == 1) {
            excludedPointsExpression = new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)reference, (Expression)Iterables.getOnlyElement(excludedPoints));
        }
        return ExpressionUtils.combineConjuncts(this.plannerContext.getMetadata(), new Expression[]{this.processRange(session, type, range, reference), excludedPointsExpression});
    }

    private List<Expression> extractDisjuncts(Session session, Type type, Ranges ranges, SymbolReference reference) {
        ArrayList<Expression> disjuncts = new ArrayList<Expression>();
        ArrayList<Expression> singleValues = new ArrayList<Expression>();
        List orderedRanges = ranges.getOrderedRanges();
        SortedRangeSet sortedRangeSet = SortedRangeSet.copyOf((Type)type, (List)orderedRanges);
        SortedRangeSet complement = sortedRangeSet.complement();
        List singleValueExclusionsList = complement.getOrderedRanges().stream().filter(Range::isSingleValue).collect(Collectors.toList());
        List originalUnionSingleValues = SortedRangeSet.copyOf((Type)type, singleValueExclusionsList).union((ValueSet)sortedRangeSet).getOrderedRanges();
        PeekingIterator singleValueExclusions = Iterators.peekingIterator(singleValueExclusionsList.iterator());
        if (type instanceof RealType || type instanceof DoubleType) {
            boolean originalRangeIsAll = orderedRanges.stream().anyMatch(Range::isAll);
            boolean coalescedRangeIsAll = originalUnionSingleValues.stream().anyMatch(Range::isAll);
            if (!originalRangeIsAll && coalescedRangeIsAll) {
                for (Range range : orderedRanges) {
                    disjuncts.add(this.processRange(session, type, range, reference));
                }
                return disjuncts;
            }
        }
        for (Range range : originalUnionSingleValues) {
            if (range.isSingleValue()) {
                singleValues.add(this.literalEncoder.toExpression(session, range.getSingleValue(), type));
                continue;
            }
            ArrayList<Expression> singleValuesInRange = new ArrayList<Expression>();
            while (singleValueExclusions.hasNext() && range.contains((Range)singleValueExclusions.peek())) {
                singleValuesInRange.add(this.literalEncoder.toExpression(session, ((Range)singleValueExclusions.next()).getSingleValue(), type));
            }
            if (!singleValuesInRange.isEmpty()) {
                disjuncts.add(this.combineRangeWithExcludedPoints(session, type, reference, range, singleValuesInRange));
                continue;
            }
            disjuncts.add(this.processRange(session, type, range, reference));
        }
        if (singleValues.size() == 1) {
            disjuncts.add((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)reference, (Expression)Iterables.getOnlyElement(singleValues)));
        } else if (singleValues.size() > 1) {
            disjuncts.add((Expression)new InPredicate((Expression)reference, (Expression)new InListExpression(singleValues)));
        }
        return disjuncts;
    }

    private List<Expression> extractDisjuncts(Session session, Type type, DiscreteValues discreteValues, SymbolReference reference) {
        List values = discreteValues.getValues().stream().map(object -> this.literalEncoder.toExpression(session, object, type)).collect(Collectors.toList());
        Preconditions.checkState((!values.isEmpty() ? 1 : 0) != 0);
        Object predicate = values.size() == 1 ? new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)reference, (Expression)Iterables.getOnlyElement(values)) : new InPredicate((Expression)reference, (Expression)new InListExpression(values));
        if (!discreteValues.isInclusive()) {
            predicate = new NotExpression((Expression)predicate);
        }
        return ImmutableList.of((Object)predicate);
    }

    private static boolean isBetween(Range range) {
        return range.isLowInclusive() && range.isHighInclusive();
    }

    public static ExtractionResult getExtractionResult(PlannerContext plannerContext, Session session, Expression predicate, TypeProvider types) {
        TypeAnalyzer typeAnalyzer = new TypeAnalyzer(plannerContext, new StatementAnalyzerFactory(plannerContext, new SqlParser(), new AllowAllAccessControl(), new NoOpTransactionManager(), user -> ImmutableSet.of(), new TableProceduresRegistry(CatalogServiceProvider.fail("procedures are not supported in domain translator")), new TableFunctionRegistry(CatalogServiceProvider.fail("table functions are not supported in domain translator")), new SessionPropertyManager(), new TablePropertyManager(CatalogServiceProvider.fail("table properties not supported in domain translator")), new AnalyzePropertyManager(CatalogServiceProvider.fail("analyze properties not supported in domain translator")), new TableProceduresPropertyManager(CatalogServiceProvider.fail("procedures are not supported in domain translator"))));
        return (ExtractionResult)new Visitor(plannerContext, session, types, typeAnalyzer).process((Node)predicate, false);
    }

    private static class Visitor
    extends AstVisitor<ExtractionResult, Boolean> {
        private final PlannerContext plannerContext;
        private final LiteralEncoder literalEncoder;
        private final Session session;
        private final TypeProvider types;
        private final InterpretedFunctionInvoker functionInvoker;
        private final TypeAnalyzer typeAnalyzer;
        private final TypeCoercion typeCoercion;

        private Visitor(PlannerContext plannerContext, Session session, TypeProvider types, TypeAnalyzer typeAnalyzer) {
            this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
            this.literalEncoder = new LiteralEncoder(plannerContext);
            this.session = Objects.requireNonNull(session, "session is null");
            this.types = Objects.requireNonNull(types, "types is null");
            this.functionInvoker = new InterpretedFunctionInvoker(plannerContext.getFunctionManager());
            this.typeAnalyzer = Objects.requireNonNull(typeAnalyzer, "typeAnalyzer is null");
            this.typeCoercion = new TypeCoercion(arg_0 -> ((TypeManager)plannerContext.getTypeManager()).getType(arg_0));
        }

        private Type checkedTypeLookup(Symbol symbol) {
            Type type = this.types.get(symbol);
            Preconditions.checkArgument((type != null ? 1 : 0) != 0, (String)"Types is missing info for symbol: %s", (Object)symbol);
            return type;
        }

        private static ValueSet complementIfNecessary(ValueSet valueSet, boolean complement) {
            return complement ? valueSet.complement() : valueSet;
        }

        private static Domain complementIfNecessary(Domain domain, boolean complement) {
            return complement ? domain.complement() : domain;
        }

        private static Expression complementIfNecessary(Expression expression, boolean complement) {
            return complement ? new NotExpression(expression) : expression;
        }

        protected ExtractionResult visitExpression(Expression node, Boolean complement) {
            return new ExtractionResult((TupleDomain<Symbol>)TupleDomain.all(), Visitor.complementIfNecessary(node, (boolean)complement));
        }

        protected ExtractionResult visitLogicalExpression(LogicalExpression node, Boolean complement) {
            List results = (List)node.getTerms().stream().map(term -> (ExtractionResult)this.process((Node)term, complement)).collect(ImmutableList.toImmutableList());
            List tupleDomains = (List)results.stream().map(ExtractionResult::getTupleDomain).collect(ImmutableList.toImmutableList());
            List residuals = (List)results.stream().map(ExtractionResult::getRemainingExpression).collect(ImmutableList.toImmutableList());
            LogicalExpression.Operator operator = complement != false ? node.getOperator().flip() : node.getOperator();
            switch (operator) {
                case AND: {
                    return new ExtractionResult((TupleDomain<Symbol>)TupleDomain.intersect((List)tupleDomains), ExpressionUtils.combineConjuncts(this.plannerContext.getMetadata(), residuals));
                }
                case OR: {
                    TupleDomain columnUnionedTupleDomain = TupleDomain.columnWiseUnion((List)tupleDomains);
                    Expression remainingExpression = Visitor.complementIfNecessary((Expression)node, (boolean)complement);
                    if (Set.copyOf(residuals).size() == 1 && DeterminismEvaluator.isDeterministic((Expression)residuals.get(0), this.plannerContext.getMetadata())) {
                        boolean matchingSingleSymbolDomains = (tupleDomains = tupleDomains.stream().filter(domain -> !domain.isNone()).collect(Collectors.toList())).stream().allMatch(domain -> ((Map)domain.getDomains().get()).size() == 1);
                        matchingSingleSymbolDomains = matchingSingleSymbolDomains && tupleDomains.stream().map(tupleDomain -> ((Map)tupleDomain.getDomains().get()).keySet()).distinct().count() == 1L;
                        boolean oneTermIsSuperSet = TupleDomain.maximal(tupleDomains).isPresent();
                        if (oneTermIsSuperSet) {
                            remainingExpression = (Expression)residuals.get(0);
                        } else if (matchingSingleSymbolDomains) {
                            boolean implicitlyAddedNaN;
                            Type type = ((Domain)Iterables.getOnlyElement(((Map)((TupleDomain)tupleDomains.get(0)).getDomains().get()).values())).getType();
                            boolean unionedDomainContainsNaN = columnUnionedTupleDomain.isAll() || columnUnionedTupleDomain.getDomains().isPresent() && ((Domain)Iterables.getOnlyElement(((Map)columnUnionedTupleDomain.getDomains().get()).values())).getValues().isAll();
                            boolean bl = implicitlyAddedNaN = (type instanceof RealType || type instanceof DoubleType) && tupleDomains.stream().noneMatch(TupleDomain::isAll) && unionedDomainContainsNaN;
                            if (!implicitlyAddedNaN) {
                                remainingExpression = (Expression)residuals.get(0);
                            }
                        }
                    }
                    return new ExtractionResult((TupleDomain<Symbol>)columnUnionedTupleDomain, remainingExpression);
                }
            }
            throw new AssertionError((Object)("Unknown operator: " + node.getOperator()));
        }

        protected ExtractionResult visitNotExpression(NotExpression node, Boolean complement) {
            return (ExtractionResult)this.process((Node)node.getValue(), complement == false);
        }

        protected ExtractionResult visitSymbolReference(SymbolReference node, Boolean complement) {
            if (this.types.get(Symbol.from((Expression)node)).equals(BooleanType.BOOLEAN)) {
                ComparisonExpression newNode = new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)node, (Expression)BooleanLiteral.TRUE_LITERAL);
                return this.visitComparisonExpression(newNode, complement);
            }
            return this.visitExpression((Expression)node, complement);
        }

        protected ExtractionResult visitComparisonExpression(ComparisonExpression node, Boolean complement) {
            Map<NodeRef<Expression>, Type> expressionTypes = this.analyzeExpression((Expression)node);
            Optional<NormalizedSimpleComparison> optionalNormalized = this.toNormalizedSimpleComparison(expressionTypes, node);
            if (optionalNormalized.isEmpty()) {
                return (ExtractionResult)super.visitComparisonExpression(node, (Object)complement);
            }
            NormalizedSimpleComparison normalized = optionalNormalized.get();
            Expression symbolExpression = normalized.getSymbolExpression();
            if (symbolExpression instanceof SymbolReference) {
                Symbol symbol = Symbol.from(symbolExpression);
                NullableValue value = normalized.getValue();
                Type type = value.getType();
                return Visitor.createComparisonExtractionResult(normalized.getComparisonOperator(), symbol, type, value.getValue(), complement).orElseGet(() -> (ExtractionResult)super.visitComparisonExpression(node, (Object)complement));
            }
            if (symbolExpression instanceof Cast) {
                Optional<ExtractionResult> result;
                Cast castExpression = (Cast)symbolExpression;
                Type castSourceType = Objects.requireNonNull(expressionTypes.get(NodeRef.of((Node)castExpression.getExpression())), "No type for Cast source expression");
                Type castTargetType = Objects.requireNonNull(expressionTypes.get(NodeRef.of((Node)castExpression)), "No type for Cast target expression");
                if (castSourceType instanceof VarcharType && castTargetType == DateType.DATE && !castExpression.isSafe() && (result = this.createVarcharCastToDateComparisonExtractionResult(node, (VarcharType)castSourceType, normalized.getValue(), complement)).isPresent()) {
                    return result.get();
                }
                if (!this.isImplicitCoercion(expressionTypes, castExpression)) {
                    return (ExtractionResult)super.visitComparisonExpression(node, (Object)complement);
                }
                Optional<Expression> coercedExpression = this.coerceComparisonWithRounding(castSourceType, castExpression.getExpression(), normalized.getValue(), normalized.getComparisonOperator());
                if (coercedExpression.isPresent()) {
                    return (ExtractionResult)this.process((Node)coercedExpression.get(), complement);
                }
                return (ExtractionResult)super.visitComparisonExpression(node, (Object)complement);
            }
            return (ExtractionResult)super.visitComparisonExpression(node, (Object)complement);
        }

        private Optional<NormalizedSimpleComparison> toNormalizedSimpleComparison(Map<NodeRef<Expression>, Type> expressionTypes, ComparisonExpression comparison) {
            NullableValue value;
            ComparisonExpression.Operator comparisonOperator;
            Expression symbolExpression;
            Object left = new ExpressionInterpreter(comparison.getLeft(), this.plannerContext, this.session, expressionTypes).optimize(NoOpSymbolResolver.INSTANCE);
            Object right = new ExpressionInterpreter(comparison.getRight(), this.plannerContext, this.session, expressionTypes).optimize(NoOpSymbolResolver.INSTANCE);
            Type leftType = expressionTypes.get(NodeRef.of((Node)comparison.getLeft()));
            Type rightType = expressionTypes.get(NodeRef.of((Node)comparison.getRight()));
            Preconditions.checkArgument((boolean)leftType.equals(rightType), (String)"left and right type do not match in comparison expression (%s)", (Object)comparison);
            if (left instanceof Expression == right instanceof Expression) {
                return Optional.empty();
            }
            if (left instanceof Expression) {
                symbolExpression = comparison.getLeft();
                comparisonOperator = comparison.getOperator();
                value = new NullableValue(rightType, right);
            } else {
                symbolExpression = comparison.getRight();
                comparisonOperator = comparison.getOperator().flip();
                value = new NullableValue(leftType, left);
            }
            return Optional.of(new NormalizedSimpleComparison(symbolExpression, comparisonOperator, value));
        }

        private boolean isImplicitCoercion(Map<NodeRef<Expression>, Type> expressionTypes, Cast cast) {
            Type castSourceType = Objects.requireNonNull(expressionTypes.get(NodeRef.of((Node)cast.getExpression())), "No type for Cast source expression");
            Type castTargetType = Objects.requireNonNull(expressionTypes.get(NodeRef.of((Node)cast)), "No type for Cast expression");
            return this.typeCoercion.canCoerce(castSourceType, castTargetType);
        }

        private Map<NodeRef<Expression>, Type> analyzeExpression(Expression expression) {
            return this.typeAnalyzer.getTypes(this.session, this.types, expression);
        }

        private Optional<ExtractionResult> createVarcharCastToDateComparisonExtractionResult(ComparisonExpression node, VarcharType sourceType, NullableValue value, boolean complement) {
            SortedRangeSet valueSet;
            Cast castExpression = (Cast)node.getLeft();
            Expression sourceExpression = castExpression.getExpression();
            ComparisonExpression.Operator comparisonOperator = node.getOperator();
            Objects.requireNonNull(value, "value is null");
            if (complement || value.isNull()) {
                return Optional.empty();
            }
            if (!(sourceExpression instanceof SymbolReference)) {
                return Optional.empty();
            }
            Symbol sourceSymbol = Symbol.from(sourceExpression);
            if (!sourceType.isUnbounded() && sourceType.getBoundedLength() < 10) {
                return Optional.empty();
            }
            LocalDate date = LocalDate.ofEpochDay((Long)value.getValue());
            if (date.getYear() < 1001 || date.getYear() > 9998) {
                return Optional.empty();
            }
            boolean nullAllowed = false;
            switch (comparisonOperator) {
                case EQUAL: {
                    valueSet = Visitor.dateStringRanges(date, sourceType);
                    break;
                }
                case NOT_EQUAL: 
                case IS_DISTINCT_FROM: {
                    if (date.getDayOfMonth() < 10) {
                        return Optional.empty();
                    }
                    valueSet = ValueSet.all((Type)sourceType).subtract((ValueSet)Visitor.dateStringRanges(date, sourceType));
                    nullAllowed = comparisonOperator == ComparisonExpression.Operator.IS_DISTINCT_FROM;
                    break;
                }
                case LESS_THAN: 
                case LESS_THAN_OR_EQUAL: {
                    valueSet = ValueSet.ofRanges((Range)Range.lessThan((Type)sourceType, (Object)Slices.utf8Slice((String)Integer.toString(date.getYear() + 1))), (Range[])new Range[0]);
                    break;
                }
                case GREATER_THAN: 
                case GREATER_THAN_OR_EQUAL: {
                    valueSet = ValueSet.ofRanges((Range)Range.greaterThan((Type)sourceType, (Object)Slices.utf8Slice((String)Integer.toString(date.getYear() - 1))), (Range[])new Range[0]);
                    break;
                }
                default: {
                    return Optional.empty();
                }
            }
            valueSet = valueSet.union(ValueSet.ofRanges((Range)Range.lessThan((Type)sourceType, (Object)Slices.utf8Slice((String)"1")), (Range[])new Range[]{Range.greaterThan((Type)sourceType, (Object)Slices.utf8Slice((String)"9"))}));
            return Optional.of(new ExtractionResult((TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)sourceSymbol, (Object)Domain.create((ValueSet)valueSet, (boolean)nullAllowed))), (Expression)node));
        }

        private static SortedRangeSet dateStringRanges(LocalDate date, VarcharType domainType) {
            Preconditions.checkArgument((date.getYear() >= 1000 && date.getYear() <= 9999 ? 1 : 0) != 0, (String)"Unsupported date: %s", (Object)date);
            int month = date.getMonthValue();
            int day = date.getDayOfMonth();
            boolean isMonthSingleDigit = date.getMonthValue() < 10;
            boolean isDaySingleDigit = date.getDayOfMonth() < 10;
            ArrayList<Range> valueRanges = new ArrayList<Range>(4);
            for (boolean useSingleDigitMonth : List.of(Boolean.valueOf(true), Boolean.valueOf(false))) {
                for (boolean useSingleDigitDay : List.of(Boolean.valueOf(true), Boolean.valueOf(false))) {
                    if (useSingleDigitMonth && !isMonthSingleDigit || useSingleDigitDay && !isDaySingleDigit) continue;
                    String dateString = date.getYear() + (!useSingleDigitMonth && isMonthSingleDigit ? "-0" : "-") + month + (!useSingleDigitDay && isDaySingleDigit ? "-0" : "-") + day;
                    String nextStringPrefix = dateString.substring(0, dateString.length() - 1) + (char)(dateString.charAt(dateString.length() - 1) + '\u0001');
                    Verify.verify((dateString.length() <= domainType.getLength().orElse(Integer.MAX_VALUE) ? 1 : 0) != 0, (String)"dateString length exceeds type bounds", (Object[])new Object[0]);
                    Verify.verify((dateString.length() == nextStringPrefix.length() ? 1 : 0) != 0, (String)"Next string length mismatch", (Object[])new Object[0]);
                    valueRanges.add(Range.range((Type)domainType, (Object)Slices.utf8Slice((String)dateString), (boolean)true, (Object)Slices.utf8Slice((String)nextStringPrefix), (boolean)false));
                }
            }
            return (SortedRangeSet)ValueSet.ofRanges(valueRanges);
        }

        private static Optional<ExtractionResult> createComparisonExtractionResult(ComparisonExpression.Operator comparisonOperator, Symbol column, Type type, @Nullable Object value, boolean complement) {
            if (value == null) {
                switch (comparisonOperator) {
                    case EQUAL: 
                    case NOT_EQUAL: 
                    case LESS_THAN: 
                    case LESS_THAN_OR_EQUAL: 
                    case GREATER_THAN: 
                    case GREATER_THAN_OR_EQUAL: {
                        return Optional.of(new ExtractionResult((TupleDomain<Symbol>)TupleDomain.none(), (Expression)BooleanLiteral.TRUE_LITERAL));
                    }
                    case IS_DISTINCT_FROM: {
                        Domain domain2 = Visitor.complementIfNecessary(Domain.notNull((Type)type), complement);
                        return Optional.of(new ExtractionResult((TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)column, (Object)domain2)), (Expression)BooleanLiteral.TRUE_LITERAL));
                    }
                }
                throw new AssertionError((Object)("Unhandled operator: " + comparisonOperator));
            }
            if (type.isOrderable()) {
                return Visitor.extractOrderableDomain(comparisonOperator, type, value, complement).map(domain -> new ExtractionResult((TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)column, (Object)domain)), (Expression)BooleanLiteral.TRUE_LITERAL));
            }
            if (type.isComparable()) {
                Domain domain3 = Visitor.extractEquatableDomain(comparisonOperator, type, value, complement);
                return Optional.of(new ExtractionResult((TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)column, (Object)domain3)), (Expression)BooleanLiteral.TRUE_LITERAL));
            }
            throw new AssertionError((Object)("Type cannot be used in a comparison expression (should have been caught in analysis): " + type));
        }

        private static Optional<Domain> extractOrderableDomain(ComparisonExpression.Operator comparisonOperator, Type type, Object value, boolean complement) {
            Preconditions.checkArgument((value != null ? 1 : 0) != 0);
            if (!(type instanceof DoubleType) && !(type instanceof RealType)) {
                return switch (comparisonOperator) {
                    default -> throw new IncompatibleClassChangeError();
                    case ComparisonExpression.Operator.EQUAL -> Optional.of(Domain.create((ValueSet)Visitor.complementIfNecessary(ValueSet.ofRanges((Range)Range.equal((Type)type, (Object)value), (Range[])new Range[0]), complement), (boolean)false));
                    case ComparisonExpression.Operator.GREATER_THAN -> Optional.of(Domain.create((ValueSet)Visitor.complementIfNecessary(ValueSet.ofRanges((Range)Range.greaterThan((Type)type, (Object)value), (Range[])new Range[0]), complement), (boolean)false));
                    case ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL -> Optional.of(Domain.create((ValueSet)Visitor.complementIfNecessary(ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)type, (Object)value), (Range[])new Range[0]), complement), (boolean)false));
                    case ComparisonExpression.Operator.LESS_THAN -> Optional.of(Domain.create((ValueSet)Visitor.complementIfNecessary(ValueSet.ofRanges((Range)Range.lessThan((Type)type, (Object)value), (Range[])new Range[0]), complement), (boolean)false));
                    case ComparisonExpression.Operator.LESS_THAN_OR_EQUAL -> Optional.of(Domain.create((ValueSet)Visitor.complementIfNecessary(ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)type, (Object)value), (Range[])new Range[0]), complement), (boolean)false));
                    case ComparisonExpression.Operator.NOT_EQUAL -> Optional.of(Domain.create((ValueSet)Visitor.complementIfNecessary(ValueSet.ofRanges((Range)Range.lessThan((Type)type, (Object)value), (Range[])new Range[]{Range.greaterThan((Type)type, (Object)value)}), complement), (boolean)false));
                    case ComparisonExpression.Operator.IS_DISTINCT_FROM -> Optional.of(Visitor.complementIfNecessary(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)type, (Object)value), (Range[])new Range[]{Range.greaterThan((Type)type, (Object)value)}), (boolean)true), complement));
                };
            }
            if (TypeUtils.isFloatingPointNaN((Type)type, (Object)value)) {
                return switch (comparisonOperator) {
                    default -> throw new IncompatibleClassChangeError();
                    case ComparisonExpression.Operator.EQUAL, ComparisonExpression.Operator.LESS_THAN, ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, ComparisonExpression.Operator.GREATER_THAN, ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL -> Optional.of(Domain.create((ValueSet)Visitor.complementIfNecessary(ValueSet.none((Type)type), complement), (boolean)false));
                    case ComparisonExpression.Operator.NOT_EQUAL -> Optional.of(Domain.create((ValueSet)Visitor.complementIfNecessary(ValueSet.all((Type)type), complement), (boolean)false));
                    case ComparisonExpression.Operator.IS_DISTINCT_FROM -> Optional.empty();
                };
            }
            return switch (comparisonOperator) {
                default -> throw new IncompatibleClassChangeError();
                case ComparisonExpression.Operator.EQUAL -> {
                    if (complement) {
                        yield Optional.empty();
                    }
                    yield Optional.of(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)type, (Object)value), (Range[])new Range[0]), (boolean)false));
                }
                case ComparisonExpression.Operator.GREATER_THAN -> {
                    if (complement) {
                        yield Optional.empty();
                    }
                    yield Optional.of(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)type, (Object)value), (Range[])new Range[0]), (boolean)false));
                }
                case ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL -> {
                    if (complement) {
                        yield Optional.empty();
                    }
                    yield Optional.of(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)type, (Object)value), (Range[])new Range[0]), (boolean)false));
                }
                case ComparisonExpression.Operator.LESS_THAN -> {
                    if (complement) {
                        yield Optional.empty();
                    }
                    yield Optional.of(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)type, (Object)value), (Range[])new Range[0]), (boolean)false));
                }
                case ComparisonExpression.Operator.LESS_THAN_OR_EQUAL -> {
                    if (complement) {
                        yield Optional.empty();
                    }
                    yield Optional.of(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)type, (Object)value), (Range[])new Range[0]), (boolean)false));
                }
                case ComparisonExpression.Operator.NOT_EQUAL, ComparisonExpression.Operator.IS_DISTINCT_FROM -> complement ? Optional.of(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)type, (Object)value), (Range[])new Range[0]), (boolean)false)) : Optional.empty();
            };
        }

        private static Domain extractEquatableDomain(ComparisonExpression.Operator comparisonOperator, Type type, Object value, boolean complement) {
            Preconditions.checkArgument((value != null ? 1 : 0) != 0);
            return switch (comparisonOperator) {
                case ComparisonExpression.Operator.EQUAL -> Domain.create((ValueSet)Visitor.complementIfNecessary(ValueSet.of((Type)type, (Object)value, (Object[])new Object[0]), complement), (boolean)false);
                case ComparisonExpression.Operator.NOT_EQUAL -> Domain.create((ValueSet)Visitor.complementIfNecessary(ValueSet.of((Type)type, (Object)value, (Object[])new Object[0]).complement(), complement), (boolean)false);
                case ComparisonExpression.Operator.IS_DISTINCT_FROM -> Visitor.complementIfNecessary(Domain.create((ValueSet)ValueSet.of((Type)type, (Object)value, (Object[])new Object[0]).complement(), (boolean)true), complement);
                default -> throw new IllegalArgumentException("Unhandled operator: " + comparisonOperator);
            };
        }

        private Optional<Expression> coerceComparisonWithRounding(Type symbolExpressionType, Expression symbolExpression, NullableValue nullableValue, ComparisonExpression.Operator comparisonOperator) {
            Objects.requireNonNull(nullableValue, "nullableValue is null");
            if (nullableValue.isNull()) {
                return Optional.empty();
            }
            Type valueType = nullableValue.getType();
            Object value = nullableValue.getValue();
            return this.floorValue(valueType, symbolExpressionType, value).map(floorValue -> this.rewriteComparisonExpression(symbolExpressionType, symbolExpression, valueType, value, floorValue, comparisonOperator));
        }

        private Expression rewriteComparisonExpression(Type symbolExpressionType, Expression symbolExpression, Type valueType, Object originalValue, Object coercedValue, ComparisonExpression.Operator comparisonOperator) {
            int originalComparedToCoerced = this.compareOriginalValueToCoerced(valueType, originalValue, symbolExpressionType, coercedValue);
            boolean coercedValueIsEqualToOriginal = originalComparedToCoerced == 0;
            boolean coercedValueIsLessThanOriginal = originalComparedToCoerced > 0;
            boolean coercedValueIsGreaterThanOriginal = originalComparedToCoerced < 0;
            Expression coercedLiteral = this.literalEncoder.toExpression(this.session, coercedValue, symbolExpressionType);
            return switch (comparisonOperator) {
                default -> throw new IncompatibleClassChangeError();
                case ComparisonExpression.Operator.GREATER_THAN, ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL -> {
                    if (coercedValueIsGreaterThanOriginal) {
                        yield new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, symbolExpression, coercedLiteral);
                    }
                    if (coercedValueIsEqualToOriginal) {
                        yield new ComparisonExpression(comparisonOperator, symbolExpression, coercedLiteral);
                    }
                    if (coercedValueIsLessThanOriginal) {
                        yield new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, symbolExpression, coercedLiteral);
                    }
                    throw new AssertionError((Object)"Unreachable");
                }
                case ComparisonExpression.Operator.LESS_THAN, ComparisonExpression.Operator.LESS_THAN_OR_EQUAL -> {
                    if (coercedValueIsLessThanOriginal) {
                        yield new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, symbolExpression, coercedLiteral);
                    }
                    if (coercedValueIsEqualToOriginal) {
                        yield new ComparisonExpression(comparisonOperator, symbolExpression, coercedLiteral);
                    }
                    if (coercedValueIsGreaterThanOriginal) {
                        yield new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, symbolExpression, coercedLiteral);
                    }
                    throw new AssertionError((Object)"Unreachable");
                }
                case ComparisonExpression.Operator.EQUAL -> {
                    if (coercedValueIsEqualToOriginal) {
                        yield new ComparisonExpression(ComparisonExpression.Operator.EQUAL, symbolExpression, coercedLiteral);
                    }
                    yield ExpressionUtils.and(new Expression[]{new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, symbolExpression, coercedLiteral), new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, symbolExpression, coercedLiteral)});
                }
                case ComparisonExpression.Operator.NOT_EQUAL -> {
                    if (coercedValueIsEqualToOriginal) {
                        yield new ComparisonExpression(comparisonOperator, symbolExpression, coercedLiteral);
                    }
                    yield ExpressionUtils.or(new Expression[]{new ComparisonExpression(ComparisonExpression.Operator.EQUAL, symbolExpression, coercedLiteral), new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, symbolExpression, coercedLiteral)});
                }
                case ComparisonExpression.Operator.IS_DISTINCT_FROM -> coercedValueIsEqualToOriginal ? new ComparisonExpression(comparisonOperator, symbolExpression, coercedLiteral) : BooleanLiteral.TRUE_LITERAL;
            };
        }

        private Optional<Object> floorValue(Type fromType, Type toType, Object value) {
            return this.getSaturatedFloorCastOperator(fromType, toType).map(operator -> this.functionInvoker.invoke((ResolvedFunction)operator, this.session.toConnectorSession(), value));
        }

        private Optional<ResolvedFunction> getSaturatedFloorCastOperator(Type fromType, Type toType) {
            try {
                return Optional.of(this.plannerContext.getMetadata().getCoercion(this.session, OperatorType.SATURATED_FLOOR_CAST, fromType, toType));
            }
            catch (OperatorNotFoundException e) {
                return Optional.empty();
            }
        }

        private int compareOriginalValueToCoerced(Type originalValueType, Object originalValue, Type coercedValueType, Object coercedValue) {
            Objects.requireNonNull(originalValueType, "originalValueType is null");
            Objects.requireNonNull(coercedValue, "coercedValue is null");
            ResolvedFunction castToOriginalTypeOperator = this.plannerContext.getMetadata().getCoercion(this.session, coercedValueType, originalValueType);
            Object coercedValueInOriginalType = this.functionInvoker.invoke(castToOriginalTypeOperator, this.session.toConnectorSession(), coercedValue);
            MethodHandle comparisonOperator = this.plannerContext.getTypeOperators().getComparisonUnorderedLastOperator(originalValueType, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL}));
            try {
                return (int)comparisonOperator.invoke(originalValue, coercedValueInOriginalType);
            }
            catch (Throwable throwable) {
                Throwables.throwIfUnchecked((Throwable)throwable);
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, throwable);
            }
        }

        protected ExtractionResult visitInPredicate(InPredicate node, Boolean complement) {
            if (!(node.getValueList() instanceof InListExpression)) {
                return (ExtractionResult)super.visitInPredicate(node, (Object)complement);
            }
            InListExpression valueList = (InListExpression)node.getValueList();
            Preconditions.checkState((!valueList.getValues().isEmpty() ? 1 : 0) != 0, (Object)"InListExpression should never be empty");
            Optional<ExtractionResult> directExtractionResult = this.processSimpleInPredicate(node, complement);
            if (directExtractionResult.isPresent()) {
                return directExtractionResult.get();
            }
            ImmutableList.Builder disjuncts = ImmutableList.builder();
            for (Expression expression : valueList.getValues()) {
                disjuncts.add((Object)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, node.getValue(), expression));
            }
            ExtractionResult extractionResult = (ExtractionResult)this.process((Node)ExpressionUtils.or((Collection<Expression>)disjuncts.build()), complement);
            if (extractionResult.tupleDomain.isAll()) {
                InPredicate originalPredicate = node;
                if (complement.booleanValue()) {
                    originalPredicate = new NotExpression((Expression)originalPredicate);
                }
                return new ExtractionResult(extractionResult.tupleDomain, (Expression)originalPredicate);
            }
            return extractionResult;
        }

        private Optional<ExtractionResult> processSimpleInPredicate(InPredicate node, Boolean complement) {
            if (!(node.getValue() instanceof SymbolReference)) {
                return Optional.empty();
            }
            Symbol symbol = Symbol.from(node.getValue());
            Map<NodeRef<Expression>, Type> expressionTypes = this.analyzeExpression((Expression)node);
            Type type = expressionTypes.get(NodeRef.of((Node)node.getValue()));
            InListExpression valueList = (InListExpression)node.getValueList();
            ArrayList<Object> inValues = new ArrayList<Object>(valueList.getValues().size());
            ArrayList<Expression> excludedExpressions = new ArrayList<Expression>();
            for (Expression expression : valueList.getValues()) {
                Object value = new ExpressionInterpreter(expression, this.plannerContext, this.session, expressionTypes).optimize(NoOpSymbolResolver.INSTANCE);
                if (value == null || value instanceof NullLiteral) {
                    if (!complement.booleanValue()) continue;
                    return Optional.of(new ExtractionResult((TupleDomain<Symbol>)TupleDomain.none(), (Expression)BooleanLiteral.TRUE_LITERAL));
                }
                if (value instanceof Expression) {
                    if (!complement.booleanValue()) {
                        return Optional.of(new ExtractionResult((TupleDomain<Symbol>)TupleDomain.all(), (Expression)node));
                    }
                    excludedExpressions.add((Expression)value);
                    continue;
                }
                if (TypeUtils.isFloatingPointNaN((Type)type, (Object)value)) continue;
                if (complement.booleanValue() && (type instanceof RealType || type instanceof DoubleType)) {
                    excludedExpressions.add(expression);
                    continue;
                }
                inValues.add(value);
            }
            ValueSet valueSet = ValueSet.copyOf((Type)type, inValues);
            if (complement.booleanValue()) {
                valueSet = valueSet.complement();
            }
            TupleDomain tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)symbol, (Object)Domain.create((ValueSet)valueSet, (boolean)false)));
            Object remainingExpression = excludedExpressions.isEmpty() ? BooleanLiteral.TRUE_LITERAL : (excludedExpressions.size() == 1 ? new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, node.getValue(), (Expression)Iterables.getOnlyElement(excludedExpressions))) : new NotExpression((Expression)new InPredicate(node.getValue(), (Expression)new InListExpression(excludedExpressions))));
            return Optional.of(new ExtractionResult((TupleDomain<Symbol>)tupleDomain, (Expression)remainingExpression));
        }

        protected ExtractionResult visitBetweenPredicate(BetweenPredicate node, Boolean complement) {
            return (ExtractionResult)this.process((Node)ExpressionUtils.and(new Expression[]{new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, node.getValue(), node.getMin()), new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, node.getValue(), node.getMax())}), complement);
        }

        protected ExtractionResult visitLikePredicate(LikePredicate node, Boolean complement) {
            Optional<ExtractionResult> result = this.tryVisitLikePredicate(node, complement);
            return result.orElseGet(() -> (ExtractionResult)super.visitLikePredicate(node, (Object)complement));
        }

        private Optional<ExtractionResult> tryVisitLikePredicate(LikePredicate node, Boolean complement) {
            if (!(node.getValue() instanceof SymbolReference)) {
                return Optional.empty();
            }
            if (!(node.getPattern() instanceof StringLiteral)) {
                return Optional.empty();
            }
            if (node.getEscape().isPresent() && !(node.getEscape().get() instanceof StringLiteral)) {
                return Optional.empty();
            }
            Type type = this.typeAnalyzer.getType(this.session, this.types, node.getValue());
            if (!(type instanceof VarcharType)) {
                return Optional.empty();
            }
            VarcharType varcharType = (VarcharType)type;
            Symbol symbol = Symbol.from(node.getValue());
            Slice pattern = Slices.utf8Slice((String)((StringLiteral)node.getPattern()).getValue());
            Optional<Slice> escape = node.getEscape().map(StringLiteral.class::cast).map(StringLiteral::getValue).map(Slices::utf8Slice);
            int patternConstantPrefixBytes = LikeFunctions.patternConstantPrefixBytes(pattern, escape);
            if (patternConstantPrefixBytes == pattern.length()) {
                Slice literal = LikeFunctions.unescapeLiteralLikePattern(pattern, escape);
                ValueSet valueSet = varcharType.isUnbounded() || SliceUtf8.countCodePoints((Slice)literal) <= varcharType.getBoundedLength() ? ValueSet.of((Type)type, (Object)literal, (Object[])new Object[0]) : ValueSet.none((Type)type);
                Domain domain2 = Domain.create((ValueSet)Visitor.complementIfNecessary(valueSet, (boolean)complement), (boolean)false);
                return Optional.of(new ExtractionResult((TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)symbol, (Object)domain2)), (Expression)BooleanLiteral.TRUE_LITERAL));
            }
            if (complement.booleanValue() || patternConstantPrefixBytes == 0) {
                return Optional.empty();
            }
            Slice constantPrefix = LikeFunctions.unescapeLiteralLikePattern(pattern.slice(0, patternConstantPrefixBytes), escape);
            return this.createRangeDomain(type, constantPrefix).map(domain -> new ExtractionResult((TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)symbol, (Object)domain)), (Expression)node));
        }

        protected ExtractionResult visitFunctionCall(FunctionCall node, Boolean complement) {
            Optional<ExtractionResult> result;
            String name = ResolvedFunction.extractFunctionName(node.getName());
            if (name.equals("starts_with") && (result = this.tryVisitStartsWithFunction(node, complement)).isPresent()) {
                return result.get();
            }
            return this.visitExpression((Expression)node, complement);
        }

        private Optional<ExtractionResult> tryVisitStartsWithFunction(FunctionCall node, Boolean complement) {
            List args = node.getArguments();
            if (args.size() != 2) {
                return Optional.empty();
            }
            Expression target = (Expression)args.get(0);
            if (!(target instanceof SymbolReference)) {
                return Optional.empty();
            }
            Expression prefix = (Expression)args.get(1);
            if (!(prefix instanceof StringLiteral)) {
                return Optional.empty();
            }
            Type type = this.typeAnalyzer.getType(this.session, this.types, target);
            if (!(type instanceof VarcharType)) {
                return Optional.empty();
            }
            if (complement.booleanValue()) {
                return Optional.empty();
            }
            Symbol symbol = Symbol.from(target);
            Slice constantPrefix = Slices.utf8Slice((String)((StringLiteral)prefix).getValue());
            return this.createRangeDomain(type, constantPrefix).map(domain -> new ExtractionResult((TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)symbol, (Object)domain)), (Expression)node));
        }

        private Optional<Domain> createRangeDomain(Type type, Slice constantPrefix) {
            int lastIncrementable = -1;
            for (int position = 0; position < constantPrefix.length(); position += SliceUtf8.lengthOfCodePoint((Slice)constantPrefix, (int)position)) {
                if (SliceUtf8.getCodePointAt((Slice)constantPrefix, (int)position) >= 127) continue;
                lastIncrementable = position;
            }
            if (lastIncrementable == -1) {
                return Optional.empty();
            }
            Slice lowerBound = constantPrefix;
            Slice upperBound = Slices.copyOf((Slice)constantPrefix.slice(0, lastIncrementable + SliceUtf8.lengthOfCodePoint((Slice)constantPrefix, (int)lastIncrementable)));
            SliceUtf8.setCodePointAt((int)(SliceUtf8.getCodePointAt((Slice)constantPrefix, (int)lastIncrementable) + 1), (Slice)upperBound, (int)lastIncrementable);
            Domain domain = Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)type, (Object)lowerBound, (boolean)true, (Object)upperBound, (boolean)false), (Range[])new Range[0]), (boolean)false);
            return Optional.of(domain);
        }

        protected ExtractionResult visitIsNullPredicate(IsNullPredicate node, Boolean complement) {
            if (!(node.getValue() instanceof SymbolReference)) {
                return (ExtractionResult)super.visitIsNullPredicate(node, (Object)complement);
            }
            Symbol symbol = Symbol.from(node.getValue());
            Type columnType = this.checkedTypeLookup(symbol);
            Domain domain = Visitor.complementIfNecessary(Domain.onlyNull((Type)columnType), (boolean)complement);
            return new ExtractionResult((TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)symbol, (Object)domain)), (Expression)BooleanLiteral.TRUE_LITERAL);
        }

        protected ExtractionResult visitIsNotNullPredicate(IsNotNullPredicate node, Boolean complement) {
            if (!(node.getValue() instanceof SymbolReference)) {
                return (ExtractionResult)super.visitIsNotNullPredicate(node, (Object)complement);
            }
            Symbol symbol = Symbol.from(node.getValue());
            Type columnType = this.checkedTypeLookup(symbol);
            Domain domain = Visitor.complementIfNecessary(Domain.notNull((Type)columnType), (boolean)complement);
            return new ExtractionResult((TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)symbol, (Object)domain)), (Expression)BooleanLiteral.TRUE_LITERAL);
        }

        protected ExtractionResult visitBooleanLiteral(BooleanLiteral node, Boolean complement) {
            boolean value = complement.booleanValue() ? !node.getValue() : node.getValue();
            return new ExtractionResult((TupleDomain<Symbol>)(value ? TupleDomain.all() : TupleDomain.none()), (Expression)BooleanLiteral.TRUE_LITERAL);
        }

        protected ExtractionResult visitNullLiteral(NullLiteral node, Boolean complement) {
            return new ExtractionResult((TupleDomain<Symbol>)TupleDomain.none(), (Expression)BooleanLiteral.TRUE_LITERAL);
        }
    }

    public static class ExtractionResult {
        private final TupleDomain<Symbol> tupleDomain;
        private final Expression remainingExpression;

        public ExtractionResult(TupleDomain<Symbol> tupleDomain, Expression remainingExpression) {
            this.tupleDomain = Objects.requireNonNull(tupleDomain, "tupleDomain is null");
            this.remainingExpression = Objects.requireNonNull(remainingExpression, "remainingExpression is null");
        }

        public TupleDomain<Symbol> getTupleDomain() {
            return this.tupleDomain;
        }

        public Expression getRemainingExpression() {
            return this.remainingExpression;
        }
    }

    private static class NormalizedSimpleComparison {
        private final Expression symbolExpression;
        private final ComparisonExpression.Operator comparisonOperator;
        private final NullableValue value;

        public NormalizedSimpleComparison(Expression symbolExpression, ComparisonExpression.Operator comparisonOperator, NullableValue value) {
            this.symbolExpression = Objects.requireNonNull(symbolExpression, "symbolExpression is null");
            this.comparisonOperator = Objects.requireNonNull(comparisonOperator, "comparisonOperator is null");
            this.value = Objects.requireNonNull(value, "value is null");
        }

        public Expression getSymbolExpression() {
            return this.symbolExpression;
        }

        public ComparisonExpression.Operator getComparisonOperator() {
            return this.comparisonOperator;
        }

        public NullableValue getValue() {
            return this.value;
        }
    }
}

