/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.optimizations;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.cost.TableStatsProvider;
import io.trino.execution.warnings.WarningCollector;
import io.trino.spi.connector.ConstantProperty;
import io.trino.spi.connector.GroupingProperty;
import io.trino.spi.connector.LocalProperty;
import io.trino.sql.ExpressionUtils;
import io.trino.sql.PlannerContext;
import io.trino.sql.planner.Partitioning;
import io.trino.sql.planner.PartitioningScheme;
import io.trino.sql.planner.PlanNodeIdAllocator;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolAllocator;
import io.trino.sql.planner.SystemPartitioningHandle;
import io.trino.sql.planner.TypeAnalyzer;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.planner.optimizations.LocalProperties;
import io.trino.sql.planner.optimizations.PlanOptimizer;
import io.trino.sql.planner.optimizations.StreamPreferredProperties;
import io.trino.sql.planner.optimizations.StreamPropertyDerivations;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.ApplyNode;
import io.trino.sql.planner.plan.ChildReplacer;
import io.trino.sql.planner.plan.CorrelatedJoinNode;
import io.trino.sql.planner.plan.DistinctLimitNode;
import io.trino.sql.planner.plan.EnforceSingleRowNode;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.ExplainAnalyzeNode;
import io.trino.sql.planner.plan.IndexJoinNode;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.LimitNode;
import io.trino.sql.planner.plan.MarkDistinctNode;
import io.trino.sql.planner.plan.MergeWriterNode;
import io.trino.sql.planner.plan.OutputNode;
import io.trino.sql.planner.plan.PatternRecognitionNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanVisitor;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.planner.plan.RowNumberNode;
import io.trino.sql.planner.plan.SemiJoinNode;
import io.trino.sql.planner.plan.SimpleTableExecuteNode;
import io.trino.sql.planner.plan.SortNode;
import io.trino.sql.planner.plan.SpatialJoinNode;
import io.trino.sql.planner.plan.StatisticsWriterNode;
import io.trino.sql.planner.plan.TableExecuteNode;
import io.trino.sql.planner.plan.TableFinishNode;
import io.trino.sql.planner.plan.TableWriterNode;
import io.trino.sql.planner.plan.TopNNode;
import io.trino.sql.planner.plan.TopNRankingNode;
import io.trino.sql.planner.plan.UnionNode;
import io.trino.sql.planner.plan.WindowNode;
import io.trino.sql.tree.SymbolReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class AddLocalExchanges
implements PlanOptimizer {
    private final PlannerContext plannerContext;
    private final TypeAnalyzer typeAnalyzer;

    public AddLocalExchanges(PlannerContext plannerContext, TypeAnalyzer typeAnalyzer) {
        this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
        this.typeAnalyzer = Objects.requireNonNull(typeAnalyzer, "typeAnalyzer is null");
    }

    @Override
    public PlanNode optimize(PlanNode plan, Session session, TypeProvider types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator, WarningCollector warningCollector, TableStatsProvider tableStatsProvider) {
        PlanWithProperties result = plan.accept(new Rewriter(symbolAllocator, idAllocator, session), StreamPreferredProperties.any());
        return result.getNode();
    }

    private class Rewriter
    extends PlanVisitor<PlanWithProperties, StreamPreferredProperties> {
        private final PlanNodeIdAllocator idAllocator;
        private final Session session;
        private final TypeProvider types;

        public Rewriter(SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator, Session session) {
            this.types = symbolAllocator.getTypes();
            this.idAllocator = idAllocator;
            this.session = session;
        }

        @Override
        protected PlanWithProperties visitPlan(PlanNode node, StreamPreferredProperties parentPreferences) {
            return this.planAndEnforceChildren(node, parentPreferences.withoutPreference().withDefaultParallelism(this.session), parentPreferences.withDefaultParallelism(this.session));
        }

        @Override
        public PlanWithProperties visitApply(ApplyNode node, StreamPreferredProperties parentPreferences) {
            throw new IllegalStateException("Unexpected node: " + node.getClass().getName());
        }

        @Override
        public PlanWithProperties visitCorrelatedJoin(CorrelatedJoinNode node, StreamPreferredProperties parentPreferences) {
            throw new IllegalStateException("Unexpected node: " + node.getClass().getName());
        }

        @Override
        public PlanWithProperties visitOutput(OutputNode node, StreamPreferredProperties parentPreferences) {
            return this.planAndEnforceChildren(node, StreamPreferredProperties.any().withOrderSensitivity(), StreamPreferredProperties.any().withOrderSensitivity());
        }

        @Override
        public PlanWithProperties visitExplainAnalyze(ExplainAnalyzeNode node, StreamPreferredProperties parentPreferences) {
            return this.planAndEnforceChildren(node, StreamPreferredProperties.singleStream().withOrderSensitivity(), StreamPreferredProperties.singleStream().withOrderSensitivity());
        }

        @Override
        public PlanWithProperties visitProject(ProjectNode node, StreamPreferredProperties parentPreferences) {
            if (node.getAssignments().getExpressions().stream().allMatch(expression -> expression instanceof SymbolReference || ExpressionUtils.isEffectivelyLiteral(AddLocalExchanges.this.plannerContext, this.session, expression))) {
                if (parentPreferences.isSingleStreamPreferred()) {
                    return this.planAndEnforceChildren(node, parentPreferences.withoutPreference(), parentPreferences.withDefaultParallelism(this.session));
                }
                if (parentPreferences.getPartitioningColumns().isPresent() && !parentPreferences.getPartitioningColumns().get().isEmpty()) {
                    return this.planAndEnforceChildren(node, parentPreferences.withoutPreference(), parentPreferences.withDefaultParallelism(this.session));
                }
                return this.planAndEnforceChildren(node, parentPreferences, parentPreferences.withDefaultParallelism(this.session));
            }
            return this.planAndEnforceChildren(node, parentPreferences.withoutPreference().withDefaultParallelism(this.session), parentPreferences.withDefaultParallelism(this.session));
        }

        @Override
        public PlanWithProperties visitSort(SortNode node, StreamPreferredProperties parentPreferences) {
            if (SystemSessionProperties.isDistributedSortEnabled(this.session)) {
                PlanWithProperties sortPlan = this.planAndEnforceChildren(node, StreamPreferredProperties.fixedParallelism(), StreamPreferredProperties.fixedParallelism());
                if (!sortPlan.getProperties().isSingleStream()) {
                    return this.deriveProperties((PlanNode)ExchangeNode.mergingExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.LOCAL, sortPlan.getNode(), node.getOrderingScheme()), sortPlan.getProperties());
                }
                return sortPlan;
            }
            return this.planAndEnforceChildren(node, StreamPreferredProperties.singleStream(), StreamPreferredProperties.defaultParallelism(this.session));
        }

        @Override
        public PlanWithProperties visitStatisticsWriterNode(StatisticsWriterNode node, StreamPreferredProperties context) {
            return this.planAndEnforceChildren(node, StreamPreferredProperties.singleStream(), StreamPreferredProperties.defaultParallelism(this.session));
        }

        @Override
        public PlanWithProperties visitTableFinish(TableFinishNode node, StreamPreferredProperties parentPreferences) {
            return this.planAndEnforceChildren(node, StreamPreferredProperties.singleStream(), StreamPreferredProperties.defaultParallelism(this.session));
        }

        @Override
        public PlanWithProperties visitTopN(TopNNode node, StreamPreferredProperties parentPreferences) {
            if (node.getStep() == TopNNode.Step.PARTIAL) {
                return this.planAndEnforceChildren(node, parentPreferences.withoutPreference().withDefaultParallelism(this.session), parentPreferences.withDefaultParallelism(this.session));
            }
            return this.planAndEnforceChildren(node, StreamPreferredProperties.singleStream(), StreamPreferredProperties.defaultParallelism(this.session));
        }

        @Override
        public PlanWithProperties visitLimit(LimitNode node, StreamPreferredProperties parentPreferences) {
            if (node.isWithTies()) {
                throw new IllegalStateException("Unexpected node: LimitNode with ties");
            }
            if (node.isPartial()) {
                StreamPreferredProperties requiredProperties = parentPreferences.withoutPreference().withDefaultParallelism(this.session);
                StreamPreferredProperties preferredProperties = parentPreferences.withDefaultParallelism(this.session);
                if (node.requiresPreSortedInputs()) {
                    requiredProperties = requiredProperties.withOrderSensitivity();
                    preferredProperties = preferredProperties.withOrderSensitivity();
                }
                return this.planAndEnforceChildren(node, requiredProperties, preferredProperties);
            }
            return this.planAndEnforceChildren(node, StreamPreferredProperties.singleStream(), StreamPreferredProperties.defaultParallelism(this.session));
        }

        @Override
        public PlanWithProperties visitDistinctLimit(DistinctLimitNode node, StreamPreferredProperties parentPreferences) {
            StreamPreferredProperties preferredProperties;
            StreamPreferredProperties requiredProperties;
            if (node.isPartial()) {
                requiredProperties = parentPreferences.withoutPreference().withDefaultParallelism(this.session);
                preferredProperties = parentPreferences.withDefaultParallelism(this.session);
            } else {
                requiredProperties = StreamPreferredProperties.singleStream();
                preferredProperties = StreamPreferredProperties.defaultParallelism(this.session);
            }
            return this.planAndEnforceChildren(node, requiredProperties, preferredProperties);
        }

        @Override
        public PlanWithProperties visitEnforceSingleRow(EnforceSingleRowNode node, StreamPreferredProperties parentPreferences) {
            return this.planAndEnforceChildren(node, StreamPreferredProperties.singleStream(), StreamPreferredProperties.defaultParallelism(this.session));
        }

        @Override
        public PlanWithProperties visitAggregation(AggregationNode node, StreamPreferredProperties parentPreferences) {
            Preconditions.checkState((node.getStep() == AggregationNode.Step.SINGLE ? 1 : 0) != 0, (String)"step of aggregation is expected to be SINGLE, but it is %s", (Object)((Object)node.getStep()));
            if (node.hasSingleNodeExecutionPreference(this.session, AddLocalExchanges.this.plannerContext.getMetadata())) {
                return this.planAndEnforceChildren(node, StreamPreferredProperties.singleStream(), StreamPreferredProperties.defaultParallelism(this.session));
            }
            List<Symbol> groupingKeys = node.getGroupingKeys();
            if (node.hasDefaultOutput()) {
                Preconditions.checkState((boolean)node.isDecomposable(this.session, AddLocalExchanges.this.plannerContext.getMetadata()));
                PlanWithProperties child = this.planAndEnforce(node.getSource(), StreamPreferredProperties.any(), StreamPreferredProperties.defaultParallelism(this.session));
                PlanWithProperties exchange = this.deriveProperties((PlanNode)ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.LOCAL, child.getNode(), groupingKeys, Optional.empty()), child.getProperties());
                return this.rebaseAndDeriveProperties(node, (List<PlanWithProperties>)ImmutableList.of((Object)exchange));
            }
            StreamPreferredProperties childRequirements = parentPreferences.constrainTo(node.getSource().getOutputSymbols()).withDefaultParallelism(this.session).withPartitioning(groupingKeys);
            PlanWithProperties child = this.planAndEnforce(node.getSource(), childRequirements, childRequirements);
            Object preGroupedSymbols = ImmutableList.of();
            if (LocalProperties.match(child.getProperties().getLocalProperties(), LocalProperties.grouped(groupingKeys)).get(0).isEmpty()) {
                preGroupedSymbols = groupingKeys;
            }
            AggregationNode result = AggregationNode.builderFrom(node).setSource(child.getNode()).setPreGroupedSymbols((List<Symbol>)preGroupedSymbols).build();
            return this.deriveProperties((PlanNode)result, child.getProperties());
        }

        @Override
        public PlanWithProperties visitWindow(WindowNode node, StreamPreferredProperties parentPreferences) {
            StreamPreferredProperties childRequirements = parentPreferences.constrainTo(node.getSource().getOutputSymbols()).withDefaultParallelism(this.session).withPartitioning(node.getPartitionBy());
            PlanWithProperties child = this.planAndEnforce(node.getSource(), childRequirements, childRequirements);
            ArrayList desiredProperties = new ArrayList();
            if (!node.getPartitionBy().isEmpty()) {
                desiredProperties.add(new GroupingProperty(node.getPartitionBy()));
            }
            node.getOrderingScheme().ifPresent(orderingScheme -> desiredProperties.addAll(orderingScheme.toLocalProperties()));
            Iterator matchIterator = LocalProperties.match(child.getProperties().getLocalProperties(), desiredProperties).iterator();
            Object prePartitionedInputs = ImmutableSet.of();
            if (!node.getPartitionBy().isEmpty()) {
                Optional<LocalProperty<LocalProperty>> groupingRequirement = matchIterator.next();
                Set unPartitionedInputs = groupingRequirement.map(LocalProperty::getColumns).orElse((Set)ImmutableSet.of());
                prePartitionedInputs = (Set)node.getPartitionBy().stream().filter(symbol -> !unPartitionedInputs.contains(symbol)).collect(ImmutableSet.toImmutableSet());
            }
            int preSortedOrderPrefix = 0;
            if (prePartitionedInputs.equals(ImmutableSet.copyOf(node.getPartitionBy()))) {
                while (matchIterator.hasNext() && matchIterator.next().isEmpty()) {
                    ++preSortedOrderPrefix;
                }
            }
            WindowNode result = new WindowNode(node.getId(), child.getNode(), node.getSpecification(), node.getWindowFunctions(), node.getHashSymbol(), (Set<Symbol>)prePartitionedInputs, preSortedOrderPrefix);
            return this.deriveProperties((PlanNode)result, child.getProperties());
        }

        @Override
        public PlanWithProperties visitPatternRecognition(PatternRecognitionNode node, StreamPreferredProperties parentPreferences) {
            StreamPreferredProperties childRequirements = parentPreferences.constrainTo(node.getSource().getOutputSymbols()).withDefaultParallelism(this.session).withPartitioning(node.getPartitionBy());
            PlanWithProperties child = this.planAndEnforce(node.getSource(), childRequirements, childRequirements);
            ArrayList desiredProperties = new ArrayList();
            if (!node.getPartitionBy().isEmpty()) {
                desiredProperties.add(new GroupingProperty(node.getPartitionBy()));
            }
            node.getOrderingScheme().ifPresent(orderingScheme -> desiredProperties.addAll(orderingScheme.toLocalProperties()));
            Iterator matchIterator = LocalProperties.match(child.getProperties().getLocalProperties(), desiredProperties).iterator();
            Object prePartitionedInputs = ImmutableSet.of();
            if (!node.getPartitionBy().isEmpty()) {
                Optional<LocalProperty<LocalProperty>> groupingRequirement = matchIterator.next();
                Set unPartitionedInputs = groupingRequirement.map(LocalProperty::getColumns).orElse((Set)ImmutableSet.of());
                prePartitionedInputs = (Set)node.getPartitionBy().stream().filter(symbol -> !unPartitionedInputs.contains(symbol)).collect(ImmutableSet.toImmutableSet());
            }
            int preSortedOrderPrefix = 0;
            if (prePartitionedInputs.equals(ImmutableSet.copyOf(node.getPartitionBy()))) {
                while (matchIterator.hasNext() && matchIterator.next().isEmpty()) {
                    ++preSortedOrderPrefix;
                }
            }
            PatternRecognitionNode result = new PatternRecognitionNode(node.getId(), child.getNode(), node.getSpecification(), node.getHashSymbol(), (Set<Symbol>)prePartitionedInputs, preSortedOrderPrefix, node.getWindowFunctions(), node.getMeasures(), node.getCommonBaseFrame(), node.getRowsPerMatch(), node.getSkipToLabel(), node.getSkipToPosition(), node.isInitial(), node.getPattern(), node.getSubsets(), node.getVariableDefinitions());
            return this.deriveProperties((PlanNode)result, child.getProperties());
        }

        @Override
        public PlanWithProperties visitMarkDistinct(MarkDistinctNode node, StreamPreferredProperties parentPreferences) {
            StreamPreferredProperties childRequirements = parentPreferences.constrainTo(node.getSource().getOutputSymbols()).withDefaultParallelism(this.session).withPartitioning(node.getDistinctSymbols());
            PlanWithProperties child = this.planAndEnforce(node.getSource(), childRequirements, childRequirements);
            MarkDistinctNode result = new MarkDistinctNode(node.getId(), child.getNode(), node.getMarkerSymbol(), this.pruneMarkDistinctSymbols(node, child.getProperties().getLocalProperties()), node.getHashSymbol());
            return this.deriveProperties((PlanNode)result, child.getProperties());
        }

        private List<Symbol> pruneMarkDistinctSymbols(MarkDistinctNode node, List<LocalProperty<Symbol>> localProperties) {
            if (localProperties.isEmpty()) {
                return node.getDistinctSymbols();
            }
            ImmutableSet.Builder redundantSymbolsBuilder = ImmutableSet.builder();
            for (LocalProperty<Symbol> property : localProperties) {
                if (property instanceof ConstantProperty) {
                    redundantSymbolsBuilder.add((Object)((Symbol)((ConstantProperty)property).getColumn()));
                    continue;
                }
                if (node.getDistinctSymbols().containsAll(property.getColumns())) continue;
                break;
            }
            ImmutableSet redundantSymbols = redundantSymbolsBuilder.build();
            List remainingSymbols = (List)node.getDistinctSymbols().stream().filter(arg_0 -> Rewriter.lambda$pruneMarkDistinctSymbols$5((Set)redundantSymbols, arg_0)).collect(ImmutableList.toImmutableList());
            if (remainingSymbols.isEmpty()) {
                return ImmutableList.of((Object)node.getDistinctSymbols().get(0));
            }
            return remainingSymbols;
        }

        @Override
        public PlanWithProperties visitRowNumber(RowNumberNode node, StreamPreferredProperties parentPreferences) {
            StreamPreferredProperties requiredProperties;
            if (node.isOrderSensitive()) {
                Verify.verify((boolean)node.getPartitionBy().isEmpty(), (String)"unexpected partitioning", (Object[])new Object[0]);
                requiredProperties = StreamPreferredProperties.singleStream().withOrderSensitivity();
            } else {
                requiredProperties = parentPreferences.withDefaultParallelism(this.session).withPartitioning(node.getPartitionBy());
            }
            return this.planAndEnforceChildren(node, requiredProperties, requiredProperties);
        }

        @Override
        public PlanWithProperties visitTopNRanking(TopNRankingNode node, StreamPreferredProperties parentPreferences) {
            StreamPreferredProperties requiredProperties = parentPreferences.withDefaultParallelism(this.session);
            if (!node.isPartial()) {
                requiredProperties = requiredProperties.withPartitioning(node.getPartitionBy());
            }
            return this.planAndEnforceChildren(node, requiredProperties, requiredProperties);
        }

        @Override
        public PlanWithProperties visitSimpleTableExecuteNode(SimpleTableExecuteNode node, StreamPreferredProperties context) {
            return this.planAndEnforceChildren(node, StreamPreferredProperties.singleStream(), StreamPreferredProperties.singleStream());
        }

        @Override
        public PlanWithProperties visitTableWriter(TableWriterNode node, StreamPreferredProperties parentPreferences) {
            return this.visitTableWriter(node, node.getPartitioningScheme(), node.getSource(), parentPreferences, node.getTarget());
        }

        @Override
        public PlanWithProperties visitTableExecute(TableExecuteNode node, StreamPreferredProperties parentPreferences) {
            return this.visitTableWriter(node, node.getPartitioningScheme(), node.getSource(), parentPreferences, node.getTarget());
        }

        private PlanWithProperties visitTableWriter(PlanNode node, Optional<PartitioningScheme> partitioningSchemeOptional, PlanNode source, StreamPreferredProperties parentPreferences, TableWriterNode.WriterTarget writerTarget) {
            return partitioningSchemeOptional.map(partitioningScheme -> this.visitPartitionedWriter(node, (PartitioningScheme)partitioningScheme, source, parentPreferences)).orElseGet(() -> this.visitUnpartitionedWriter(node, source, writerTarget));
        }

        private PlanWithProperties visitUnpartitionedWriter(PlanNode node, PlanNode source, TableWriterNode.WriterTarget writerTarget) {
            if (SystemSessionProperties.isTaskScaleWritersEnabled(this.session) && writerTarget.supportsReportingWrittenBytes(AddLocalExchanges.this.plannerContext.getMetadata(), this.session)) {
                PlanWithProperties newSource = source.accept(this, StreamPreferredProperties.defaultParallelism(this.session));
                PlanWithProperties exchange = this.deriveProperties((PlanNode)ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.LOCAL, newSource.getNode(), new PartitioningScheme(Partitioning.create(SystemPartitioningHandle.SCALED_WRITER_DISTRIBUTION, (List<Symbol>)ImmutableList.of()), newSource.getNode().getOutputSymbols())), newSource.getProperties());
                return this.rebaseAndDeriveProperties(node, (List<PlanWithProperties>)ImmutableList.of((Object)exchange));
            }
            if (SystemSessionProperties.getTaskWriterCount(this.session) == 1) {
                return this.planAndEnforceChildren(node, StreamPreferredProperties.singleStream(), StreamPreferredProperties.defaultParallelism(this.session));
            }
            return this.planAndEnforceChildren(node, StreamPreferredProperties.fixedParallelism(), StreamPreferredProperties.fixedParallelism());
        }

        private PlanWithProperties visitPartitionedWriter(PlanNode node, PartitioningScheme partitioningScheme, PlanNode source, StreamPreferredProperties parentPreferences) {
            if (SystemSessionProperties.getTaskPartitionedWriterCount(this.session) == 1) {
                return this.planAndEnforceChildren(node, StreamPreferredProperties.singleStream(), StreamPreferredProperties.defaultParallelism(this.session));
            }
            if (partitioningScheme.getPartitioning().getHandle().equals(SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION)) {
                StreamPreferredProperties preference = StreamPreferredProperties.partitionedOn(partitioningScheme.getPartitioning().getColumns());
                return this.planAndEnforceChildren(node, preference, preference);
            }
            Verify.verify((!(partitioningScheme.getPartitioning().getHandle().getConnectorHandle() instanceof SystemPartitioningHandle) ? 1 : 0) != 0);
            Verify.verify((boolean)partitioningScheme.getPartitioning().getArguments().stream().noneMatch(Partitioning.ArgumentBinding::isConstant), (String)"Table writer partitioning has constant arguments", (Object[])new Object[0]);
            PlanWithProperties newSource = source.accept(this, parentPreferences);
            PlanWithProperties exchange = this.deriveProperties((PlanNode)ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.LOCAL, newSource.getNode(), partitioningScheme), newSource.getProperties());
            return this.rebaseAndDeriveProperties(node, (List<PlanWithProperties>)ImmutableList.of((Object)exchange));
        }

        @Override
        public PlanWithProperties visitMergeWriter(MergeWriterNode node, StreamPreferredProperties parentPreferences) {
            return node.getPartitioningScheme().map(partitioningScheme -> this.visitPartitionedWriter(node, (PartitioningScheme)partitioningScheme, node.getSource(), parentPreferences)).orElseGet(() -> this.visitUnpartitionedWriter(node, node.getSource(), node.getTarget()));
        }

        @Override
        public PlanWithProperties visitExchange(ExchangeNode node, StreamPreferredProperties parentPreferences) {
            Preconditions.checkArgument((node.getScope() != ExchangeNode.Scope.LOCAL ? 1 : 0) != 0, (Object)"AddLocalExchanges cannot process a plan containing a local exchange");
            if (node.getOrderingScheme().isPresent()) {
                return this.planAndEnforceChildren(node, StreamPreferredProperties.any().withOrderSensitivity(), StreamPreferredProperties.any().withOrderSensitivity());
            }
            return this.planAndEnforceChildren(node, StreamPreferredProperties.any(), StreamPreferredProperties.defaultParallelism(this.session));
        }

        @Override
        public PlanWithProperties visitUnion(UnionNode node, StreamPreferredProperties preferredProperties) {
            List sourcesWithProperties = (List)node.getSources().stream().map(source -> source.accept(this, StreamPreferredProperties.any())).collect(ImmutableList.toImmutableList());
            List sources = (List)sourcesWithProperties.stream().map(PlanWithProperties::getNode).collect(ImmutableList.toImmutableList());
            List inputProperties = (List)sourcesWithProperties.stream().map(PlanWithProperties::getProperties).collect(ImmutableList.toImmutableList());
            ArrayList<List<Symbol>> inputLayouts = new ArrayList<List<Symbol>>(sources.size());
            for (int i = 0; i < sources.size(); ++i) {
                inputLayouts.add(node.sourceOutputLayout(i));
            }
            if (preferredProperties.isSingleStreamPreferred()) {
                ExchangeNode exchangeNode = new ExchangeNode(this.idAllocator.getNextId(), ExchangeNode.Type.GATHER, ExchangeNode.Scope.LOCAL, new PartitioningScheme(Partitioning.create(SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List<Symbol>)ImmutableList.of()), node.getOutputSymbols()), sources, inputLayouts, Optional.empty());
                return this.deriveProperties((PlanNode)exchangeNode, inputProperties);
            }
            Optional<List<Symbol>> preferredPartitionColumns = preferredProperties.getPartitioningColumns();
            if (preferredPartitionColumns.isPresent()) {
                ExchangeNode exchangeNode = new ExchangeNode(this.idAllocator.getNextId(), ExchangeNode.Type.REPARTITION, ExchangeNode.Scope.LOCAL, new PartitioningScheme(Partitioning.create(SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION, preferredPartitionColumns.get()), node.getOutputSymbols(), Optional.empty()), sources, inputLayouts, Optional.empty());
                return this.deriveProperties((PlanNode)exchangeNode, inputProperties);
            }
            ExchangeNode exchangeNode = new ExchangeNode(this.idAllocator.getNextId(), ExchangeNode.Type.REPARTITION, ExchangeNode.Scope.LOCAL, new PartitioningScheme(Partitioning.create(SystemPartitioningHandle.FIXED_ARBITRARY_DISTRIBUTION, (List<Symbol>)ImmutableList.of()), node.getOutputSymbols()), sources, inputLayouts, Optional.empty());
            return this.deriveProperties((PlanNode)exchangeNode, inputProperties);
        }

        @Override
        public PlanWithProperties visitJoin(JoinNode node, StreamPreferredProperties parentPreferences) {
            PlanWithProperties probe = this.planAndEnforce(node.getLeft(), StreamPreferredProperties.defaultParallelism(this.session), parentPreferences.constrainTo(node.getLeft().getOutputSymbols()).withDefaultParallelism(this.session));
            if (SystemSessionProperties.isSpillEnabled(this.session)) {
                node = probe.getProperties().getDistribution() != StreamPropertyDerivations.StreamProperties.StreamDistribution.FIXED ? node.withSpillable(false) : node.withSpillable(true);
            }
            List buildHashSymbols = Lists.transform(node.getCriteria(), JoinNode.EquiJoinClause::getRight);
            StreamPreferredProperties buildPreference = SystemSessionProperties.getTaskConcurrency(this.session) > 1 ? StreamPreferredProperties.exactlyPartitionedOn(buildHashSymbols) : StreamPreferredProperties.singleStream();
            PlanWithProperties build = this.planAndEnforce(node.getRight(), buildPreference, buildPreference);
            return this.rebaseAndDeriveProperties(node, (List<PlanWithProperties>)ImmutableList.of((Object)probe, (Object)build));
        }

        @Override
        public PlanWithProperties visitSemiJoin(SemiJoinNode node, StreamPreferredProperties parentPreferences) {
            PlanWithProperties source = this.planAndEnforce(node.getSource(), StreamPreferredProperties.defaultParallelism(this.session), parentPreferences.constrainTo(node.getSource().getOutputSymbols()).withDefaultParallelism(this.session));
            PlanWithProperties filteringSource = this.planAndEnforce(node.getFilteringSource(), StreamPreferredProperties.singleStream(), StreamPreferredProperties.singleStream());
            return this.rebaseAndDeriveProperties(node, (List<PlanWithProperties>)ImmutableList.of((Object)source, (Object)filteringSource));
        }

        @Override
        public PlanWithProperties visitSpatialJoin(SpatialJoinNode node, StreamPreferredProperties parentPreferences) {
            PlanWithProperties probe = this.planAndEnforce(node.getLeft(), StreamPreferredProperties.defaultParallelism(this.session), parentPreferences.constrainTo(node.getLeft().getOutputSymbols()).withDefaultParallelism(this.session));
            PlanWithProperties build = this.planAndEnforce(node.getRight(), StreamPreferredProperties.singleStream(), StreamPreferredProperties.singleStream());
            return this.rebaseAndDeriveProperties(node, (List<PlanWithProperties>)ImmutableList.of((Object)probe, (Object)build));
        }

        @Override
        public PlanWithProperties visitIndexJoin(IndexJoinNode node, StreamPreferredProperties parentPreferences) {
            PlanWithProperties probe = this.planAndEnforce(node.getProbeSource(), StreamPreferredProperties.defaultParallelism(this.session), parentPreferences.constrainTo(node.getProbeSource().getOutputSymbols()).withDefaultParallelism(this.session));
            StreamPropertyDerivations.StreamProperties indexStreamProperties = StreamPropertyDerivations.derivePropertiesRecursively(node.getIndexSource(), AddLocalExchanges.this.plannerContext, this.session, this.types, AddLocalExchanges.this.typeAnalyzer);
            Preconditions.checkArgument((indexStreamProperties.getDistribution() == StreamPropertyDerivations.StreamProperties.StreamDistribution.SINGLE ? 1 : 0) != 0, (Object)"index source must be single stream");
            PlanWithProperties index = new PlanWithProperties(node.getIndexSource(), indexStreamProperties);
            return this.rebaseAndDeriveProperties(node, (List<PlanWithProperties>)ImmutableList.of((Object)probe, (Object)index));
        }

        private PlanWithProperties planAndEnforceChildren(PlanNode node, StreamPreferredProperties requiredProperties, StreamPreferredProperties preferredProperties) {
            List children = (List)node.getSources().stream().map(source -> this.planAndEnforce((PlanNode)source, requiredProperties.constrainTo(source.getOutputSymbols()), preferredProperties.constrainTo(source.getOutputSymbols()))).collect(ImmutableList.toImmutableList());
            return this.rebaseAndDeriveProperties(node, children);
        }

        private PlanWithProperties planAndEnforce(PlanNode node, StreamPreferredProperties requiredProperties, StreamPreferredProperties preferredProperties) {
            List<Symbol> outputSymbols = node.getOutputSymbols();
            Preconditions.checkArgument((boolean)requiredProperties.getPartitioningColumns().map(outputSymbols::containsAll).orElse(true));
            Preconditions.checkArgument((boolean)preferredProperties.getPartitioningColumns().map(outputSymbols::containsAll).orElse(true));
            PlanWithProperties result = node.accept(this, preferredProperties);
            result = this.enforce(result, requiredProperties);
            Preconditions.checkState((boolean)requiredProperties.isSatisfiedBy(result.getProperties()), (Object)"required properties not enforced");
            return result;
        }

        private PlanWithProperties enforce(PlanWithProperties planWithProperties, StreamPreferredProperties requiredProperties) {
            if (requiredProperties.isSatisfiedBy(planWithProperties.getProperties())) {
                return planWithProperties;
            }
            if (requiredProperties.isSingleStreamPreferred()) {
                ExchangeNode exchangeNode = ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.LOCAL, planWithProperties.getNode());
                return this.deriveProperties((PlanNode)exchangeNode, planWithProperties.getProperties());
            }
            Optional<List<Symbol>> requiredPartitionColumns = requiredProperties.getPartitioningColumns();
            if (requiredPartitionColumns.isEmpty()) {
                ExchangeNode exchangeNode = ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.LOCAL, planWithProperties.getNode(), new PartitioningScheme(Partitioning.create(SystemPartitioningHandle.FIXED_ARBITRARY_DISTRIBUTION, (List<Symbol>)ImmutableList.of()), planWithProperties.getNode().getOutputSymbols()));
                return this.deriveProperties((PlanNode)exchangeNode, planWithProperties.getProperties());
            }
            if (requiredProperties.isParallelPreferred()) {
                ExchangeNode exchangeNode = ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.LOCAL, planWithProperties.getNode(), requiredPartitionColumns.get(), Optional.empty());
                return this.deriveProperties((PlanNode)exchangeNode, planWithProperties.getProperties());
            }
            ExchangeNode exchangeNode = ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.LOCAL, planWithProperties.getNode());
            return this.deriveProperties((PlanNode)exchangeNode, planWithProperties.getProperties());
        }

        private PlanWithProperties rebaseAndDeriveProperties(PlanNode node, List<PlanWithProperties> children) {
            PlanNode result = ChildReplacer.replaceChildren(node, children.stream().map(PlanWithProperties::getNode).collect(Collectors.toList()));
            List inputProperties = (List)children.stream().map(PlanWithProperties::getProperties).collect(ImmutableList.toImmutableList());
            return this.deriveProperties(result, inputProperties);
        }

        private PlanWithProperties deriveProperties(PlanNode result, StreamPropertyDerivations.StreamProperties inputProperties) {
            return new PlanWithProperties(result, StreamPropertyDerivations.deriveProperties(result, inputProperties, AddLocalExchanges.this.plannerContext, this.session, this.types, AddLocalExchanges.this.typeAnalyzer));
        }

        private PlanWithProperties deriveProperties(PlanNode result, List<StreamPropertyDerivations.StreamProperties> inputProperties) {
            return new PlanWithProperties(result, StreamPropertyDerivations.deriveProperties(result, inputProperties, AddLocalExchanges.this.plannerContext, this.session, this.types, AddLocalExchanges.this.typeAnalyzer));
        }

        private static /* synthetic */ boolean lambda$pruneMarkDistinctSymbols$5(Set redundantSymbols, Symbol symbol) {
            return !redundantSymbols.contains(symbol);
        }
    }

    private static class PlanWithProperties {
        private final PlanNode node;
        private final StreamPropertyDerivations.StreamProperties properties;

        public PlanWithProperties(PlanNode node, StreamPropertyDerivations.StreamProperties properties) {
            this.node = Objects.requireNonNull(node, "node is null");
            this.properties = Objects.requireNonNull(properties, "properties is null");
        }

        public PlanNode getNode() {
            return this.node;
        }

        public StreamPropertyDerivations.StreamProperties getProperties() {
            return this.properties;
        }
    }
}

