/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.optimizations;

import io.trino.Session;
import io.trino.cost.TableStatsProvider;
import io.trino.execution.warnings.WarningCollector;
import io.trino.sql.planner.OptimizerStatsRecorder;
import io.trino.sql.planner.PlanNodeIdAllocator;
import io.trino.sql.planner.SymbolAllocator;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.planner.optimizations.PlanOptimizer;
import io.trino.sql.planner.plan.PlanNode;
import java.util.Objects;

public final class StatsRecordingPlanOptimizer
implements PlanOptimizer {
    private final OptimizerStatsRecorder stats;
    private final PlanOptimizer delegate;

    public StatsRecordingPlanOptimizer(OptimizerStatsRecorder stats, PlanOptimizer delegate) {
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        stats.register(delegate);
    }

    @Override
    public PlanNode optimize(PlanNode plan, Session session, TypeProvider types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator, WarningCollector warningCollector, TableStatsProvider tableStatsProvider) {
        long duration;
        PlanNode result;
        try {
            long start = System.nanoTime();
            result = this.delegate.optimize(plan, session, types, symbolAllocator, idAllocator, warningCollector, tableStatsProvider);
            duration = System.nanoTime() - start;
        }
        catch (RuntimeException e) {
            this.stats.recordFailure(this.delegate);
            throw e;
        }
        this.stats.record(this.delegate, duration);
        return result;
    }
}

