/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector;

import com.google.common.base.MoreObjects;
import io.trino.connector.CatalogProperties;
import io.trino.connector.ConnectorServices;
import io.trino.metadata.Catalog;
import io.trino.spi.connector.CatalogHandle;
import java.util.Objects;
import java.util.Optional;

public class CatalogConnector {
    private final CatalogHandle catalogHandle;
    private final String connectorName;
    private final ConnectorServices catalogConnector;
    private final ConnectorServices informationSchemaConnector;
    private final ConnectorServices systemConnector;
    private final Optional<CatalogProperties> catalogProperties;
    private final Catalog catalog;

    public CatalogConnector(CatalogHandle catalogHandle, String connectorName, ConnectorServices catalogConnector, ConnectorServices informationSchemaConnector, ConnectorServices systemConnector, Optional<CatalogProperties> catalogProperties) {
        this.catalogHandle = Objects.requireNonNull(catalogHandle, "catalogHandle is null");
        this.connectorName = Objects.requireNonNull(connectorName, "connectorName is null");
        this.catalogConnector = Objects.requireNonNull(catalogConnector, "catalogConnector is null");
        this.informationSchemaConnector = Objects.requireNonNull(informationSchemaConnector, "informationSchemaConnector is null");
        this.systemConnector = Objects.requireNonNull(systemConnector, "systemConnector is null");
        this.catalogProperties = Objects.requireNonNull(catalogProperties, "catalogProperties is null");
        this.catalog = new Catalog(catalogHandle.getCatalogName(), catalogHandle, connectorName, catalogConnector, informationSchemaConnector, systemConnector);
    }

    public CatalogHandle getCatalogHandle() {
        return this.catalogHandle;
    }

    public String getConnectorName() {
        return this.connectorName;
    }

    public Optional<CatalogProperties> getCatalogProperties() {
        return this.catalogProperties;
    }

    public Catalog getCatalog() {
        return this.catalog;
    }

    public ConnectorServices getMaterializedConnector(CatalogHandle.CatalogHandleType type) {
        switch (type) {
            case NORMAL: {
                return this.catalogConnector;
            }
            case INFORMATION_SCHEMA: {
                return this.informationSchemaConnector;
            }
            case SYSTEM: {
                return this.systemConnector;
            }
        }
        throw new IllegalArgumentException("Unknown type " + type);
    }

    public void shutdown() {
        this.catalogConnector.shutdown();
        this.informationSchemaConnector.shutdown();
        this.systemConnector.shutdown();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("catalogHandle", (Object)this.catalogHandle).add("connectorName", (Object)this.connectorName).toString();
    }
}

