/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import io.airlift.log.Logger;
import io.trino.Session;
import io.trino.connector.CatalogConnector;
import io.trino.connector.CatalogFactory;
import io.trino.connector.CatalogProperties;
import io.trino.connector.CatalogStore;
import io.trino.connector.ConnectorServices;
import io.trino.connector.ConnectorServicesProvider;
import io.trino.connector.system.GlobalSystemConnector;
import io.trino.metadata.Catalog;
import io.trino.metadata.CatalogManager;
import io.trino.server.ForStartup;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.CatalogHandle;
import io.trino.util.Executors;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.PreDestroy;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;

@ThreadSafe
public class CoordinatorDynamicCatalogManager
implements CatalogManager,
ConnectorServicesProvider {
    private static final Logger log = Logger.get(CoordinatorDynamicCatalogManager.class);
    private final CatalogStore catalogStore;
    private final CatalogFactory catalogFactory;
    private final Executor executor;
    private final Lock catalogsUpdateLock = new ReentrantLock();
    private final ConcurrentMap<String, CatalogConnector> catalogs = new ConcurrentHashMap<String, CatalogConnector>();
    @GuardedBy(value="catalogsUpdateLock")
    private State state = State.CREATED;

    @Inject
    public CoordinatorDynamicCatalogManager(CatalogStore catalogStore, CatalogFactory catalogFactory, @ForStartup Executor executor) {
        this.catalogStore = Objects.requireNonNull(catalogStore, "catalogStore is null");
        this.catalogFactory = Objects.requireNonNull(catalogFactory, "catalogFactory is null");
        this.executor = Objects.requireNonNull(executor, "executor is null");
    }

    @PreDestroy
    public void stop() {
        ImmutableList catalogs;
        this.catalogsUpdateLock.lock();
        try {
            if (this.state == State.STOPPED) {
                return;
            }
            this.state = State.STOPPED;
            catalogs = ImmutableList.copyOf(this.catalogs.values());
            this.catalogs.clear();
        }
        finally {
            this.catalogsUpdateLock.unlock();
        }
        for (CatalogConnector connector : catalogs) {
            connector.shutdown();
        }
    }

    @Override
    public void loadInitialCatalogs() {
        this.catalogsUpdateLock.lock();
        try {
            if (this.state == State.INITIALIZED) {
                return;
            }
            Preconditions.checkState((this.state != State.STOPPED ? 1 : 0) != 0, (Object)"ConnectorManager is stopped");
            this.state = State.INITIALIZED;
            Executors.executeUntilFailure(this.executor, (Collection)this.catalogStore.getCatalogs().stream().map(catalog -> () -> {
                log.info("-- Loading catalog %s --", new Object[]{catalog.getCatalogHandle().getCatalogName()});
                CatalogConnector newCatalog = this.catalogFactory.createCatalog((CatalogProperties)catalog);
                this.catalogs.put(catalog.getCatalogHandle().getCatalogName(), newCatalog);
                log.info("-- Added catalog %s using connector %s --", new Object[]{catalog.getCatalogHandle().getCatalogName(), catalog.getConnectorName()});
                return null;
            }).collect(ImmutableList.toImmutableList()));
        }
        finally {
            this.catalogsUpdateLock.unlock();
        }
    }

    @Override
    public Set<String> getCatalogNames() {
        return ImmutableSet.copyOf(this.catalogs.keySet());
    }

    @Override
    public Optional<Catalog> getCatalog(String catalogName) {
        return Optional.ofNullable((CatalogConnector)this.catalogs.get(catalogName)).map(CatalogConnector::getCatalog);
    }

    @Override
    public void ensureCatalogsLoaded(Session session, List<CatalogProperties> catalogs) {
        List missingCatalogs = (List)catalogs.stream().filter(catalog -> !this.catalogs.containsKey(catalog.getCatalogHandle().getCatalogName())).collect(ImmutableList.toImmutableList());
        if (!missingCatalogs.isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.CATALOG_NOT_AVAILABLE, "Missing catalogs: " + missingCatalogs);
        }
    }

    @Override
    public Optional<CatalogProperties> getCatalogProperties(CatalogHandle catalogHandle) {
        return Optional.ofNullable((CatalogConnector)this.catalogs.get(catalogHandle.getCatalogName())).flatMap(CatalogConnector::getCatalogProperties);
    }

    @Override
    public ConnectorServices getConnectorServices(CatalogHandle catalogHandle) {
        CatalogConnector catalogConnector = (CatalogConnector)this.catalogs.get(catalogHandle.getCatalogName());
        Preconditions.checkArgument((catalogConnector != null ? 1 : 0) != 0, (String)"No catalog '%s'", (Object)catalogHandle.getCatalogName());
        return catalogConnector.getMaterializedConnector(catalogHandle.getType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createCatalog(String catalogName, String connectorName, Map<String, String> properties) {
        Objects.requireNonNull(catalogName, "catalogName is null");
        Objects.requireNonNull(connectorName, "connectorName is null");
        Objects.requireNonNull(properties, "properties is null");
        this.catalogsUpdateLock.lock();
        try {
            Preconditions.checkState((this.state != State.STOPPED ? 1 : 0) != 0, (Object)"ConnectorManager is stopped");
            if (this.catalogs.containsKey(catalogName)) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, String.format("Catalog '%s' already exists", catalogName));
            }
            CatalogHandle catalogHandle = CatalogHandle.createRootCatalogHandle((String)catalogName, (CatalogHandle.CatalogVersion)CoordinatorDynamicCatalogManager.computeCatalogVersion(catalogName, connectorName, properties));
            CatalogProperties catalogProperties = new CatalogProperties(catalogHandle, connectorName, properties);
            CatalogConnector catalog = this.catalogFactory.createCatalog(catalogProperties);
            this.catalogs.put(catalogName, catalog);
        }
        finally {
            this.catalogsUpdateLock.unlock();
        }
    }

    public void registerGlobalSystemConnector(GlobalSystemConnector connector) {
        Objects.requireNonNull(connector, "connector is null");
        this.catalogsUpdateLock.lock();
        try {
            if (this.state == State.STOPPED) {
                return;
            }
            CatalogConnector catalog = this.catalogFactory.createCatalog(GlobalSystemConnector.CATALOG_HANDLE, "system", connector);
            if (this.catalogs.putIfAbsent("system", catalog) != null) {
                throw new IllegalStateException("Global system catalog already registered");
            }
        }
        finally {
            this.catalogsUpdateLock.unlock();
        }
    }

    static CatalogHandle.CatalogVersion computeCatalogVersion(String catalogName, String connectorName, Map<String, String> properties) {
        Hasher hasher = Hashing.sha256().newHasher();
        hasher.putUnencodedChars((CharSequence)"catalog-hash");
        CoordinatorDynamicCatalogManager.hashLengthPrefixedString(hasher, catalogName);
        CoordinatorDynamicCatalogManager.hashLengthPrefixedString(hasher, connectorName);
        hasher.putInt(properties.size());
        ImmutableSortedMap.copyOf(properties).forEach((key, value) -> {
            CoordinatorDynamicCatalogManager.hashLengthPrefixedString(hasher, key);
            CoordinatorDynamicCatalogManager.hashLengthPrefixedString(hasher, value);
        });
        return new CatalogHandle.CatalogVersion(hasher.hash().toString());
    }

    private static void hashLengthPrefixedString(Hasher hasher, String value) {
        hasher.putInt(value.length());
        hasher.putUnencodedChars((CharSequence)value);
    }

    private static enum State {
        CREATED,
        INITIALIZED,
        STOPPED;

    }
}

