/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector;

import com.google.common.base.Preconditions;
import io.trino.connector.CatalogConnector;
import io.trino.connector.CatalogFactory;
import io.trino.connector.CatalogProperties;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorFactory;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;

public class LazyCatalogFactory
implements CatalogFactory {
    private final AtomicReference<CatalogFactory> delegate = new AtomicReference();

    public void setCatalogFactory(CatalogFactory catalogFactory) {
        Preconditions.checkState((boolean)this.delegate.compareAndSet(null, catalogFactory), (Object)"catalogFactory already set");
    }

    @Override
    public void addConnectorFactory(ConnectorFactory connectorFactory, Function<CatalogHandle, ClassLoader> duplicatePluginClassLoaderFactory) {
        this.getDelegate().addConnectorFactory(connectorFactory, duplicatePluginClassLoaderFactory);
    }

    @Override
    public CatalogConnector createCatalog(CatalogProperties catalogProperties) {
        return this.getDelegate().createCatalog(catalogProperties);
    }

    @Override
    public CatalogConnector createCatalog(CatalogHandle catalogHandle, String connectorName, Connector connector) {
        return this.getDelegate().createCatalog(catalogHandle, connectorName, connector);
    }

    private CatalogFactory getDelegate() {
        CatalogFactory catalogFactory = this.delegate.get();
        Preconditions.checkState((catalogFactory != null ? 1 : 0) != 0, (Object)"Catalog factory is not set");
        return catalogFactory;
    }
}

