/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector.system;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import io.trino.FullConnectorSession;
import io.trino.annotation.UsedByGeneratedCode;
import io.trino.dispatcher.DispatchManager;
import io.trino.dispatcher.DispatchQuery;
import io.trino.plugin.base.util.Procedures;
import io.trino.security.AccessControl;
import io.trino.security.AccessControlUtil;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.QueryId;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.procedure.Procedure;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class KillQueryProcedure {
    private static final MethodHandle KILL_QUERY = Reflection.methodHandle(KillQueryProcedure.class, "killQuery", String.class, String.class, ConnectorSession.class);
    private final Optional<DispatchManager> dispatchManager;
    private final AccessControl accessControl;

    @Inject
    public KillQueryProcedure(Optional<DispatchManager> dispatchManager, AccessControl accessControl) {
        this.dispatchManager = Objects.requireNonNull(dispatchManager, "dispatchManager is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
    }

    @UsedByGeneratedCode
    public void killQuery(String queryId, String message, ConnectorSession session) {
        Procedures.checkProcedureArgument((queryId != null ? 1 : 0) != 0, (String)"query_id cannot be null", (Object[])new Object[0]);
        QueryId query = KillQueryProcedure.parseQueryId(queryId);
        try {
            Preconditions.checkState((boolean)this.dispatchManager.isPresent(), (Object)"No dispatch manager is set. kill_query procedure should be executed on coordinator.");
            DispatchQuery dispatchQuery = this.dispatchManager.get().getQuery(query);
            AccessControlUtil.checkCanKillQueryOwnedBy(((FullConnectorSession)session).getSession().getIdentity(), dispatchQuery.getSession().getIdentity(), this.accessControl);
            if (dispatchQuery.isDone()) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Target query is not running: " + queryId);
            }
            dispatchQuery.fail(KillQueryProcedure.createKillQueryException(message));
            Preconditions.checkState((boolean)dispatchQuery.isDone(), (String)"Failure to fail the query: %s", (Object)query);
            if (!StandardErrorCode.ADMINISTRATIVELY_KILLED.toErrorCode().equals(dispatchQuery.getErrorCode().orElse(null))) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Target query is not running: " + queryId);
            }
        }
        catch (NoSuchElementException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Target query not found: " + queryId);
        }
    }

    public Procedure getProcedure() {
        return new Procedure("runtime", "kill_query", (List)ImmutableList.builder().add((Object)new Procedure.Argument("QUERY_ID", (Type)VarcharType.VARCHAR)).add((Object)new Procedure.Argument("MESSAGE", (Type)VarcharType.VARCHAR, false, null)).build(), KILL_QUERY.bindTo(this));
    }

    public static TrinoException createKillQueryException(String message) {
        return new TrinoException((ErrorCodeSupplier)StandardErrorCode.ADMINISTRATIVELY_KILLED, "Query killed. " + (String)(Strings.isNullOrEmpty((String)message) ? "No message provided." : "Message: " + message));
    }

    public static TrinoException createPreemptQueryException(String message) {
        return new TrinoException((ErrorCodeSupplier)StandardErrorCode.ADMINISTRATIVELY_PREEMPTED, "Query preempted. " + (String)(Strings.isNullOrEmpty((String)message) ? "No message provided." : "Message: " + message));
    }

    private static QueryId parseQueryId(String queryId) {
        try {
            return QueryId.valueOf((String)queryId);
        }
        catch (IllegalArgumentException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_PROCEDURE_ARGUMENT, (Throwable)e);
        }
    }
}

