/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cost;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import io.trino.Session;
import io.trino.cost.PlanNodeStatsEstimate;
import io.trino.cost.StatsCalculator;
import io.trino.cost.StatsProvider;
import io.trino.cost.TableStatsProvider;
import io.trino.matching.Pattern;
import io.trino.matching.pattern.TypeOfPattern;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.planner.iterative.Lookup;
import io.trino.sql.planner.plan.PlanNode;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.inject.Inject;

public class ComposableStatsCalculator
implements StatsCalculator {
    private final ListMultimap<Class<?>, Rule<?>> rulesByRootType;

    @Inject
    public ComposableStatsCalculator(List<Rule<?>> rules) {
        this.rulesByRootType = (ListMultimap)rules.stream().peek(rule -> {
            Preconditions.checkArgument((boolean)(rule.getPattern() instanceof TypeOfPattern), (Object)"Rule pattern must be TypeOfPattern");
            Class expectedClass = ((TypeOfPattern)rule.getPattern()).expectedClass();
            Preconditions.checkArgument((!expectedClass.isInterface() && !Modifier.isAbstract(expectedClass.getModifiers()) ? 1 : 0) != 0, (Object)"Rule must be registered on a concrete class");
        }).collect(Multimaps.toMultimap(rule -> ((TypeOfPattern)rule.getPattern()).expectedClass(), rule -> rule, ArrayListMultimap::create));
    }

    private Stream<Rule<?>> getCandidates(PlanNode node) {
        for (Class<?> superclass = node.getClass().getSuperclass(); superclass != null; superclass = superclass.getSuperclass()) {
            Preconditions.checkState((boolean)this.rulesByRootType.get(superclass).isEmpty(), (String)"Cannot maintain rule order because there is rule registered for %s", superclass);
        }
        return this.rulesByRootType.get(node.getClass()).stream();
    }

    @Override
    public PlanNodeStatsEstimate calculateStats(PlanNode node, StatsProvider sourceStats, Lookup lookup, Session session, TypeProvider types, TableStatsProvider tableStatsProvider) {
        Iterator ruleIterator = this.getCandidates(node).iterator();
        while (ruleIterator.hasNext()) {
            Rule rule = (Rule)ruleIterator.next();
            Optional<PlanNodeStatsEstimate> calculatedStats = ComposableStatsCalculator.calculateStats(rule, node, sourceStats, lookup, session, types, tableStatsProvider);
            if (!calculatedStats.isPresent()) continue;
            return calculatedStats.get();
        }
        return PlanNodeStatsEstimate.unknown();
    }

    private static <T extends PlanNode> Optional<PlanNodeStatsEstimate> calculateStats(Rule<T> rule, PlanNode node, StatsProvider sourceStats, Lookup lookup, Session session, TypeProvider types, TableStatsProvider tableStatsProvider) {
        PlanNode typedNode = node;
        return rule.calculate(typedNode, sourceStats, lookup, session, types, tableStatsProvider);
    }

    public static interface Rule<T extends PlanNode> {
        public Pattern<T> getPattern();

        public Optional<PlanNodeStatsEstimate> calculate(T var1, StatsProvider var2, Lookup var3, Session var4, TypeProvider var5, TableStatsProvider var6);
    }
}

