/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.DefunctConfig;
import io.airlift.configuration.LegacyConfig;
import io.airlift.units.DataSize;
import io.airlift.units.MaxDataSize;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

@DefunctConfig(value={"dynamic-filtering-max-per-driver-row-count", "experimental.dynamic-filtering-max-per-driver-row-count", "dynamic-filtering-max-per-driver-size", "experimental.dynamic-filtering-max-per-driver-size", "dynamic-filtering-range-row-limit-per-driver", "experimental.dynamic-filtering-refresh-interval", "dynamic-filtering.service-thread-count"})
public class DynamicFilterConfig {
    private boolean enableDynamicFiltering = true;
    private boolean enableCoordinatorDynamicFiltersDistribution = true;
    private boolean enableLargeDynamicFilters;
    private int smallBroadcastMaxDistinctValuesPerDriver = 200;
    private DataSize smallBroadcastMaxSizePerDriver = DataSize.of((long)20L, (DataSize.Unit)DataSize.Unit.KILOBYTE);
    private int smallBroadcastRangeRowLimitPerDriver = 400;
    private DataSize smallBroadcastMaxSizePerOperator = DataSize.of((long)200L, (DataSize.Unit)DataSize.Unit.KILOBYTE);
    private int smallPartitionedMaxDistinctValuesPerDriver = 20;
    private DataSize smallPartitionedMaxSizePerDriver = DataSize.of((long)10L, (DataSize.Unit)DataSize.Unit.KILOBYTE);
    private int smallPartitionedRangeRowLimitPerDriver = 100;
    private DataSize smallPartitionedMaxSizePerOperator = DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.KILOBYTE);
    private DataSize smallMaxSizePerFilter = DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private int largeBroadcastMaxDistinctValuesPerDriver = 5000;
    private DataSize largeBroadcastMaxSizePerDriver = DataSize.of((long)500L, (DataSize.Unit)DataSize.Unit.KILOBYTE);
    private int largeBroadcastRangeRowLimitPerDriver = 10000;
    private DataSize largeBroadcastMaxSizePerOperator = DataSize.of((long)5L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private int largePartitionedMaxDistinctValuesPerDriver = 500;
    private DataSize largePartitionedMaxSizePerDriver = DataSize.of((long)50L, (DataSize.Unit)DataSize.Unit.KILOBYTE);
    private int largePartitionedRangeRowLimitPerDriver = 1000;
    private DataSize largePartitionedMaxSizePerOperator = DataSize.of((long)500L, (DataSize.Unit)DataSize.Unit.KILOBYTE);
    private DataSize largeMaxSizePerFilter = DataSize.of((long)5L, (DataSize.Unit)DataSize.Unit.MEGABYTE);

    public boolean isEnableDynamicFiltering() {
        return this.enableDynamicFiltering;
    }

    @Config(value="enable-dynamic-filtering")
    @LegacyConfig(value={"experimental.enable-dynamic-filtering"})
    public DynamicFilterConfig setEnableDynamicFiltering(boolean enableDynamicFiltering) {
        this.enableDynamicFiltering = enableDynamicFiltering;
        return this;
    }

    public boolean isEnableCoordinatorDynamicFiltersDistribution() {
        return this.enableCoordinatorDynamicFiltersDistribution;
    }

    @Config(value="enable-coordinator-dynamic-filters-distribution")
    @ConfigDescription(value="Enable distribution of dynamic filters from coordinator to all workers")
    public DynamicFilterConfig setEnableCoordinatorDynamicFiltersDistribution(boolean enableCoordinatorDynamicFiltersDistribution) {
        this.enableCoordinatorDynamicFiltersDistribution = enableCoordinatorDynamicFiltersDistribution;
        return this;
    }

    public boolean isEnableLargeDynamicFilters() {
        return this.enableLargeDynamicFilters;
    }

    @Config(value="enable-large-dynamic-filters")
    public DynamicFilterConfig setEnableLargeDynamicFilters(boolean enableLargeDynamicFilters) {
        this.enableLargeDynamicFilters = enableLargeDynamicFilters;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getSmallBroadcastMaxDistinctValuesPerDriver() {
        return this.smallBroadcastMaxDistinctValuesPerDriver;
    }

    @Config(value="dynamic-filtering.small-broadcast.max-distinct-values-per-driver")
    public DynamicFilterConfig setSmallBroadcastMaxDistinctValuesPerDriver(int smallBroadcastMaxDistinctValuesPerDriver) {
        this.smallBroadcastMaxDistinctValuesPerDriver = smallBroadcastMaxDistinctValuesPerDriver;
        return this;
    }

    @MaxDataSize(value="1MB")
    public @MaxDataSize(value="1MB") DataSize getSmallBroadcastMaxSizePerDriver() {
        return this.smallBroadcastMaxSizePerDriver;
    }

    @Config(value="dynamic-filtering.small-broadcast.max-size-per-driver")
    public DynamicFilterConfig setSmallBroadcastMaxSizePerDriver(DataSize smallBroadcastMaxSizePerDriver) {
        this.smallBroadcastMaxSizePerDriver = smallBroadcastMaxSizePerDriver;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getSmallBroadcastRangeRowLimitPerDriver() {
        return this.smallBroadcastRangeRowLimitPerDriver;
    }

    @Config(value="dynamic-filtering.small-broadcast.range-row-limit-per-driver")
    public DynamicFilterConfig setSmallBroadcastRangeRowLimitPerDriver(int smallBroadcastRangeRowLimitPerDriver) {
        this.smallBroadcastRangeRowLimitPerDriver = smallBroadcastRangeRowLimitPerDriver;
        return this;
    }

    @MaxDataSize(value="10MB")
    public @MaxDataSize(value="10MB") DataSize getSmallBroadcastMaxSizePerOperator() {
        return this.smallBroadcastMaxSizePerOperator;
    }

    @Config(value="dynamic-filtering.small-broadcast.max-size-per-operator")
    public DynamicFilterConfig setSmallBroadcastMaxSizePerOperator(DataSize smallBroadcastMaxSizePerOperator) {
        this.smallBroadcastMaxSizePerOperator = smallBroadcastMaxSizePerOperator;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getSmallPartitionedMaxDistinctValuesPerDriver() {
        return this.smallPartitionedMaxDistinctValuesPerDriver;
    }

    @Config(value="dynamic-filtering.small-partitioned.max-distinct-values-per-driver")
    public DynamicFilterConfig setSmallPartitionedMaxDistinctValuesPerDriver(int smallPartitionedMaxDistinctValuesPerDriver) {
        this.smallPartitionedMaxDistinctValuesPerDriver = smallPartitionedMaxDistinctValuesPerDriver;
        return this;
    }

    @MaxDataSize(value="1MB")
    public @MaxDataSize(value="1MB") DataSize getSmallPartitionedMaxSizePerDriver() {
        return this.smallPartitionedMaxSizePerDriver;
    }

    @Config(value="dynamic-filtering.small-partitioned.max-size-per-driver")
    public DynamicFilterConfig setSmallPartitionedMaxSizePerDriver(DataSize smallPartitionedMaxSizePerDriver) {
        this.smallPartitionedMaxSizePerDriver = smallPartitionedMaxSizePerDriver;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getSmallPartitionedRangeRowLimitPerDriver() {
        return this.smallPartitionedRangeRowLimitPerDriver;
    }

    @Config(value="dynamic-filtering.small-partitioned.range-row-limit-per-driver")
    public DynamicFilterConfig setSmallPartitionedRangeRowLimitPerDriver(int smallPartitionedRangeRowLimitPerDriver) {
        this.smallPartitionedRangeRowLimitPerDriver = smallPartitionedRangeRowLimitPerDriver;
        return this;
    }

    @MaxDataSize(value="10MB")
    public @MaxDataSize(value="10MB") DataSize getSmallPartitionedMaxSizePerOperator() {
        return this.smallPartitionedMaxSizePerOperator;
    }

    @Config(value="dynamic-filtering.small-partitioned.max-size-per-operator")
    public DynamicFilterConfig setSmallPartitionedMaxSizePerOperator(DataSize smallPartitionedMaxSizePerOperator) {
        this.smallPartitionedMaxSizePerOperator = smallPartitionedMaxSizePerOperator;
        return this;
    }

    @NotNull
    @MaxDataSize(value="10MB")
    public @NotNull @MaxDataSize(value="10MB") DataSize getSmallMaxSizePerFilter() {
        return this.smallMaxSizePerFilter;
    }

    @Config(value="dynamic-filtering.small.max-size-per-filter")
    public DynamicFilterConfig setSmallMaxSizePerFilter(DataSize smallMaxSizePerFilter) {
        this.smallMaxSizePerFilter = smallMaxSizePerFilter;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getLargeBroadcastMaxDistinctValuesPerDriver() {
        return this.largeBroadcastMaxDistinctValuesPerDriver;
    }

    @Config(value="dynamic-filtering.large-broadcast.max-distinct-values-per-driver")
    public DynamicFilterConfig setLargeBroadcastMaxDistinctValuesPerDriver(int largeBroadcastMaxDistinctValuesPerDriver) {
        this.largeBroadcastMaxDistinctValuesPerDriver = largeBroadcastMaxDistinctValuesPerDriver;
        return this;
    }

    @MaxDataSize(value="50MB")
    public @MaxDataSize(value="50MB") DataSize getLargeBroadcastMaxSizePerDriver() {
        return this.largeBroadcastMaxSizePerDriver;
    }

    @Config(value="dynamic-filtering.large-broadcast.max-size-per-driver")
    public DynamicFilterConfig setLargeBroadcastMaxSizePerDriver(DataSize largeBroadcastMaxSizePerDriver) {
        this.largeBroadcastMaxSizePerDriver = largeBroadcastMaxSizePerDriver;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getLargeBroadcastRangeRowLimitPerDriver() {
        return this.largeBroadcastRangeRowLimitPerDriver;
    }

    @Config(value="dynamic-filtering.large-broadcast.range-row-limit-per-driver")
    public DynamicFilterConfig setLargeBroadcastRangeRowLimitPerDriver(int largeBroadcastRangeRowLimitPerDriver) {
        this.largeBroadcastRangeRowLimitPerDriver = largeBroadcastRangeRowLimitPerDriver;
        return this;
    }

    @MaxDataSize(value="100MB")
    public @MaxDataSize(value="100MB") DataSize getLargeBroadcastMaxSizePerOperator() {
        return this.largeBroadcastMaxSizePerOperator;
    }

    @Config(value="dynamic-filtering.large-broadcast.max-size-per-operator")
    public DynamicFilterConfig setLargeBroadcastMaxSizePerOperator(DataSize largeBroadcastMaxSizePerOperator) {
        this.largeBroadcastMaxSizePerOperator = largeBroadcastMaxSizePerOperator;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getLargePartitionedMaxDistinctValuesPerDriver() {
        return this.largePartitionedMaxDistinctValuesPerDriver;
    }

    @Config(value="dynamic-filtering.large-partitioned.max-distinct-values-per-driver")
    public DynamicFilterConfig setLargePartitionedMaxDistinctValuesPerDriver(int largePartitionedMaxDistinctValuesPerDriver) {
        this.largePartitionedMaxDistinctValuesPerDriver = largePartitionedMaxDistinctValuesPerDriver;
        return this;
    }

    @MaxDataSize(value="5MB")
    public @MaxDataSize(value="5MB") DataSize getLargePartitionedMaxSizePerDriver() {
        return this.largePartitionedMaxSizePerDriver;
    }

    @Config(value="dynamic-filtering.large-partitioned.max-size-per-driver")
    public DynamicFilterConfig setLargePartitionedMaxSizePerDriver(DataSize largePartitionedMaxSizePerDriver) {
        this.largePartitionedMaxSizePerDriver = largePartitionedMaxSizePerDriver;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getLargePartitionedRangeRowLimitPerDriver() {
        return this.largePartitionedRangeRowLimitPerDriver;
    }

    @Config(value="dynamic-filtering.large-partitioned.range-row-limit-per-driver")
    public DynamicFilterConfig setLargePartitionedRangeRowLimitPerDriver(int largePartitionedRangeRowLimitPerDriver) {
        this.largePartitionedRangeRowLimitPerDriver = largePartitionedRangeRowLimitPerDriver;
        return this;
    }

    @MaxDataSize(value="50MB")
    public @MaxDataSize(value="50MB") DataSize getLargePartitionedMaxSizePerOperator() {
        return this.largePartitionedMaxSizePerOperator;
    }

    @Config(value="dynamic-filtering.large-partitioned.max-size-per-operator")
    public DynamicFilterConfig setLargePartitionedMaxSizePerOperator(DataSize largePartitionedMaxSizePerOperator) {
        this.largePartitionedMaxSizePerOperator = largePartitionedMaxSizePerOperator;
        return this;
    }

    @NotNull
    @MaxDataSize(value="10MB")
    public @NotNull @MaxDataSize(value="10MB") DataSize getLargeMaxSizePerFilter() {
        return this.largeMaxSizePerFilter;
    }

    @Config(value="dynamic-filtering.large.max-size-per-filter")
    public DynamicFilterConfig setLargeMaxSizePerFilter(DataSize largeMaxSizePerFilter) {
        this.largeMaxSizePerFilter = largeMaxSizePerFilter;
        return this;
    }
}

