/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.SetThreadName;
import io.airlift.units.Duration;
import io.trino.SystemSessionProperties;
import io.trino.event.SplitMonitor;
import io.trino.execution.ScheduledSplit;
import io.trino.execution.SplitAssignment;
import io.trino.execution.SplitRunner;
import io.trino.execution.StateMachine;
import io.trino.execution.TaskId;
import io.trino.execution.TaskStateMachine;
import io.trino.execution.buffer.BufferState;
import io.trino.execution.buffer.OutputBuffer;
import io.trino.execution.executor.TaskExecutor;
import io.trino.execution.executor.TaskHandle;
import io.trino.operator.Driver;
import io.trino.operator.DriverContext;
import io.trino.operator.DriverFactory;
import io.trino.operator.DriverStats;
import io.trino.operator.PipelineContext;
import io.trino.operator.TaskContext;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.SplitWeight;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.sql.planner.LocalExecutionPlanner;
import io.trino.sql.planner.plan.PlanNodeId;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.NotThreadSafe;

public class SqlTaskExecution {
    private final TaskId taskId;
    private final TaskStateMachine taskStateMachine;
    private final TaskContext taskContext;
    private final OutputBuffer outputBuffer;
    private final TaskHandle taskHandle;
    private final TaskExecutor taskExecutor;
    private final Executor notificationExecutor;
    private final SplitMonitor splitMonitor;
    private final Map<PlanNodeId, DriverSplitRunnerFactory> driverRunnerFactoriesWithSplitLifeCycle;
    private final List<DriverSplitRunnerFactory> driverRunnerFactoriesWithTaskLifeCycle;
    private final Map<PlanNodeId, DriverSplitRunnerFactory> driverRunnerFactoriesWithRemoteSource;
    @GuardedBy(value="this")
    private long maxAcknowledgedSplit = Long.MIN_VALUE;
    @GuardedBy(value="this")
    private final List<PlanNodeId> sourceStartOrder;
    @GuardedBy(value="this")
    private int schedulingPlanNodeOrdinal;
    @GuardedBy(value="this")
    private final Map<PlanNodeId, PendingSplitsForPlanNode> pendingSplitsByPlanNode;
    private final AtomicLong remainingSplitRunners = new AtomicLong();

    public SqlTaskExecution(TaskStateMachine taskStateMachine, TaskContext taskContext, OutputBuffer outputBuffer, LocalExecutionPlanner.LocalExecutionPlan localExecutionPlan, TaskExecutor taskExecutor, SplitMonitor splitMonitor, Executor notificationExecutor) {
        this.taskStateMachine = Objects.requireNonNull(taskStateMachine, "taskStateMachine is null");
        this.taskId = taskStateMachine.getTaskId();
        this.taskContext = Objects.requireNonNull(taskContext, "taskContext is null");
        this.outputBuffer = Objects.requireNonNull(outputBuffer, "outputBuffer is null");
        this.taskExecutor = Objects.requireNonNull(taskExecutor, "taskExecutor is null");
        this.notificationExecutor = Objects.requireNonNull(notificationExecutor, "notificationExecutor is null");
        this.splitMonitor = Objects.requireNonNull(splitMonitor, "splitMonitor is null");
        try (SetThreadName ignored = new SetThreadName("Task-%s", new Object[]{this.taskId});){
            ImmutableSet partitionedSources = ImmutableSet.copyOf(localExecutionPlan.getPartitionedSourceOrder());
            ImmutableMap.Builder driverRunnerFactoriesWithSplitLifeCycle = ImmutableMap.builder();
            ImmutableList.Builder driverRunnerFactoriesWithTaskLifeCycle = ImmutableList.builder();
            ImmutableMap.Builder driverRunnerFactoriesWithRemoteSource = ImmutableMap.builder();
            for (DriverFactory driverFactory : localExecutionPlan.getDriverFactories()) {
                Optional<PlanNodeId> sourceId = driverFactory.getSourceId();
                if (sourceId.isPresent() && partitionedSources.contains(sourceId.get())) {
                    driverRunnerFactoriesWithSplitLifeCycle.put((Object)sourceId.get(), (Object)new DriverSplitRunnerFactory(driverFactory, true));
                    continue;
                }
                DriverSplitRunnerFactory runnerFactory = new DriverSplitRunnerFactory(driverFactory, false);
                sourceId.ifPresent(planNodeId -> driverRunnerFactoriesWithRemoteSource.put(planNodeId, (Object)runnerFactory));
                driverRunnerFactoriesWithTaskLifeCycle.add((Object)runnerFactory);
            }
            this.driverRunnerFactoriesWithSplitLifeCycle = driverRunnerFactoriesWithSplitLifeCycle.buildOrThrow();
            this.driverRunnerFactoriesWithTaskLifeCycle = driverRunnerFactoriesWithTaskLifeCycle.build();
            this.driverRunnerFactoriesWithRemoteSource = driverRunnerFactoriesWithRemoteSource.buildOrThrow();
            this.pendingSplitsByPlanNode = (Map)this.driverRunnerFactoriesWithSplitLifeCycle.keySet().stream().collect(ImmutableMap.toImmutableMap(Function.identity(), ignore -> new PendingSplitsForPlanNode()));
            this.sourceStartOrder = localExecutionPlan.getPartitionedSourceOrder();
            Preconditions.checkArgument((boolean)this.driverRunnerFactoriesWithSplitLifeCycle.keySet().equals(partitionedSources), (Object)"Fragment is partitioned, but not all partitioned drivers were found");
            this.taskHandle = !taskStateMachine.getState().isDone() ? SqlTaskExecution.createTaskHandle(taskStateMachine, taskContext, outputBuffer, localExecutionPlan, taskExecutor) : null;
            outputBuffer.addStateChangeListener(new CheckTaskCompletionOnBufferFinish(this));
        }
    }

    public void start() {
        try (SetThreadName ignored = new SetThreadName("Task-%s", new Object[]{this.getTaskId()});){
            this.scheduleDriversForTaskLifeCycle();
        }
    }

    private static TaskHandle createTaskHandle(TaskStateMachine taskStateMachine, TaskContext taskContext, OutputBuffer outputBuffer, LocalExecutionPlanner.LocalExecutionPlan localExecutionPlan, TaskExecutor taskExecutor) {
        TaskHandle taskHandle = taskExecutor.addTask(taskStateMachine.getTaskId(), outputBuffer::getUtilization, SystemSessionProperties.getInitialSplitsPerNode(taskContext.getSession()), SystemSessionProperties.getSplitConcurrencyAdjustmentInterval(taskContext.getSession()), SystemSessionProperties.getMaxDriversPerTask(taskContext.getSession()));
        taskStateMachine.addStateChangeListener(state -> {
            if (state.isDone()) {
                taskExecutor.removeTask(taskHandle);
                for (DriverFactory factory : localExecutionPlan.getDriverFactories()) {
                    factory.noMoreDrivers();
                }
            }
        });
        return taskHandle;
    }

    public TaskId getTaskId() {
        return this.taskId;
    }

    public TaskContext getTaskContext() {
        return this.taskContext;
    }

    public void addSplitAssignments(List<SplitAssignment> splitAssignments) {
        Objects.requireNonNull(splitAssignments, "splitAssignments is null");
        Preconditions.checkState((!Thread.holdsLock(this) ? 1 : 0) != 0, (String)"Cannot add split assignments while holding a lock on the %s", (Object)this.getClass().getSimpleName());
        try (SetThreadName ignored = new SetThreadName("Task-%s", new Object[]{this.taskId});){
            Set<PlanNodeId> updatedUnpartitionedSources = this.updateSplitAssignments(splitAssignments);
            for (PlanNodeId planNodeId : updatedUnpartitionedSources) {
                DriverSplitRunnerFactory factory = this.driverRunnerFactoriesWithRemoteSource.get(planNodeId);
                factory.scheduleSplits();
            }
            this.checkTaskCompletion();
        }
    }

    private synchronized Set<PlanNodeId> updateSplitAssignments(List<SplitAssignment> splitAssignments) {
        ImmutableSet.Builder updatedUnpartitionedSources = ImmutableSet.builder();
        long currentMaxAcknowledgedSplit = this.maxAcknowledgedSplit;
        splitAssignments = splitAssignments.stream().map(assignment -> new SplitAssignment(assignment.getPlanNodeId(), (Set)assignment.getSplits().stream().filter(scheduledSplit -> scheduledSplit.getSequenceId() > currentMaxAcknowledgedSplit).collect(ImmutableSet.toImmutableSet()), assignment.isNoMoreSplits())).filter(assignment -> !assignment.getSplits().isEmpty() || assignment.isNoMoreSplits()).collect(Collectors.toList());
        for (SplitAssignment assignment2 : splitAssignments) {
            if (this.driverRunnerFactoriesWithSplitLifeCycle.containsKey(assignment2.getPlanNodeId())) {
                this.schedulePartitionedSource(assignment2);
                continue;
            }
            DriverSplitRunnerFactory factory = this.driverRunnerFactoriesWithRemoteSource.get(assignment2.getPlanNodeId());
            factory.enqueueSplits(assignment2.getSplits(), assignment2.isNoMoreSplits());
            updatedUnpartitionedSources.add((Object)assignment2.getPlanNodeId());
        }
        this.maxAcknowledgedSplit = splitAssignments.stream().flatMap(source -> source.getSplits().stream()).mapToLong(ScheduledSplit::getSequenceId).max().orElse(this.maxAcknowledgedSplit);
        return updatedUnpartitionedSources.build();
    }

    @GuardedBy(value="this")
    private void mergeIntoPendingSplits(PlanNodeId planNodeId, Set<ScheduledSplit> scheduledSplits, boolean noMoreSplits) {
        this.checkHoldsLock();
        DriverSplitRunnerFactory partitionedDriverFactory = this.driverRunnerFactoriesWithSplitLifeCycle.get(planNodeId);
        PendingSplitsForPlanNode pendingSplitsForPlanNode = this.pendingSplitsByPlanNode.get(planNodeId);
        partitionedDriverFactory.splitsAdded(scheduledSplits.size(), SplitWeight.rawValueSum(scheduledSplits, scheduledSplit -> scheduledSplit.getSplit().getSplitWeight()));
        for (ScheduledSplit scheduledSplit2 : scheduledSplits) {
            pendingSplitsForPlanNode.addSplit(scheduledSplit2);
        }
        if (noMoreSplits) {
            pendingSplitsForPlanNode.setNoMoreSplits();
        }
    }

    private synchronized void schedulePartitionedSource(SplitAssignment splitAssignmentUpdate) {
        this.mergeIntoPendingSplits(splitAssignmentUpdate.getPlanNodeId(), splitAssignmentUpdate.getSplits(), splitAssignmentUpdate.isNoMoreSplits());
        while (this.schedulingPlanNodeOrdinal < this.sourceStartOrder.size()) {
            PlanNodeId schedulingPlanNode = this.sourceStartOrder.get(this.schedulingPlanNodeOrdinal);
            DriverSplitRunnerFactory partitionedDriverRunnerFactory = this.driverRunnerFactoriesWithSplitLifeCycle.get(schedulingPlanNode);
            PendingSplitsForPlanNode pendingSplits = this.pendingSplitsByPlanNode.get(schedulingPlanNode);
            ImmutableList.Builder runners = ImmutableList.builder();
            for (ScheduledSplit scheduledSplit : pendingSplits.removeAllSplits()) {
                runners.add((Object)partitionedDriverRunnerFactory.createDriverRunner(scheduledSplit));
            }
            this.enqueueDriverSplitRunner(false, (List<DriverSplitRunner>)runners.build());
            if (pendingSplits.getState() != SplitsState.NO_MORE_SPLITS) break;
            partitionedDriverRunnerFactory.noMoreDriverRunner();
            pendingSplits.markAsCleanedUp();
            ++this.schedulingPlanNodeOrdinal;
        }
    }

    private void scheduleDriversForTaskLifeCycle() {
        ArrayList<DriverSplitRunner> runners = new ArrayList<DriverSplitRunner>();
        for (DriverSplitRunnerFactory driverRunnerFactory : this.driverRunnerFactoriesWithTaskLifeCycle) {
            for (int i = 0; i < driverRunnerFactory.getDriverInstances().orElse(1); ++i) {
                runners.add(driverRunnerFactory.createDriverRunner(null));
            }
        }
        this.enqueueDriverSplitRunner(true, runners);
        for (DriverSplitRunnerFactory driverRunnerFactory : this.driverRunnerFactoriesWithTaskLifeCycle) {
            driverRunnerFactory.noMoreDriverRunner();
            Verify.verify((boolean)driverRunnerFactory.isNoMoreDriverRunner());
        }
        this.checkTaskCompletion();
    }

    private synchronized void enqueueDriverSplitRunner(boolean forceRunSplit, List<DriverSplitRunner> runners) {
        List<ListenableFuture<Void>> finishedFutures = this.taskExecutor.enqueueSplits(this.taskHandle, forceRunSplit, runners);
        Preconditions.checkState((finishedFutures.size() == runners.size() ? 1 : 0) != 0, (String)"Expected %s futures but got %s", (int)runners.size(), (int)finishedFutures.size());
        this.remainingSplitRunners.addAndGet(runners.size());
        for (int i = 0; i < finishedFutures.size(); ++i) {
            ListenableFuture<Void> finishedFuture = finishedFutures.get(i);
            final DriverSplitRunner splitRunner = runners.get(i);
            Futures.addCallback(finishedFuture, (FutureCallback)new FutureCallback<Object>(){

                public void onSuccess(Object result) {
                    try (SetThreadName ignored = new SetThreadName("Task-%s", new Object[]{SqlTaskExecution.this.taskId});){
                        if (SqlTaskExecution.this.remainingSplitRunners.decrementAndGet() == 0L) {
                            SqlTaskExecution.this.checkTaskCompletion();
                        }
                        SqlTaskExecution.this.splitMonitor.splitCompletedEvent(SqlTaskExecution.this.taskId, this.getDriverStats());
                    }
                }

                public void onFailure(Throwable cause) {
                    try (SetThreadName ignored = new SetThreadName("Task-%s", new Object[]{SqlTaskExecution.this.taskId});){
                        SqlTaskExecution.this.taskStateMachine.failed(cause);
                        if (SqlTaskExecution.this.remainingSplitRunners.decrementAndGet() == 0L) {
                            SqlTaskExecution.this.checkTaskCompletion();
                        }
                        SqlTaskExecution.this.splitMonitor.splitFailedEvent(SqlTaskExecution.this.taskId, this.getDriverStats(), cause);
                    }
                }

                private DriverStats getDriverStats() {
                    DriverContext driverContext = splitRunner.getDriverContext();
                    DriverStats driverStats = driverContext != null ? driverContext.getDriverStats() : new DriverStats();
                    return driverStats;
                }
            }, (Executor)this.notificationExecutor);
        }
    }

    public synchronized Set<PlanNodeId> getNoMoreSplits() {
        ImmutableSet.Builder noMoreSplits = ImmutableSet.builder();
        for (Map.Entry<PlanNodeId, DriverSplitRunnerFactory> entry : this.driverRunnerFactoriesWithSplitLifeCycle.entrySet()) {
            if (!entry.getValue().isNoMoreDriverRunner()) continue;
            noMoreSplits.add((Object)entry.getKey());
        }
        for (Map.Entry<PlanNodeId, DriverSplitRunnerFactory> entry : this.driverRunnerFactoriesWithRemoteSource.entrySet()) {
            if (!entry.getValue().isNoMoreSplits()) continue;
            noMoreSplits.add((Object)entry.getKey());
        }
        return noMoreSplits.build();
    }

    private synchronized void checkTaskCompletion() {
        if (this.taskStateMachine.getState().isDone()) {
            return;
        }
        for (DriverSplitRunnerFactory driverSplitRunnerFactory : Iterables.concat(this.driverRunnerFactoriesWithTaskLifeCycle, this.driverRunnerFactoriesWithSplitLifeCycle.values())) {
            if (driverSplitRunnerFactory.isNoMoreDrivers()) continue;
            return;
        }
        if (this.remainingSplitRunners.get() != 0L) {
            return;
        }
        this.outputBuffer.setNoMorePages();
        BufferState bufferState = this.outputBuffer.getState();
        if (!bufferState.isTerminal()) {
            this.taskStateMachine.transitionToFlushing();
            return;
        }
        if (bufferState == BufferState.FINISHED) {
            this.taskStateMachine.finished();
            return;
        }
        if (bufferState == BufferState.FAILED) {
            Throwable failureCause = this.outputBuffer.getFailureCause().orElseGet(() -> new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Output buffer is failed but the failure cause is missing"));
            this.taskStateMachine.failed(failureCause);
            return;
        }
        this.taskStateMachine.failed(new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Unexpected buffer state: " + bufferState));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("taskId", (Object)this.taskId).add("remainingSplitRunners", this.remainingSplitRunners.get()).toString();
    }

    private void checkHoldsLock() {
        if (!Thread.holdsLock(this)) {
            throw new IllegalStateException(String.format("Thread must hold a lock on the %s", this.getClass().getSimpleName()));
        }
    }

    private class DriverSplitRunnerFactory {
        private final DriverFactory driverFactory;
        private final PipelineContext pipelineContext;
        private final AtomicInteger pendingCreations = new AtomicInteger();
        private final AtomicBoolean noMoreDriverRunner = new AtomicBoolean();
        private final List<WeakReference<Driver>> driverReferences = new CopyOnWriteArrayList<WeakReference<Driver>>();
        private final Queue<ScheduledSplit> queuedSplits = new ConcurrentLinkedQueue<ScheduledSplit>();
        private final AtomicLong inFlightSplits = new AtomicLong();
        private final AtomicBoolean noMoreSplits = new AtomicBoolean();

        private DriverSplitRunnerFactory(DriverFactory driverFactory, boolean partitioned) {
            this.driverFactory = driverFactory;
            this.pipelineContext = SqlTaskExecution.this.taskContext.addPipelineContext(driverFactory.getPipelineId(), driverFactory.isInputDriver(), driverFactory.isOutputDriver(), partitioned);
        }

        public DriverSplitRunner createDriverRunner(@Nullable ScheduledSplit partitionedSplit) {
            Preconditions.checkState((!this.noMoreDriverRunner.get() ? 1 : 0) != 0, (Object)"noMoreDriverRunner is set");
            this.pendingCreations.incrementAndGet();
            long splitWeight = partitionedSplit == null ? 0L : partitionedSplit.getSplit().getSplitWeight().getRawValue();
            DriverContext driverContext = this.pipelineContext.addDriverContext(splitWeight);
            return new DriverSplitRunner(this, driverContext, partitionedSplit);
        }

        public Driver createDriver(DriverContext driverContext, @Nullable ScheduledSplit partitionedSplit) {
            Driver driver = this.driverFactory.createDriver(driverContext);
            try {
                if (partitionedSplit != null) {
                    driver.updateSplitAssignment(new SplitAssignment(partitionedSplit.getPlanNodeId(), (Set<ScheduledSplit>)ImmutableSet.of((Object)partitionedSplit), true));
                }
                if (this.pendingCreations.decrementAndGet() == 0) {
                    this.closeDriverFactoryIfFullyCreated();
                }
                if (this.driverFactory.getSourceId().isPresent() && partitionedSplit == null) {
                    this.driverReferences.add(new WeakReference<Driver>(driver));
                    this.scheduleSplits();
                }
                return driver;
            }
            catch (Throwable failure) {
                block7: {
                    try {
                        driver.close();
                    }
                    catch (Throwable closeFailure) {
                        if (failure == closeFailure) break block7;
                        failure.addSuppressed(closeFailure);
                    }
                }
                throw failure;
            }
        }

        public void enqueueSplits(Set<ScheduledSplit> splits, boolean noMoreSplits) {
            Verify.verify((boolean)this.driverFactory.getSourceId().isPresent(), (String)"not a source driver", (Object[])new Object[0]);
            Verify.verify((!this.noMoreSplits.get() || splits.isEmpty() ? 1 : 0) != 0, (String)"cannot add splits after noMoreSplits is set", (Object[])new Object[0]);
            this.queuedSplits.addAll(splits);
            Verify.verify((!this.noMoreSplits.get() || noMoreSplits ? 1 : 0) != 0, (String)"cannot unset noMoreSplits", (Object[])new Object[0]);
            if (noMoreSplits) {
                this.noMoreSplits.set(true);
            }
        }

        public void scheduleSplits() {
            if (this.driverReferences.isEmpty()) {
                return;
            }
            PlanNodeId sourceId = this.driverFactory.getSourceId().orElseThrow();
            while (!this.queuedSplits.isEmpty()) {
                int activeDriversCount = 0;
                for (WeakReference<Driver> driverReference : this.driverReferences) {
                    Driver driver = (Driver)driverReference.get();
                    if (driver == null) continue;
                    ++activeDriversCount;
                    this.inFlightSplits.incrementAndGet();
                    ScheduledSplit split = this.queuedSplits.poll();
                    if (split == null) {
                        this.inFlightSplits.decrementAndGet();
                        break;
                    }
                    driver.updateSplitAssignment(new SplitAssignment(sourceId, (Set<ScheduledSplit>)ImmutableSet.of((Object)split), false));
                    this.inFlightSplits.decrementAndGet();
                }
                if (activeDriversCount != 0) continue;
                break;
            }
            if (this.noMoreSplits.get() && this.queuedSplits.isEmpty() && this.inFlightSplits.get() == 0L) {
                for (WeakReference<Driver> driverReference : this.driverReferences) {
                    Driver driver = (Driver)driverReference.get();
                    if (driver == null) continue;
                    driver.updateSplitAssignment(new SplitAssignment(sourceId, (Set<ScheduledSplit>)ImmutableSet.of(), true));
                }
            }
        }

        public boolean isNoMoreSplits() {
            return this.noMoreSplits.get();
        }

        public void noMoreDriverRunner() {
            this.noMoreDriverRunner.set(true);
            this.closeDriverFactoryIfFullyCreated();
        }

        public boolean isNoMoreDriverRunner() {
            return this.noMoreDriverRunner.get();
        }

        public void closeDriverFactoryIfFullyCreated() {
            if (this.driverFactory.isNoMoreDrivers()) {
                return;
            }
            if (this.isNoMoreDriverRunner() && this.pendingCreations.get() == 0) {
                this.driverFactory.noMoreDrivers();
            }
        }

        public boolean isNoMoreDrivers() {
            return this.driverFactory.isNoMoreDrivers();
        }

        public OptionalInt getDriverInstances() {
            return this.driverFactory.getDriverInstances();
        }

        public void splitsAdded(int count, long weightSum) {
            this.pipelineContext.splitsAdded(count, weightSum);
        }
    }

    private static final class CheckTaskCompletionOnBufferFinish
    implements StateMachine.StateChangeListener<BufferState> {
        private final WeakReference<SqlTaskExecution> sqlTaskExecutionReference;

        public CheckTaskCompletionOnBufferFinish(SqlTaskExecution sqlTaskExecution) {
            this.sqlTaskExecutionReference = new WeakReference<SqlTaskExecution>(sqlTaskExecution);
        }

        @Override
        public void stateChanged(BufferState newState) {
            SqlTaskExecution sqlTaskExecution;
            if (newState.isTerminal() && (sqlTaskExecution = (SqlTaskExecution)this.sqlTaskExecutionReference.get()) != null) {
                sqlTaskExecution.checkTaskCompletion();
            }
        }
    }

    @NotThreadSafe
    private static class PendingSplitsForPlanNode {
        private Set<ScheduledSplit> splits = new HashSet<ScheduledSplit>();
        private SplitsState state = SplitsState.ADDING_SPLITS;
        private boolean noMoreSplits;

        private PendingSplitsForPlanNode() {
        }

        public void setNoMoreSplits() {
            if (this.noMoreSplits) {
                return;
            }
            this.noMoreSplits = true;
            if (this.state == SplitsState.ADDING_SPLITS) {
                this.state = SplitsState.NO_MORE_SPLITS;
            }
        }

        public SplitsState getState() {
            return this.state;
        }

        public void addSplit(ScheduledSplit scheduledSplit) {
            Preconditions.checkState((this.state == SplitsState.ADDING_SPLITS ? 1 : 0) != 0);
            this.splits.add(scheduledSplit);
        }

        public Set<ScheduledSplit> removeAllSplits() {
            Preconditions.checkState((this.state == SplitsState.ADDING_SPLITS || this.state == SplitsState.NO_MORE_SPLITS ? 1 : 0) != 0);
            Set<ScheduledSplit> result = this.splits;
            this.splits = new HashSet<ScheduledSplit>();
            return result;
        }

        public void markAsCleanedUp() {
            Preconditions.checkState((boolean)this.splits.isEmpty());
            Preconditions.checkState((this.state == SplitsState.NO_MORE_SPLITS ? 1 : 0) != 0);
            this.state = SplitsState.FINISHED;
        }
    }

    private static class DriverSplitRunner
    implements SplitRunner {
        private final DriverSplitRunnerFactory driverSplitRunnerFactory;
        private final DriverContext driverContext;
        @GuardedBy(value="this")
        private boolean closed;
        @Nullable
        private final ScheduledSplit partitionedSplit;
        @GuardedBy(value="this")
        private Driver driver;

        private DriverSplitRunner(DriverSplitRunnerFactory driverSplitRunnerFactory, DriverContext driverContext, @Nullable ScheduledSplit partitionedSplit) {
            this.driverSplitRunnerFactory = Objects.requireNonNull(driverSplitRunnerFactory, "driverSplitRunnerFactory is null");
            this.driverContext = Objects.requireNonNull(driverContext, "driverContext is null");
            this.partitionedSplit = partitionedSplit;
        }

        public synchronized DriverContext getDriverContext() {
            if (this.driver == null) {
                return null;
            }
            return this.driver.getDriverContext();
        }

        @Override
        public synchronized boolean isFinished() {
            if (this.closed) {
                return true;
            }
            return this.driver != null && this.driver.isFinished();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ListenableFuture<Void> processFor(Duration duration) {
            Driver driver;
            DriverSplitRunner driverSplitRunner = this;
            synchronized (driverSplitRunner) {
                if (this.closed) {
                    return Futures.immediateVoidFuture();
                }
                if (this.driver == null) {
                    this.driver = this.driverSplitRunnerFactory.createDriver(this.driverContext, this.partitionedSplit);
                }
                driver = this.driver;
            }
            return driver.processForDuration(duration);
        }

        @Override
        public String getInfo() {
            return this.partitionedSplit == null ? "" : this.partitionedSplit.getSplit().getInfo().toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Driver driver;
            DriverSplitRunner driverSplitRunner = this;
            synchronized (driverSplitRunner) {
                this.closed = true;
                driver = this.driver;
            }
            if (driver != null) {
                driver.close();
            }
        }
    }

    static enum SplitsState {
        ADDING_SPLITS,
        NO_MORE_SPLITS,
        FINISHED;

    }
}

