/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Preconditions;
import io.airlift.slice.SizeOf;
import io.trino.execution.StageId;
import io.trino.spi.QueryId;
import java.util.List;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class TaskId {
    private static final int INSTANCE_SIZE = Math.toIntExact(ClassLayout.parseClass(TaskId.class).instanceSize());
    private final String fullId;

    @JsonCreator
    public static TaskId valueOf(String taskId) {
        return new TaskId(taskId);
    }

    public TaskId(StageId stageId, int partitionId, int attemptId) {
        Objects.requireNonNull(stageId, "stageId is null");
        Preconditions.checkArgument((partitionId >= 0 ? 1 : 0) != 0, (Object)"partitionId is negative");
        Preconditions.checkArgument((attemptId >= 0 ? 1 : 0) != 0, (Object)"attemptId is negative");
        this.fullId = stageId + "." + partitionId + "." + attemptId;
    }

    private TaskId(String fullId) {
        this.fullId = Objects.requireNonNull(fullId, "fullId is null");
    }

    public QueryId getQueryId() {
        return new QueryId((String)QueryId.parseDottedId((String)this.fullId, (int)4, (String)"taskId").get(0));
    }

    public StageId getStageId() {
        List ids = QueryId.parseDottedId((String)this.fullId, (int)4, (String)"taskId");
        return StageId.valueOf(ids.subList(0, 2));
    }

    public int getPartitionId() {
        return Integer.parseInt((String)QueryId.parseDottedId((String)this.fullId, (int)4, (String)"taskId").get(2));
    }

    public int getAttemptId() {
        return Integer.parseInt((String)QueryId.parseDottedId((String)this.fullId, (int)4, (String)"taskId").get(3));
    }

    @JsonValue
    public String toString() {
        return this.fullId;
    }

    public int hashCode() {
        return Objects.hash(this.fullId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TaskId other = (TaskId)obj;
        return Objects.equals(this.fullId, other.fullId);
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.estimatedSizeOf((String)this.fullId);
    }
}

