/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.DataSize;
import io.trino.operator.DriverContext;
import io.trino.operator.Operator;
import io.trino.operator.OperatorContext;
import io.trino.operator.OperatorFactory;
import io.trino.operator.aggregation.TypedSet;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.predicate.Utils;
import io.trino.spi.predicate.ValueSet;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeUtils;
import io.trino.sql.planner.DynamicFilterSourceConsumer;
import io.trino.sql.planner.plan.DynamicFilterId;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.type.BlockTypeOperators;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class DynamicFilterSourceOperator
implements Operator {
    private static final int EXPECTED_BLOCK_BUILDER_SIZE = 8;
    private final OperatorContext context;
    private boolean finished;
    private Page current;
    private final DynamicFilterSourceConsumer dynamicPredicateConsumer;
    private final List<Channel> channels;
    private final ChannelFilter[] channelFilters;
    private int minMaxCollectionLimit;
    private boolean isDomainCollectionComplete;

    private DynamicFilterSourceOperator(OperatorContext context, DynamicFilterSourceConsumer dynamicPredicateConsumer, List<Channel> channels, PlanNodeId planNodeId, int maxDistinctValues, DataSize maxFilterSize, int minMaxCollectionLimit, BlockTypeOperators blockTypeOperators) {
        this.context = Objects.requireNonNull(context, "context is null");
        this.minMaxCollectionLimit = minMaxCollectionLimit;
        this.dynamicPredicateConsumer = Objects.requireNonNull(dynamicPredicateConsumer, "dynamicPredicateConsumer is null");
        this.channels = Objects.requireNonNull(channels, "channels is null");
        this.channelFilters = new ChannelFilter[channels.size()];
        for (int channelIndex = 0; channelIndex < channels.size(); ++channelIndex) {
            this.channelFilters[channelIndex] = new ChannelFilter(blockTypeOperators, minMaxCollectionLimit > 0, planNodeId, maxDistinctValues, maxFilterSize.toBytes(), this::finishDomainCollectionIfNecessary, channels.get(channelIndex));
        }
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.context;
    }

    @Override
    public boolean needsInput() {
        return this.current == null && !this.finished;
    }

    @Override
    public void addInput(Page page) {
        int channelIndex;
        Verify.verify((!this.finished ? 1 : 0) != 0, (String)"DynamicFilterSourceOperator: addInput() may not be called after finish()", (Object[])new Object[0]);
        this.current = page;
        if (this.isDomainCollectionComplete) {
            return;
        }
        if (this.minMaxCollectionLimit >= 0) {
            this.minMaxCollectionLimit -= page.getPositionCount();
            if (this.minMaxCollectionLimit < 0) {
                for (channelIndex = 0; channelIndex < this.channels.size(); ++channelIndex) {
                    this.channelFilters[channelIndex].disableMinMax();
                }
                this.finishDomainCollectionIfNecessary();
            }
        }
        for (channelIndex = 0; channelIndex < this.channels.size(); ++channelIndex) {
            Block block = page.getBlock(this.channels.get((int)channelIndex).index);
            this.channelFilters[channelIndex].process(block);
        }
    }

    @Override
    public Page getOutput() {
        Page result = this.current;
        this.current = null;
        return result;
    }

    @Override
    public void finish() {
        if (this.finished) {
            return;
        }
        this.finished = true;
        if (this.isDomainCollectionComplete) {
            return;
        }
        ImmutableMap.Builder domainsBuilder = ImmutableMap.builder();
        for (int channelIndex = 0; channelIndex < this.channels.size(); ++channelIndex) {
            DynamicFilterId filterId = this.channels.get((int)channelIndex).filterId;
            domainsBuilder.put((Object)filterId, (Object)this.channelFilters[channelIndex].getDomain());
        }
        this.dynamicPredicateConsumer.addPartition((TupleDomain<DynamicFilterId>)TupleDomain.withColumnDomains((Map)domainsBuilder.buildOrThrow()));
    }

    @Override
    public boolean isFinished() {
        return this.current == null && this.finished;
    }

    private void finishDomainCollectionIfNecessary() {
        if (!this.isDomainCollectionComplete && Arrays.stream(this.channelFilters).allMatch(channel -> channel.state == ChannelState.NONE)) {
            this.dynamicPredicateConsumer.addPartition((TupleDomain<DynamicFilterId>)TupleDomain.all());
            this.isDomainCollectionComplete = true;
        }
    }

    private static boolean isMinMaxPossible(Type type) {
        return type.isOrderable() && type != DoubleType.DOUBLE && type != RealType.REAL;
    }

    private static class ChannelFilter {
        private final Type type;
        private final int maxDistinctValues;
        private final long maxFilterSizeInBytes;
        private final Runnable notifyStateChange;
        private ChannelState state;
        private boolean collectMinMax;
        @Nullable
        private BlockBuilder blockBuilder;
        @Nullable
        private TypedSet valueSet;
        @Nullable
        private Block minValues;
        @Nullable
        private Block maxValues;
        @Nullable
        private BlockTypeOperators.BlockPositionComparison minMaxComparison;

        private ChannelFilter(BlockTypeOperators blockTypeOperators, boolean minMaxEnabled, PlanNodeId planNodeId, int maxDistinctValues, long maxFilterSizeInBytes, Runnable notifyStateChange, Channel channel) {
            this.maxDistinctValues = maxDistinctValues;
            this.maxFilterSizeInBytes = maxFilterSizeInBytes;
            this.notifyStateChange = Objects.requireNonNull(notifyStateChange, "notifyStateChange is null");
            this.type = channel.type;
            this.state = ChannelState.SET;
            boolean bl = this.collectMinMax = minMaxEnabled && DynamicFilterSourceOperator.isMinMaxPossible(this.type);
            if (this.collectMinMax) {
                this.minMaxComparison = blockTypeOperators.getComparisonUnorderedLastOperator(this.type);
            }
            this.blockBuilder = this.type.createBlockBuilder(null, 8);
            this.valueSet = TypedSet.createUnboundedEqualityTypedSet(this.type, blockTypeOperators.getEqualOperator(this.type), blockTypeOperators.getHashCodeOperator(this.type), this.blockBuilder, 8, String.format("DynamicFilterSourceOperator_%s_%d", planNodeId, channel.index));
        }

        private void process(Block block) {
            switch (this.state) {
                case SET: {
                    for (int position = 0; position < block.getPositionCount(); ++position) {
                        this.valueSet.add(block, position);
                    }
                    if (this.valueSet.size() <= this.maxDistinctValues && this.valueSet.getRetainedSizeInBytes() <= this.maxFilterSizeInBytes) break;
                    if (this.collectMinMax) {
                        this.state = ChannelState.MIN_MAX;
                        this.updateMinMaxValues(this.blockBuilder.build(), this.minMaxComparison);
                    } else {
                        this.state = ChannelState.NONE;
                        this.notifyStateChange.run();
                    }
                    this.valueSet = null;
                    this.blockBuilder = null;
                    break;
                }
                case MIN_MAX: {
                    this.updateMinMaxValues(block, this.minMaxComparison);
                    break;
                }
            }
        }

        private Domain getDomain() {
            return switch (this.state) {
                default -> throw new IncompatibleClassChangeError();
                case ChannelState.SET -> this.convertToDomain();
                case ChannelState.MIN_MAX -> {
                    if (this.minValues == null) {
                        yield Domain.none((Type)this.type);
                    }
                    Object min = Utils.blockToNativeValue((Type)this.type, (Block)this.minValues);
                    Object max = Utils.blockToNativeValue((Type)this.type, (Block)this.maxValues);
                    yield Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)this.type, (Object)min, (boolean)true, (Object)max, (boolean)true), (Range[])new Range[0]), (boolean)false);
                }
                case ChannelState.NONE -> Domain.all((Type)this.type);
            };
        }

        private void disableMinMax() {
            this.collectMinMax = false;
            if (this.state == ChannelState.MIN_MAX) {
                this.state = ChannelState.NONE;
            }
            this.minValues = null;
            this.maxValues = null;
        }

        private Domain convertToDomain() {
            Block block = this.blockBuilder.build();
            ImmutableList.Builder values = ImmutableList.builder();
            for (int position = 0; position < block.getPositionCount(); ++position) {
                Object value = TypeUtils.readNativeValue((Type)this.type, (Block)block, (int)position);
                if (value == null || TypeUtils.isFloatingPointNaN((Type)this.type, (Object)value)) continue;
                values.add(value);
            }
            return Domain.create((ValueSet)ValueSet.copyOf((Type)this.type, (Collection)values.build()), (boolean)false);
        }

        private void updateMinMaxValues(Block block, BlockTypeOperators.BlockPositionComparison comparison) {
            int minValuePosition = -1;
            int maxValuePosition = -1;
            for (int position = 0; position < block.getPositionCount(); ++position) {
                if (block.isNull(position)) continue;
                if (minValuePosition == -1) {
                    minValuePosition = position;
                    maxValuePosition = position;
                    continue;
                }
                if (comparison.compare(block, position, block, minValuePosition) < 0L) {
                    minValuePosition = position;
                    continue;
                }
                if (comparison.compare(block, position, block, maxValuePosition) <= 0L) continue;
                maxValuePosition = position;
            }
            if (minValuePosition == -1) {
                return;
            }
            if (this.minValues == null) {
                this.minValues = block.getSingleValueBlock(minValuePosition);
                this.maxValues = block.getSingleValueBlock(maxValuePosition);
                return;
            }
            Block currentMin = this.minValues;
            Block currentMax = this.maxValues;
            if (comparison.compare(block, minValuePosition, currentMin, 0) < 0L) {
                this.minValues = block.getSingleValueBlock(minValuePosition);
            }
            if (comparison.compare(block, maxValuePosition, currentMax, 0) > 0L) {
                this.maxValues = block.getSingleValueBlock(maxValuePosition);
            }
        }
    }

    public static class Channel {
        private final DynamicFilterId filterId;
        private final Type type;
        private final int index;

        public Channel(DynamicFilterId filterId, Type type, int index) {
            this.filterId = filterId;
            this.type = type;
            this.index = index;
        }
    }

    private static enum ChannelState {
        SET,
        MIN_MAX,
        NONE;

    }

    private static class PassthroughDynamicFilterSourceOperator
    implements Operator {
        private final OperatorContext operatorContext;
        private boolean finished;
        private Page current;

        private PassthroughDynamicFilterSourceOperator(OperatorContext operatorContext) {
            this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        }

        @Override
        public OperatorContext getOperatorContext() {
            return this.operatorContext;
        }

        @Override
        public boolean needsInput() {
            return this.current == null && !this.finished;
        }

        @Override
        public void addInput(Page page) {
            Verify.verify((!this.finished ? 1 : 0) != 0, (String)"DynamicFilterSourceOperator: addInput() may not be called after finish()", (Object[])new Object[0]);
            this.current = page;
        }

        @Override
        public Page getOutput() {
            Page result = this.current;
            this.current = null;
            return result;
        }

        @Override
        public void finish() {
            if (this.finished) {
                return;
            }
            this.finished = true;
        }

        @Override
        public boolean isFinished() {
            return this.current == null && this.finished;
        }
    }

    public static class DynamicFilterSourceOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final DynamicFilterSourceConsumer dynamicPredicateConsumer;
        private final List<Channel> channels;
        private final int maxDistinctValues;
        private final DataSize maxFilterSize;
        private final int minMaxCollectionLimit;
        private final BlockTypeOperators blockTypeOperators;
        private boolean closed;
        private int createdOperatorsCount;

        public DynamicFilterSourceOperatorFactory(int operatorId, PlanNodeId planNodeId, DynamicFilterSourceConsumer dynamicPredicateConsumer, List<Channel> channels, int maxDistinctValues, DataSize maxFilterSize, int minMaxCollectionLimit, BlockTypeOperators blockTypeOperators) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.dynamicPredicateConsumer = Objects.requireNonNull(dynamicPredicateConsumer, "dynamicPredicateConsumer is null");
            this.channels = Objects.requireNonNull(channels, "channels is null");
            Verify.verify((channels.stream().map(channel -> channel.filterId).collect(Collectors.toSet()).size() == channels.size() ? 1 : 0) != 0, (String)"duplicate dynamic filters are not allowed", (Object[])new Object[0]);
            Verify.verify((channels.stream().map(channel -> channel.index).collect(Collectors.toSet()).size() == channels.size() ? 1 : 0) != 0, (String)"duplicate channel indices are not allowed", (Object[])new Object[0]);
            this.maxDistinctValues = maxDistinctValues;
            this.maxFilterSize = maxFilterSize;
            this.minMaxCollectionLimit = minMaxCollectionLimit;
            this.blockTypeOperators = Objects.requireNonNull(blockTypeOperators, "blockTypeOperators is null");
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            ++this.createdOperatorsCount;
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, DynamicFilterSourceOperator.class.getSimpleName());
            if (!this.dynamicPredicateConsumer.isDomainCollectionComplete()) {
                return new DynamicFilterSourceOperator(operatorContext, this.dynamicPredicateConsumer, this.channels, this.planNodeId, this.maxDistinctValues, this.maxFilterSize, this.minMaxCollectionLimit, this.blockTypeOperators);
            }
            return new PassthroughDynamicFilterSourceOperator(operatorContext);
        }

        @Override
        public void noMoreOperators() {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            this.closed = true;
            this.dynamicPredicateConsumer.setPartitionCount(this.createdOperatorsCount);
        }

        @Override
        public OperatorFactory duplicate() {
            this.dynamicPredicateConsumer.addPartition((TupleDomain<DynamicFilterId>)TupleDomain.all());
            return new DynamicFilterSourceOperatorFactory(this.operatorId, this.planNodeId, new DynamicFilterSourceConsumer(){

                @Override
                public void addPartition(TupleDomain<DynamicFilterId> tupleDomain) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void setPartitionCount(int partitionCount) {
                }

                @Override
                public boolean isDomainCollectionComplete() {
                    return true;
                }
            }, this.channels, this.maxDistinctValues, this.maxFilterSize, this.minMaxCollectionLimit, this.blockTypeOperators);
        }
    }
}

