/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.concurrent.MoreFutures;
import io.airlift.slice.Slice;
import io.trino.Session;
import io.trino.operator.DriverContext;
import io.trino.operator.Operator;
import io.trino.operator.OperatorContext;
import io.trino.operator.OperatorFactory;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.connector.ConnectorMergeSink;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.split.PageSinkId;
import io.trino.split.PageSinkManager;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.TableWriterNode;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.IntStream;

public class MergeWriterOperator
implements Operator {
    private static final List<Type> TYPES = ImmutableList.of((Object)BigintType.BIGINT, (Object)VarbinaryType.VARBINARY);
    private final OperatorContext operatorContext;
    private State state = State.RUNNING;
    private final ConnectorMergeSink mergeSink;
    private final Function<Page, Page> pagePreprocessor;
    private ListenableFuture<Collection<Slice>> finishFuture;
    private ListenableFuture<Void> blockedFutureView;
    private long rowCount;
    private boolean closed;

    public MergeWriterOperator(OperatorContext operatorContext, ConnectorMergeSink mergeSink, Function<Page, Page> pagePreprocessor) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.mergeSink = Objects.requireNonNull(mergeSink, "mergeSink is null");
        this.pagePreprocessor = Objects.requireNonNull(pagePreprocessor, "pagePreprocessor is null");
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public boolean isFinished() {
        return this.state == State.FINISHED;
    }

    @Override
    public boolean needsInput() {
        return this.state == State.RUNNING;
    }

    @Override
    public void addInput(Page suppliedPage) {
        Objects.requireNonNull(suppliedPage, "suppliedPage is null");
        Page page = this.pagePreprocessor.apply(suppliedPage);
        Preconditions.checkState((this.state == State.RUNNING ? 1 : 0) != 0, (String)"Operator is %s", (Object)((Object)this.state));
        int outputChannelCount = page.getChannelCount() - 1;
        int[] columns = IntStream.range(0, outputChannelCount).toArray();
        Page newPage = page.getColumns(columns);
        this.mergeSink.storeMergedRows(newPage);
        Block insertFromUpdateColumn = page.getBlock(page.getChannelCount() - 1);
        long insertsFromUpdates = 0L;
        int positionCount = page.getPositionCount();
        for (int position = 0; position < positionCount; ++position) {
            insertsFromUpdates += TinyintType.TINYINT.getLong(insertFromUpdateColumn, position);
        }
        this.rowCount += (long)positionCount - insertsFromUpdates;
    }

    @Override
    public Page getOutput() {
        if (this.state != State.FINISHING || !this.finishFuture.isDone()) {
            return null;
        }
        this.state = State.FINISHED;
        Collection fragments = (Collection)MoreFutures.getFutureValue(this.finishFuture);
        PageBuilder page = new PageBuilder(fragments.size() + 1, TYPES);
        BlockBuilder rowsBuilder = page.getBlockBuilder(0);
        BlockBuilder fragmentBuilder = page.getBlockBuilder(1);
        page.declarePosition();
        BigintType.BIGINT.writeLong(rowsBuilder, this.rowCount);
        fragmentBuilder.appendNull();
        for (Slice fragment : fragments) {
            page.declarePosition();
            rowsBuilder.appendNull();
            VarbinaryType.VARBINARY.writeSlice(fragmentBuilder, fragment);
        }
        return page.build();
    }

    @Override
    public void finish() {
        if (this.state == State.RUNNING) {
            this.state = State.FINISHING;
            this.finishFuture = MoreFutures.toListenableFuture((CompletableFuture)this.mergeSink.finish());
            this.blockedFutureView = MergeWriterOperator.asVoid(this.finishFuture);
        }
    }

    private static <T> ListenableFuture<Void> asVoid(ListenableFuture<T> future) {
        return Futures.transform(future, v -> null, (Executor)MoreExecutors.directExecutor());
    }

    @Override
    public ListenableFuture<Void> isBlocked() {
        if (this.blockedFutureView == null) {
            return NOT_BLOCKED;
        }
        return this.blockedFutureView;
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            if (this.finishFuture != null) {
                this.finishFuture.cancel(true);
            }
        }
    }

    private static enum State {
        RUNNING,
        FINISHING,
        FINISHED;

    }

    public static class MergeWriterOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final PageSinkManager pageSinkManager;
        private final TableWriterNode.MergeTarget target;
        private final Session session;
        private final Function<Page, Page> pagePreprocessor;
        private boolean closed;

        public MergeWriterOperatorFactory(int operatorId, PlanNodeId planNodeId, PageSinkManager pageSinkManager, TableWriterNode.MergeTarget target, Session session, Function<Page, Page> pagePreprocessor) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.pageSinkManager = Objects.requireNonNull(pageSinkManager, "pageSinkManager is null");
            this.target = Objects.requireNonNull(target, "target is null");
            this.session = Objects.requireNonNull(session, "session is null");
            this.pagePreprocessor = Objects.requireNonNull(pagePreprocessor, "pagePreprocessor is null");
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext context = driverContext.addOperatorContext(this.operatorId, this.planNodeId, MergeWriterOperator.class.getSimpleName());
            ConnectorMergeSink mergeSink = this.pageSinkManager.createMergeSink(this.session, this.target.getMergeHandle().orElseThrow(), PageSinkId.fromTaskId(driverContext.getTaskId()));
            return new MergeWriterOperator(context, mergeSink, this.pagePreprocessor);
        }

        @Override
        public void noMoreOperators() {
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            return new MergeWriterOperatorFactory(this.operatorId, this.planNodeId, this.pageSinkManager, this.target, this.session, this.pagePreprocessor);
        }
    }
}

