/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.collect.ImmutableList;
import io.trino.operator.CompletedWork;
import io.trino.operator.GroupByHash;
import io.trino.operator.GroupByIdBlock;
import io.trino.operator.Work;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import java.util.List;
import org.openjdk.jol.info.ClassLayout;

public class NoChannelGroupByHash
implements GroupByHash {
    private static final int INSTANCE_SIZE = Math.toIntExact(ClassLayout.parseClass(NoChannelGroupByHash.class).instanceSize());
    private int groupCount;

    @Override
    public long getEstimatedSize() {
        return INSTANCE_SIZE;
    }

    @Override
    public List<Type> getTypes() {
        return ImmutableList.of();
    }

    @Override
    public int getGroupCount() {
        return this.groupCount;
    }

    @Override
    public void appendValuesTo(int groupId, PageBuilder pageBuilder) {
        throw new UnsupportedOperationException("NoChannelGroupByHash does not support appendValuesTo");
    }

    @Override
    public Work<?> addPage(Page page) {
        this.updateGroupCount(page);
        return new CompletedWork<Integer>(0);
    }

    @Override
    public Work<GroupByIdBlock> getGroupIds(Page page) {
        this.updateGroupCount(page);
        return new CompletedWork<GroupByIdBlock>(new GroupByIdBlock(page.getPositionCount() > 0 ? 1L : 0L, RunLengthEncodedBlock.create((Type)BigintType.BIGINT, (Object)0L, (int)page.getPositionCount())));
    }

    @Override
    public boolean contains(int position, Page page, int[] hashChannels) {
        throw new UnsupportedOperationException("NoChannelGroupByHash does not support getHashCollisions");
    }

    @Override
    public long getRawHash(int groupyId) {
        throw new UnsupportedOperationException("NoChannelGroupByHash does not support getHashCollisions");
    }

    @Override
    public int getCapacity() {
        return 2;
    }

    private void updateGroupCount(Page page) {
        if (page.getPositionCount() > 0 && this.groupCount == 0) {
            this.groupCount = 1;
        }
    }
}

