/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.concurrent.MoreFutures;
import io.trino.Session;
import io.trino.memory.context.LocalMemoryContext;
import io.trino.memory.context.MemoryTrackingContext;
import io.trino.metadata.Split;
import io.trino.metadata.TableHandle;
import io.trino.operator.DriverContext;
import io.trino.operator.DriverYieldSignal;
import io.trino.operator.OperatorContext;
import io.trino.operator.OperatorInfo;
import io.trino.operator.SourceOperator;
import io.trino.operator.SourceOperatorFactory;
import io.trino.operator.SplitOperatorInfo;
import io.trino.operator.TableScanWorkProcessorOperator;
import io.trino.operator.WorkProcessor;
import io.trino.operator.WorkProcessorSourceOperator;
import io.trino.operator.WorkProcessorSourceOperatorFactory;
import io.trino.spi.Page;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.EmptyPageSource;
import io.trino.split.EmptySplit;
import io.trino.split.PageSourceProvider;
import io.trino.sql.planner.plan.PlanNodeId;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public class TableScanOperator
implements SourceOperator {
    private final OperatorContext operatorContext;
    private final PlanNodeId planNodeId;
    private final PageSourceProvider pageSourceProvider;
    private final TableHandle table;
    private final List<ColumnHandle> columns;
    private final DynamicFilter dynamicFilter;
    private final LocalMemoryContext memoryContext;
    private final SettableFuture<Void> blocked = SettableFuture.create();
    @Nullable
    private Split split;
    @Nullable
    private ConnectorPageSource source;
    private boolean finished;
    private long completedBytes;
    private long completedPositions;
    private long readTimeNanos;

    public TableScanOperator(OperatorContext operatorContext, PlanNodeId planNodeId, PageSourceProvider pageSourceProvider, TableHandle table, Iterable<ColumnHandle> columns, DynamicFilter dynamicFilter) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
        this.pageSourceProvider = Objects.requireNonNull(pageSourceProvider, "pageSourceProvider is null");
        this.table = Objects.requireNonNull(table, "table is null");
        this.columns = ImmutableList.copyOf(Objects.requireNonNull(columns, "columns is null"));
        this.dynamicFilter = Objects.requireNonNull(dynamicFilter, "dynamicFilter is null");
        this.memoryContext = operatorContext.newLocalUserMemoryContext(TableScanOperator.class.getSimpleName());
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public PlanNodeId getSourceId() {
        return this.planNodeId;
    }

    @Override
    public void addSplit(Split split) {
        Objects.requireNonNull(split, "split is null");
        Preconditions.checkState((this.split == null ? 1 : 0) != 0, (Object)"Table scan split already set");
        if (this.finished) {
            return;
        }
        this.split = split;
        Object splitInfo = split.getInfo();
        if (splitInfo != null) {
            this.operatorContext.setInfoSupplier((Supplier<? extends OperatorInfo>)Suppliers.ofInstance((Object)new SplitOperatorInfo(split.getCatalogHandle(), splitInfo)));
        }
        this.blocked.set(null);
        if (split.getConnectorSplit() instanceof EmptySplit) {
            this.source = new EmptyPageSource();
        }
    }

    @Override
    public void noMoreSplits() {
        if (this.split == null) {
            this.finished = true;
        }
        this.blocked.set(null);
    }

    @Override
    public void close() {
        this.finish();
    }

    @Override
    public void finish() {
        this.finished = true;
        this.blocked.set(null);
        if (this.source != null) {
            try {
                this.source.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            this.memoryContext.setBytes(this.source.getMemoryUsage());
            this.operatorContext.setLatestConnectorMetrics(this.source.getMetrics());
        }
    }

    @Override
    public boolean isFinished() {
        if (!this.finished) {
            boolean bl = this.finished = this.source != null && this.source.isFinished();
            if (this.source != null) {
                this.memoryContext.setBytes(this.source.getMemoryUsage());
            }
        }
        return this.finished;
    }

    @Override
    public ListenableFuture<Void> isBlocked() {
        if (!this.blocked.isDone()) {
            return this.blocked;
        }
        if (this.source != null) {
            CompletableFuture pageSourceBlocked = this.source.isBlocked();
            return pageSourceBlocked.isDone() ? NOT_BLOCKED : TableScanOperator.asVoid(MoreFutures.toListenableFuture((CompletableFuture)pageSourceBlocked));
        }
        return NOT_BLOCKED;
    }

    private static <T> ListenableFuture<Void> asVoid(ListenableFuture<T> future) {
        return Futures.transform(future, v -> null, (Executor)MoreExecutors.directExecutor());
    }

    @Override
    public boolean needsInput() {
        return false;
    }

    @Override
    public void addInput(Page page) {
        throw new UnsupportedOperationException(this.getClass().getName() + " cannot take input");
    }

    @Override
    public Page getOutput() {
        Page page;
        if (this.split == null) {
            return null;
        }
        if (this.source == null) {
            if (!this.dynamicFilter.getCurrentPredicate().isAll()) {
                this.operatorContext.recordDynamicFilterSplitProcessed(1L);
            }
            this.source = this.pageSourceProvider.createPageSource(this.operatorContext.getSession(), this.split, this.table, this.columns, this.dynamicFilter);
        }
        if ((page = this.source.getNextPage()) != null) {
            page = page.getLoadedPage();
            long endCompletedBytes = this.source.getCompletedBytes();
            long endReadTimeNanos = this.source.getReadTimeNanos();
            long positionCount = page.getPositionCount();
            long endCompletedPositions = this.source.getCompletedPositions().orElse(this.completedPositions + positionCount);
            this.operatorContext.recordPhysicalInputWithTiming(endCompletedBytes - this.completedBytes, endCompletedPositions - this.completedPositions, endReadTimeNanos - this.readTimeNanos);
            this.operatorContext.recordProcessedInput(page.getSizeInBytes(), positionCount);
            this.completedBytes = endCompletedBytes;
            this.completedPositions = endCompletedPositions;
            this.readTimeNanos = endReadTimeNanos;
        }
        this.memoryContext.setBytes(this.source.getMemoryUsage());
        this.operatorContext.setLatestConnectorMetrics(this.source.getMetrics());
        return page;
    }

    public static class TableScanOperatorFactory
    implements SourceOperatorFactory,
    WorkProcessorSourceOperatorFactory {
        private final int operatorId;
        private final PlanNodeId sourceId;
        private final PageSourceProvider pageSourceProvider;
        private final TableHandle table;
        private final List<ColumnHandle> columns;
        private final DynamicFilter dynamicFilter;
        private boolean closed;

        public TableScanOperatorFactory(int operatorId, PlanNodeId sourceId, PageSourceProvider pageSourceProvider, TableHandle table, Iterable<ColumnHandle> columns, DynamicFilter dynamicFilter) {
            this.operatorId = operatorId;
            this.sourceId = Objects.requireNonNull(sourceId, "sourceId is null");
            this.pageSourceProvider = Objects.requireNonNull(pageSourceProvider, "pageSourceProvider is null");
            this.table = Objects.requireNonNull(table, "table is null");
            this.columns = ImmutableList.copyOf(Objects.requireNonNull(columns, "columns is null"));
            this.dynamicFilter = Objects.requireNonNull(dynamicFilter, "dynamicFilter is null");
        }

        @Override
        public int getOperatorId() {
            return this.operatorId;
        }

        @Override
        public PlanNodeId getSourceId() {
            return this.sourceId;
        }

        @Override
        public PlanNodeId getPlanNodeId() {
            return this.sourceId;
        }

        @Override
        public String getOperatorType() {
            return TableScanOperator.class.getSimpleName();
        }

        @Override
        public SourceOperator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.sourceId, this.getOperatorType());
            return new TableScanOperator(operatorContext, this.sourceId, this.pageSourceProvider, this.table, this.columns, this.dynamicFilter);
        }

        @Override
        public WorkProcessorSourceOperator create(Session session, MemoryTrackingContext memoryTrackingContext, DriverYieldSignal yieldSignal, WorkProcessor<Split> splits) {
            return new TableScanWorkProcessorOperator(session, memoryTrackingContext, splits, this.pageSourceProvider, this.table, this.columns, this.dynamicFilter);
        }

        @Override
        public void noMoreOperators() {
            this.closed = true;
        }
    }
}

