/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.histogram;

import io.trino.operator.aggregation.histogram.HistogramState;
import io.trino.operator.aggregation.histogram.SingleTypedHistogram;
import io.trino.operator.aggregation.histogram.TypedHistogram;
import io.trino.spi.block.Block;
import io.trino.spi.type.Type;
import io.trino.type.BlockTypeOperators;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class SingleHistogramState
implements HistogramState {
    private static final int INSTANCE_SIZE = Math.toIntExact(ClassLayout.parseClass(SingleHistogramState.class).instanceSize());
    private final Type keyType;
    private final BlockTypeOperators.BlockPositionEqual equalOperator;
    private final BlockTypeOperators.BlockPositionHashCode hashCodeOperator;
    private SingleTypedHistogram typedHistogram;

    public SingleHistogramState(Type keyType, BlockTypeOperators.BlockPositionEqual equalOperator, BlockTypeOperators.BlockPositionHashCode hashCodeOperator, int expectedEntriesCount) {
        this.keyType = Objects.requireNonNull(keyType, "keyType is null");
        this.equalOperator = Objects.requireNonNull(equalOperator, "equalOperator is null");
        this.hashCodeOperator = Objects.requireNonNull(hashCodeOperator, "hashCodeOperator is null");
        this.typedHistogram = new SingleTypedHistogram(keyType, equalOperator, hashCodeOperator, expectedEntriesCount);
    }

    @Override
    public TypedHistogram get() {
        return this.typedHistogram;
    }

    @Override
    public void deserialize(Block block, int expectedSize) {
        this.typedHistogram = new SingleTypedHistogram(block, this.keyType, this.equalOperator, this.hashCodeOperator, expectedSize);
    }

    @Override
    public void addMemoryUsage(long memory) {
    }

    public long getEstimatedSize() {
        long estimatedSize = INSTANCE_SIZE;
        if (this.typedHistogram != null) {
            estimatedSize += this.typedHistogram.getEstimatedSize();
        }
        return estimatedSize;
    }
}

