/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.exchange;

import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.log.Logger;
import io.airlift.units.DataSize;
import io.trino.operator.exchange.LocalExchangeMemoryManager;
import io.trino.operator.exchange.LocalExchanger;
import io.trino.spi.Page;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class ScaleWriterExchanger
implements LocalExchanger {
    private static final Logger log = Logger.get(ScaleWriterExchanger.class);
    private final List<Consumer<Page>> buffers;
    private final LocalExchangeMemoryManager memoryManager;
    private final long maxBufferedBytes;
    private final Supplier<Long> physicalWrittenBytesSupplier;
    private final long writerMinSize;
    private int writerCount = 1;
    private long lastScaleUpPhysicalWrittenBytes;
    private int nextWriterIndex = -1;

    public ScaleWriterExchanger(List<Consumer<Page>> buffers, LocalExchangeMemoryManager memoryManager, long maxBufferedBytes, Supplier<Long> physicalWrittenBytesSupplier, DataSize writerMinSize) {
        this.buffers = Objects.requireNonNull(buffers, "buffers is null");
        this.memoryManager = Objects.requireNonNull(memoryManager, "memoryManager is null");
        this.maxBufferedBytes = maxBufferedBytes;
        this.physicalWrittenBytesSupplier = Objects.requireNonNull(physicalWrittenBytesSupplier, "physicalWrittenBytesSupplier is null");
        this.writerMinSize = writerMinSize.toBytes();
    }

    @Override
    public void accept(Page page) {
        Consumer<Page> buffer = this.buffers.get(this.getNextWriterIndex());
        this.memoryManager.updateMemoryUsage(page.getRetainedSizeInBytes());
        buffer.accept(page);
    }

    private int getNextWriterIndex() {
        long physicalWrittenBytes;
        if (this.writerCount < this.buffers.size() && this.memoryManager.getBufferedBytes() >= this.maxBufferedBytes / 2L && (physicalWrittenBytes = this.physicalWrittenBytesSupplier.get().longValue()) - this.lastScaleUpPhysicalWrittenBytes >= (long)this.writerCount * this.writerMinSize) {
            this.lastScaleUpPhysicalWrittenBytes = physicalWrittenBytes;
            ++this.writerCount;
            log.debug("Increased task writer count: %d", new Object[]{this.writerCount});
        }
        this.nextWriterIndex = (this.nextWriterIndex + 1) % this.writerCount;
        return this.nextWriterIndex;
    }

    @Override
    public ListenableFuture<Void> waitForWriting() {
        return this.memoryManager.getNotFullFuture();
    }
}

