/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.join;

import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.slice.XxHash64;
import io.trino.operator.join.JoinFilterFunction;
import io.trino.operator.join.PositionLinks;
import io.trino.spi.Page;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public final class ArrayPositionLinks
implements PositionLinks {
    private static final int INSTANCE_SIZE = Math.toIntExact(ClassLayout.parseClass(ArrayPositionLinks.class).instanceSize());
    private final int[] positionLinks;

    private ArrayPositionLinks(int[] positionLinks) {
        this.positionLinks = Objects.requireNonNull(positionLinks, "positionLinks is null");
    }

    public static FactoryBuilder builder(int size) {
        return new FactoryBuilder(size);
    }

    @Override
    public int start(int position, int probePosition, Page allProbeChannelsPage) {
        return position;
    }

    @Override
    public int next(int position, int probePosition, Page allProbeChannelsPage) {
        return this.positionLinks[position];
    }

    @Override
    public long getSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((int[])this.positionLinks);
    }

    public static long getEstimatedRetainedSizeInBytes(int positionCount) {
        return (long)INSTANCE_SIZE + SizeOf.sizeOfIntArray((int)positionCount);
    }

    public static class FactoryBuilder
    implements PositionLinks.FactoryBuilder {
        private final int[] positionLinks;
        private int size;

        private FactoryBuilder(int size) {
            this.positionLinks = new int[size];
            Arrays.fill(this.positionLinks, -1);
        }

        @Override
        public int link(int left, int right) {
            ++this.size;
            this.positionLinks[left] = right;
            return left;
        }

        @Override
        public PositionLinks.Factory build() {
            return new PositionLinks.Factory(){

                @Override
                public PositionLinks create(List<JoinFilterFunction> searchFunctions) {
                    return new ArrayPositionLinks(positionLinks);
                }

                @Override
                public long checksum() {
                    return XxHash64.hash((Slice)Slices.wrappedIntArray((int[])positionLinks));
                }
            };
        }

        @Override
        public boolean isEmpty() {
            return this.size == 0;
        }
    }
}

