/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.join;

import com.google.common.base.Preconditions;
import io.trino.operator.join.JoinFilterFunction;
import io.trino.operator.join.LookupSource;
import io.trino.operator.join.PagesHash;
import io.trino.operator.join.PositionLinks;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.openjdk.jol.info.ClassLayout;

public final class JoinHash
implements LookupSource {
    private static final int INSTANCE_SIZE = Math.toIntExact(ClassLayout.parseClass(JoinHash.class).instanceSize());
    private final PagesHash pagesHash;
    @Nullable
    private final JoinFilterFunction filterFunction;
    @Nullable
    private final PositionLinks positionLinks;
    private final long pageInstancesRetainedSizeInBytes;

    public JoinHash(PagesHash pagesHash, Optional<JoinFilterFunction> filterFunction, Optional<PositionLinks> positionLinks, long pageInstancesRetainedSizeInBytes) {
        this.pagesHash = Objects.requireNonNull(pagesHash, "pagesHash is null");
        this.filterFunction = filterFunction.orElse(null);
        this.positionLinks = positionLinks.orElse(null);
        this.pageInstancesRetainedSizeInBytes = pageInstancesRetainedSizeInBytes;
    }

    @Override
    public boolean isEmpty() {
        return this.getJoinPositionCount() == 0L;
    }

    @Override
    public long getJoinPositionCount() {
        return this.pagesHash.getPositionCount();
    }

    @Override
    public long getInMemorySizeInBytes() {
        return (long)INSTANCE_SIZE + this.pagesHash.getInMemorySizeInBytes() + (this.positionLinks == null ? 0L : this.positionLinks.getSizeInBytes()) + this.pageInstancesRetainedSizeInBytes;
    }

    @Override
    public long joinPositionWithinPartition(long joinPosition) {
        return joinPosition;
    }

    @Override
    public long getJoinPosition(int position, Page hashChannelsPage, Page allChannelsPage) {
        int addressIndex = this.pagesHash.getAddressIndex(position, hashChannelsPage);
        return this.startJoinPosition(addressIndex, position, allChannelsPage);
    }

    @Override
    public long getJoinPosition(int position, Page hashChannelsPage, Page allChannelsPage, long rawHash) {
        int addressIndex = this.pagesHash.getAddressIndex(position, hashChannelsPage, rawHash);
        return this.startJoinPosition(addressIndex, position, allChannelsPage);
    }

    @Override
    public void getJoinPosition(int[] positions, Page hashChannelsPage, Page allChannelsPage, long[] rawHashes, long[] result) {
        int[] addressIndexex = this.pagesHash.getAddressIndex(positions, hashChannelsPage, rawHashes);
        this.startJoinPosition(addressIndexex, positions, allChannelsPage, result);
    }

    @Override
    public void getJoinPosition(int[] positions, Page hashChannelsPage, Page allChannelsPage, long[] result) {
        int[] addressIndexex = this.pagesHash.getAddressIndex(positions, hashChannelsPage);
        this.startJoinPosition(addressIndexex, positions, allChannelsPage, result);
    }

    private long startJoinPosition(int currentJoinPosition, int probePosition, Page allProbeChannelsPage) {
        if (currentJoinPosition == -1) {
            return -1L;
        }
        if (this.positionLinks == null) {
            return currentJoinPosition;
        }
        return this.positionLinks.start(currentJoinPosition, probePosition, allProbeChannelsPage);
    }

    private long[] startJoinPosition(int[] currentJoinPositions, int[] probePositions, Page allProbeChannelsPage, long[] result) {
        Preconditions.checkArgument((currentJoinPositions.length == probePositions.length ? 1 : 0) != 0, (String)"currentJoinPositions and probePositions arrays must have the same size, %s != %s", (int)currentJoinPositions.length, (int)probePositions.length);
        int positionCount = currentJoinPositions.length;
        if (this.positionLinks == null) {
            for (int i = 0; i < positionCount; ++i) {
                result[probePositions[i]] = currentJoinPositions[i];
            }
            return result;
        }
        for (int i = 0; i < positionCount; ++i) {
            result[probePositions[i]] = currentJoinPositions[i] == -1 ? -1L : (long)this.positionLinks.start(currentJoinPositions[i], probePositions[i], allProbeChannelsPage);
        }
        return result;
    }

    @Override
    public long getNextJoinPosition(long currentJoinPosition, int probePosition, Page allProbeChannelsPage) {
        if (this.positionLinks == null) {
            return -1L;
        }
        return this.positionLinks.next(Math.toIntExact(currentJoinPosition), probePosition, allProbeChannelsPage);
    }

    @Override
    public boolean isJoinPositionEligible(long currentJoinPosition, int probePosition, Page allProbeChannelsPage) {
        return this.filterFunction == null || this.filterFunction.filter(Math.toIntExact(currentJoinPosition), probePosition, allProbeChannelsPage);
    }

    @Override
    public void appendTo(long position, PageBuilder pageBuilder, int outputChannelOffset) {
        this.pagesHash.appendTo(Math.toIntExact(position), pageBuilder, outputChannelOffset);
    }

    @Override
    public void close() {
    }
}

