/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.output;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.operator.output.PagePartitioner;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Objects;
import java.util.Queue;
import java.util.function.Supplier;
import javax.annotation.concurrent.GuardedBy;

public class PagePartitionerPool {
    private final Supplier<PagePartitioner> pagePartitionerSupplier;
    private final int maxFree;
    @GuardedBy(value="this")
    private final Queue<PagePartitioner> free = new ArrayDeque<PagePartitioner>();
    @GuardedBy(value="this")
    private boolean closed;

    public PagePartitionerPool(int maxFree, Supplier<PagePartitioner> pagePartitionerSupplier) {
        this.maxFree = maxFree;
        this.pagePartitionerSupplier = Objects.requireNonNull(pagePartitionerSupplier, "pagePartitionerSupplier is null");
    }

    public synchronized PagePartitioner poll() {
        Preconditions.checkArgument((!this.closed ? 1 : 0) != 0, (Object)"The pool is already closed");
        return this.free.isEmpty() ? this.pagePartitionerSupplier.get() : this.free.poll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(PagePartitioner pagePartitioner) {
        boolean shouldRetain;
        PagePartitionerPool pagePartitionerPool = this;
        synchronized (pagePartitionerPool) {
            boolean bl = shouldRetain = !this.closed && this.free.size() < this.maxFree;
            if (shouldRetain) {
                this.free.add(pagePartitioner);
            }
        }
        if (!shouldRetain) {
            pagePartitioner.close();
        }
    }

    public void close() {
        this.markClosed().forEach(PagePartitioner::close);
    }

    private synchronized Collection<PagePartitioner> markClosed() {
        this.closed = true;
        return ImmutableList.copyOf(this.free);
    }
}

