/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.output;

import io.trino.operator.output.PositionsAppender;
import io.trino.spi.block.Block;
import io.trino.spi.block.DictionaryBlock;
import io.trino.spi.block.RunLengthEncodedBlock;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class UnnestingPositionsAppender
implements PositionsAppender {
    private static final int INSTANCE_SIZE = Math.toIntExact(ClassLayout.parseClass(UnnestingPositionsAppender.class).instanceSize());
    private final PositionsAppender delegate;

    public UnnestingPositionsAppender(PositionsAppender delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
    }

    @Override
    public void append(IntArrayList positions, Block source) {
        if (positions.isEmpty()) {
            return;
        }
        if (source instanceof RunLengthEncodedBlock) {
            this.delegate.appendRle(((RunLengthEncodedBlock)source).getValue(), positions.size());
        } else if (source instanceof DictionaryBlock) {
            this.appendDictionary(positions, (DictionaryBlock)source);
        } else {
            this.delegate.append(positions, source);
        }
    }

    @Override
    public void appendRle(Block block, int rlePositionCount) {
        if (rlePositionCount == 0) {
            return;
        }
        this.delegate.appendRle(block, rlePositionCount);
    }

    @Override
    public Block build() {
        return this.delegate.build();
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.delegate.getRetainedSizeInBytes();
    }

    @Override
    public long getSizeInBytes() {
        return this.delegate.getSizeInBytes();
    }

    private void appendDictionary(IntArrayList positions, DictionaryBlock source) {
        this.delegate.append(this.mapPositions(positions, source), source.getDictionary());
    }

    private IntArrayList mapPositions(IntArrayList positions, DictionaryBlock block) {
        int[] positionArray = new int[positions.size()];
        for (int i = 0; i < positions.size(); ++i) {
            positionArray[i] = block.getId(positions.getInt(i));
        }
        return IntArrayList.wrap((int[])positionArray);
    }
}

