/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.trino.metadata.SqlScalarFunction;
import io.trino.operator.scalar.ChoicesSpecializedSqlScalarFunction;
import io.trino.operator.scalar.JsonOperators;
import io.trino.operator.scalar.SpecializedSqlScalarFunction;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.block.Block;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.function.FunctionMetadata;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.Signature;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.type.JsonType;
import io.trino.util.Failures;
import io.trino.util.JsonUtil;
import io.trino.util.Reflection;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.util.List;

public class ArrayToJsonCast
extends SqlScalarFunction {
    public static final ArrayToJsonCast ARRAY_TO_JSON = new ArrayToJsonCast();
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(ArrayToJsonCast.class, "toJson", JsonUtil.JsonGeneratorWriter.class, Block.class);

    private ArrayToJsonCast() {
        super(FunctionMetadata.scalarBuilder().signature(Signature.builder().operatorType(OperatorType.CAST).castableToTypeParameter("T", JsonType.JSON.getTypeSignature()).returnType((Type)JsonType.JSON).argumentType(TypeSignature.arrayType((TypeSignature)new TypeSignature("T", new TypeSignatureParameter[0]))).build()).build());
    }

    @Override
    protected SpecializedSqlScalarFunction specialize(BoundSignature boundSignature) {
        ArrayType arrayType = (ArrayType)boundSignature.getArgumentTypes().get(0);
        Failures.checkCondition(JsonUtil.canCastToJson((Type)arrayType), (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Cannot cast %s to JSON", arrayType);
        JsonUtil.JsonGeneratorWriter writer = JsonUtil.JsonGeneratorWriter.createJsonGeneratorWriter(arrayType.getElementType());
        MethodHandle methodHandle = METHOD_HANDLE.bindTo(writer);
        return new ChoicesSpecializedSqlScalarFunction(boundSignature, InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (List<InvocationConvention.InvocationArgumentConvention>)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL), methodHandle);
    }

    public static Slice toJson(JsonUtil.JsonGeneratorWriter writer, Block block) {
        try {
            DynamicSliceOutput output = new DynamicSliceOutput(40);
            try (JsonGenerator jsonGenerator = JsonUtil.createJsonGenerator(JsonOperators.JSON_FACTORY, (SliceOutput)output);){
                jsonGenerator.writeStartArray();
                for (int i = 0; i < block.getPositionCount(); ++i) {
                    writer.writeJsonValue(jsonGenerator, block, i);
                }
                jsonGenerator.writeEndArray();
            }
            return output.slice();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

