/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.security.jwt;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.Closer;
import io.airlift.concurrent.Threads;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.Request;
import io.airlift.http.client.ResponseHandler;
import io.airlift.http.client.StringResponseHandler;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import io.trino.server.security.jwt.JwkDecoder;
import java.io.IOException;
import java.net.URI;
import java.security.PublicKey;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;

public final class JwkService {
    private static final Logger log = Logger.get(JwkService.class);
    private final URI address;
    private final HttpClient httpClient;
    private final Duration refreshDelay;
    private final AtomicReference<Map<String, PublicKey>> keys;
    private Closer closer;

    public JwkService(URI address, HttpClient httpClient) {
        this(address, httpClient, new Duration(15.0, TimeUnit.MINUTES));
    }

    @VisibleForTesting
    public JwkService(URI address, HttpClient httpClient, Duration refreshDelay) {
        this.address = Objects.requireNonNull(address, "address is null");
        this.httpClient = Objects.requireNonNull(httpClient, "httpClient is null");
        this.refreshDelay = Objects.requireNonNull(refreshDelay, "refreshDelay is null");
        this.keys = new AtomicReference<Map<String, PublicKey>>(this.fetchKeys());
    }

    @PostConstruct
    public synchronized void start() {
        if (this.closer != null) {
            return;
        }
        this.closer = Closer.create();
        ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor(Threads.daemonThreadsNamed((String)"JWK loader"));
        this.closer.register(executorService::shutdownNow);
        ScheduledFuture<?> refreshJob = executorService.scheduleWithFixedDelay(() -> {
            try {
                this.refreshKeys();
            }
            catch (Exception e) {
                log.error((Throwable)e, "Error fetching JWK keys");
            }
        }, this.refreshDelay.toMillis(), this.refreshDelay.toMillis(), TimeUnit.MILLISECONDS);
        this.closer.register(() -> refreshJob.cancel(true));
    }

    @PreDestroy
    public synchronized void stop() {
        if (this.closer == null) {
            return;
        }
        try {
            this.closer.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Error stopping JWK service", e);
        }
        finally {
            this.closer = null;
        }
    }

    public Map<String, PublicKey> getKeys() {
        return this.keys.get();
    }

    public Optional<PublicKey> getKey(String keyId) {
        return Optional.ofNullable(this.keys.get().get(keyId));
    }

    public void refreshKeys() throws RuntimeException {
        this.keys.set(this.fetchKeys());
    }

    private Map<String, PublicKey> fetchKeys() throws RuntimeException {
        StringResponseHandler.StringResponse response;
        Request request = Request.Builder.prepareGet().setUri(this.address).build();
        try {
            response = (StringResponseHandler.StringResponse)this.httpClient.execute(request, (ResponseHandler)StringResponseHandler.createStringResponseHandler());
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Error reading JWK keys from " + this.address, e);
        }
        if (response.getStatusCode() != 200) {
            throw new RuntimeException("Unexpected response code " + response.getStatusCode() + " from JWK service at " + this.address);
        }
        try {
            return JwkDecoder.decodeKeys(response.getBody());
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Unable to decode JWK response from " + this.address, e);
        }
    }
}

