/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.gen;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.ImmutableList;
import io.airlift.bytecode.Access;
import io.airlift.bytecode.BytecodeBlock;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.ClassDefinition;
import io.airlift.bytecode.DynamicClassLoader;
import io.airlift.bytecode.FieldDefinition;
import io.airlift.bytecode.MethodDefinition;
import io.airlift.bytecode.OpCode;
import io.airlift.bytecode.Parameter;
import io.airlift.bytecode.ParameterizedType;
import io.airlift.bytecode.Scope;
import io.airlift.bytecode.Variable;
import io.airlift.bytecode.control.ForLoop;
import io.airlift.bytecode.control.IfStatement;
import io.airlift.bytecode.expression.BytecodeExpression;
import io.airlift.bytecode.expression.BytecodeExpressions;
import io.airlift.bytecode.instruction.LabelNode;
import io.airlift.jmx.CacheStatsMBean;
import io.airlift.slice.SizeOf;
import io.trino.Session;
import io.trino.collect.cache.NonEvictableLoadingCache;
import io.trino.collect.cache.SafeCaches;
import io.trino.operator.HashArraySizeSupplier;
import io.trino.operator.PagesHashStrategy;
import io.trino.operator.join.BigintPagesHash;
import io.trino.operator.join.DefaultPagesHash;
import io.trino.operator.join.JoinHash;
import io.trino.operator.join.JoinHashSupplier;
import io.trino.operator.join.JoinUtils;
import io.trino.operator.join.LookupSourceSupplier;
import io.trino.operator.join.PagesHash;
import io.trino.operator.join.unspilled.PartitionedLookupSource;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.sql.gen.Bootstrap;
import io.trino.sql.gen.CallSiteBinder;
import io.trino.sql.gen.CompilerOperations;
import io.trino.sql.gen.IsolatedClass;
import io.trino.sql.gen.JoinFilterFunctionCompiler;
import io.trino.sql.gen.SqlTypeBytecodeExpression;
import io.trino.util.CompilerUtils;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.IntStream;
import javax.inject.Inject;
import org.assertj.core.util.VisibleForTesting;
import org.openjdk.jol.info.ClassLayout;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class JoinCompiler {
    private final TypeOperators typeOperators;
    private final boolean enableSingleChannelBigintLookupSource;
    private final NonEvictableLoadingCache<CacheKey, LookupSourceSupplierFactory> lookupSourceFactories = SafeCaches.buildNonEvictableCache((CacheBuilder)CacheBuilder.newBuilder().recordStats().maximumSize(1000L), (CacheLoader)CacheLoader.from(key -> this.internalCompileLookupSourceFactory(key.getTypes(), key.getOutputChannels(), key.getJoinChannels(), key.getSortChannel())));
    private final NonEvictableLoadingCache<CacheKey, Class<? extends PagesHashStrategy>> hashStrategies = SafeCaches.buildNonEvictableCache((CacheBuilder)CacheBuilder.newBuilder().recordStats().maximumSize(1000L), (CacheLoader)CacheLoader.from(key -> this.internalCompileHashStrategy(key.getTypes(), key.getOutputChannels(), key.getJoinChannels(), key.getSortChannel())));

    @Inject
    public JoinCompiler(TypeOperators typeOperators) {
        this(typeOperators, true);
    }

    @VisibleForTesting
    public JoinCompiler(TypeOperators typeOperators, boolean enableSingleChannelBigintLookupSource) {
        this.typeOperators = Objects.requireNonNull(typeOperators, "typeOperators is null");
        this.enableSingleChannelBigintLookupSource = enableSingleChannelBigintLookupSource;
    }

    @Managed
    @Nested
    public CacheStatsMBean getLookupSourceStats() {
        return new CacheStatsMBean(this.lookupSourceFactories);
    }

    @Managed
    @Nested
    public CacheStatsMBean getHashStrategiesStats() {
        return new CacheStatsMBean(this.hashStrategies);
    }

    public LookupSourceSupplierFactory compileLookupSourceFactory(List<? extends Type> types, List<Integer> joinChannels, Optional<Integer> sortChannel, Optional<List<Integer>> outputChannels) {
        return (LookupSourceSupplierFactory)this.lookupSourceFactories.getUnchecked((Object)new CacheKey(types, outputChannels.orElseGet(() -> this.rangeList(types.size())), joinChannels, sortChannel));
    }

    public PagesHashStrategyFactory compilePagesHashStrategyFactory(List<Type> types, List<Integer> joinChannels) {
        return this.compilePagesHashStrategyFactory(types, joinChannels, Optional.empty());
    }

    public PagesHashStrategyFactory compilePagesHashStrategyFactory(List<Type> types, List<Integer> joinChannels, Optional<List<Integer>> outputChannels) {
        Objects.requireNonNull(types, "types is null");
        Objects.requireNonNull(joinChannels, "joinChannels is null");
        Objects.requireNonNull(outputChannels, "outputChannels is null");
        return new PagesHashStrategyFactory((Class)this.hashStrategies.getUnchecked((Object)new CacheKey(types, outputChannels.orElseGet(() -> this.rangeList(types.size())), joinChannels, Optional.empty())));
    }

    private List<Integer> rangeList(int endExclusive) {
        return (List)IntStream.range(0, endExclusive).boxed().collect(ImmutableList.toImmutableList());
    }

    private LookupSourceSupplierFactory internalCompileLookupSourceFactory(List<Type> types, List<Integer> outputChannels, List<Integer> joinChannels, Optional<Integer> sortChannel) {
        Class<? extends PagesHashStrategy> pagesHashStrategyClass = this.internalCompileHashStrategy(types, outputChannels, joinChannels, sortChannel);
        OptionalInt singleBigintJoinChannel = OptionalInt.empty();
        if (this.enableSingleChannelBigintLookupSource) {
            singleBigintJoinChannel = JoinUtils.getSingleBigintJoinChannel(joinChannels, types);
        }
        Class<JoinHashSupplier> joinHashSupplierClass = IsolatedClass.isolateClass(new DynamicClassLoader(this.getClass().getClassLoader()), LookupSourceSupplier.class, JoinHashSupplier.class, JoinHash.class, PagesHash.class, BigintPagesHash.class, DefaultPagesHash.class, PartitionedLookupSource.class);
        return new LookupSourceSupplierFactory(joinHashSupplierClass, new PagesHashStrategyFactory(pagesHashStrategyClass), singleBigintJoinChannel);
    }

    private static FieldDefinition generateInstanceSize(ClassDefinition definition) {
        FieldDefinition instanceSize = definition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE, Access.STATIC, Access.FINAL}), "INSTANCE_SIZE", Long.TYPE);
        definition.getClassInitializer().getBody().comment("INSTANCE_SIZE = ClassLayout.parseClass(%s.class).instanceSize()", new Object[]{definition.getName()}).append((BytecodeNode)BytecodeExpressions.setStatic((FieldDefinition)instanceSize, (BytecodeExpression)BytecodeExpressions.invokeStatic(ClassLayout.class, (String)"parseClass", ClassLayout.class, (BytecodeExpression[])new BytecodeExpression[]{BytecodeExpressions.constantClass((ParameterizedType)definition.getType())}).invoke("instanceSize", Long.TYPE, new BytecodeExpression[0])));
        return instanceSize;
    }

    private Class<? extends PagesHashStrategy> internalCompileHashStrategy(List<Type> types, List<Integer> outputChannels, List<Integer> joinChannels, Optional<Integer> sortChannel) {
        CallSiteBinder callSiteBinder = new CallSiteBinder();
        ClassDefinition classDefinition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL}), CompilerUtils.makeClassName("PagesHashStrategy"), ParameterizedType.type(Object.class), new ParameterizedType[]{ParameterizedType.type(PagesHashStrategy.class)});
        FieldDefinition instanceSizeField = JoinCompiler.generateInstanceSize(classDefinition);
        FieldDefinition sizeField = classDefinition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE, Access.FINAL}), "size", ParameterizedType.type(Long.TYPE));
        ArrayList<FieldDefinition> channelFields = new ArrayList<FieldDefinition>();
        for (int i = 0; i < types.size(); ++i) {
            FieldDefinition channelField = classDefinition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE, Access.FINAL}), "channel_" + i, ParameterizedType.type(List.class, (Class[])new Class[]{Block.class}));
            channelFields.add(channelField);
        }
        ArrayList<Type> joinChannelTypes = new ArrayList<Type>();
        ArrayList<FieldDefinition> joinChannelFields = new ArrayList<FieldDefinition>();
        for (int i = 0; i < joinChannels.size(); ++i) {
            joinChannelTypes.add(types.get(joinChannels.get(i)));
            FieldDefinition channelField = classDefinition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE, Access.FINAL}), "joinChannel_" + i, ParameterizedType.type(List.class, (Class[])new Class[]{Block.class}));
            joinChannelFields.add(channelField);
        }
        FieldDefinition hashChannelField = classDefinition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE, Access.FINAL}), "hashChannel", ParameterizedType.type(List.class, (Class[])new Class[]{Block.class}));
        JoinCompiler.generateConstructor(classDefinition, joinChannels, sizeField, instanceSizeField, channelFields, joinChannelFields, hashChannelField);
        JoinCompiler.generateGetChannelCountMethod(classDefinition, outputChannels.size());
        JoinCompiler.generateGetSizeInBytesMethod(classDefinition, sizeField);
        JoinCompiler.generateAppendToMethod(classDefinition, callSiteBinder, types, outputChannels, channelFields);
        this.generateHashPositionMethod(classDefinition, callSiteBinder, joinChannelTypes, joinChannelFields, hashChannelField);
        this.generateHashRowMethod(classDefinition, callSiteBinder, joinChannelTypes);
        this.generateRowEqualsRowMethod(classDefinition, callSiteBinder, joinChannelTypes);
        this.generateRowNotDistinctFromRowMethod(classDefinition, callSiteBinder, joinChannelTypes);
        this.generatePositionEqualsRowMethod(classDefinition, callSiteBinder, joinChannelTypes, joinChannelFields, true);
        this.generatePositionEqualsRowMethod(classDefinition, callSiteBinder, joinChannelTypes, joinChannelFields, false);
        this.generatePositionNotDistinctFromRowMethod(classDefinition, callSiteBinder, joinChannelTypes, joinChannelFields);
        this.generatePositionNotDistinctFromRowWithPageMethod(classDefinition, callSiteBinder, joinChannelTypes, joinChannelFields);
        this.generatePositionEqualsPositionMethod(classDefinition, callSiteBinder, joinChannelTypes, joinChannelFields, true);
        this.generatePositionEqualsPositionMethod(classDefinition, callSiteBinder, joinChannelTypes, joinChannelFields, false);
        this.generatePositionNotDistinctFromPositionMethod(classDefinition, callSiteBinder, joinChannelTypes, joinChannelFields);
        JoinCompiler.generateIsPositionNull(classDefinition, joinChannelFields);
        this.generateCompareSortChannelPositionsMethod(classDefinition, callSiteBinder, types, channelFields, sortChannel);
        JoinCompiler.generateIsSortChannelPositionNull(classDefinition, channelFields, sortChannel);
        return CompilerUtils.defineClass(classDefinition, PagesHashStrategy.class, callSiteBinder.getBindings(), this.getClass().getClassLoader());
    }

    private static void generateConstructor(ClassDefinition classDefinition, List<Integer> joinChannels, FieldDefinition sizeField, FieldDefinition instanceSizeField, List<FieldDefinition> channelFields, List<FieldDefinition> joinChannelFields, FieldDefinition hashChannelField) {
        int index;
        Parameter channels = Parameter.arg((String)"channels", (ParameterizedType)ParameterizedType.type(List.class, (ParameterizedType[])new ParameterizedType[]{ParameterizedType.type(List.class, (Class[])new Class[]{Block.class})}));
        Parameter hashChannel = Parameter.arg((String)"hashChannel", (ParameterizedType)ParameterizedType.type(OptionalInt.class));
        MethodDefinition constructorDefinition = classDefinition.declareConstructor(Access.a((Access[])new Access[]{Access.PUBLIC}), new Parameter[]{channels, hashChannel});
        Variable thisVariable = constructorDefinition.getThis();
        Variable blockIndex = constructorDefinition.getScope().declareVariable(Integer.TYPE, "blockIndex");
        BytecodeBlock constructor = constructorDefinition.getBody().comment("super();").append((BytecodeNode)thisVariable).invokeConstructor(Object.class, new Class[0]);
        constructor.comment("this.size = INSTANCE_SIZE").append((BytecodeNode)thisVariable.setField(sizeField, BytecodeExpressions.getStatic((FieldDefinition)instanceSizeField)));
        constructor.comment("Set channel fields");
        for (index = 0; index < channelFields.size(); ++index) {
            BytecodeExpression channel = channels.invoke("get", Object.class, new BytecodeExpression[]{BytecodeExpressions.constantInt((int)index)}).cast(ParameterizedType.type(ObjectArrayList.class, (Class[])new Class[]{Block.class}));
            constructor.append((BytecodeNode)thisVariable.setField(channelFields.get(index), channel));
            BytecodeBlock loopBody = new BytecodeBlock();
            constructor.comment("for(blockIndex = 0; blockIndex < channel.size(); blockIndex++) { size += channel.get(i).getRetainedSizeInBytes() }").append((BytecodeNode)new ForLoop().initialize((BytecodeNode)blockIndex.set(BytecodeExpressions.constantInt((int)0))).condition((BytecodeNode)new BytecodeBlock().append((BytecodeNode)blockIndex).append((BytecodeNode)channel.invoke("size", Integer.TYPE, new BytecodeExpression[0])).invokeStatic(CompilerOperations.class, "lessThan", Boolean.TYPE, new Class[]{Integer.TYPE, Integer.TYPE})).update((BytecodeNode)new BytecodeBlock().incrementVariable(blockIndex, (byte)1)).body((BytecodeNode)loopBody));
            loopBody.append((BytecodeNode)thisVariable).append((BytecodeNode)thisVariable).getField(sizeField).append((BytecodeNode)channel.invoke("get", Object.class, new BytecodeExpression[]{blockIndex}).cast(ParameterizedType.type(Block.class)).invoke("getRetainedSizeInBytes", Long.TYPE, new BytecodeExpression[0])).longAdd().putField(sizeField);
            constructor.append((BytecodeNode)thisVariable).append((BytecodeNode)thisVariable).getField(sizeField).append((BytecodeNode)BytecodeExpressions.invokeStatic(SizeOf.class, (String)"sizeOf", Long.TYPE, (BytecodeExpression[])new BytecodeExpression[]{channel.invoke("elements", Object[].class, new BytecodeExpression[0])})).longAdd().putField(sizeField);
        }
        constructor.comment("Set join channel fields");
        for (index = 0; index < joinChannelFields.size(); ++index) {
            BytecodeExpression joinChannel = channels.invoke("get", Object.class, new BytecodeExpression[]{BytecodeExpressions.constantInt((int)joinChannels.get(index))}).cast(ParameterizedType.type(List.class, (Class[])new Class[]{Block.class}));
            constructor.append((BytecodeNode)thisVariable.setField(joinChannelFields.get(index), joinChannel));
        }
        constructor.comment("Set hashChannel");
        constructor.append((BytecodeNode)new IfStatement().condition((BytecodeNode)hashChannel.invoke("isPresent", Boolean.TYPE, new BytecodeExpression[0])).ifTrue((BytecodeNode)thisVariable.setField(hashChannelField, channels.invoke("get", Object.class, new BytecodeExpression[]{hashChannel.invoke("getAsInt", Integer.TYPE, new BytecodeExpression[0])}))).ifFalse((BytecodeNode)thisVariable.setField(hashChannelField, BytecodeExpressions.constantNull((ParameterizedType)hashChannelField.getType()))));
        constructor.ret();
    }

    private static void generateGetChannelCountMethod(ClassDefinition classDefinition, int outputChannelCount) {
        classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "getChannelCount", ParameterizedType.type(Integer.TYPE), new Parameter[0]).getBody().push(outputChannelCount).retInt();
    }

    private static void generateGetSizeInBytesMethod(ClassDefinition classDefinition, FieldDefinition sizeField) {
        MethodDefinition getSizeInBytesMethod = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "getSizeInBytes", ParameterizedType.type(Long.TYPE), new Parameter[0]);
        Variable thisVariable = getSizeInBytesMethod.getThis();
        getSizeInBytesMethod.getBody().append((BytecodeNode)thisVariable.getField(sizeField)).retLong();
    }

    private static void generateAppendToMethod(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, List<Type> types, List<Integer> outputChannels, List<FieldDefinition> channelFields) {
        Parameter blockIndex = Parameter.arg((String)"blockIndex", Integer.TYPE);
        Parameter blockPosition = Parameter.arg((String)"blockPosition", Integer.TYPE);
        Parameter pageBuilder = Parameter.arg((String)"pageBuilder", PageBuilder.class);
        Parameter outputChannelOffset = Parameter.arg((String)"outputChannelOffset", Integer.TYPE);
        MethodDefinition appendToMethod = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "appendTo", ParameterizedType.type(Void.TYPE), new Parameter[]{blockIndex, blockPosition, pageBuilder, outputChannelOffset});
        Variable thisVariable = appendToMethod.getThis();
        BytecodeBlock appendToBody = appendToMethod.getBody();
        int pageBuilderOutputChannel = 0;
        for (int outputChannel : outputChannels) {
            Type type = types.get(outputChannel);
            SqlTypeBytecodeExpression typeExpression = SqlTypeBytecodeExpression.constantType(callSiteBinder, type);
            BytecodeExpression block = thisVariable.getField(channelFields.get(outputChannel)).invoke("get", Object.class, new BytecodeExpression[]{blockIndex}).cast(Block.class);
            appendToBody.comment("%s.appendTo(channel_%s.get(outputChannel), blockPosition, pageBuilder.getBlockBuilder(outputChannelOffset + %s));", new Object[]{type.getClass(), outputChannel, pageBuilderOutputChannel}).append((BytecodeNode)typeExpression).append((BytecodeNode)block).append((BytecodeNode)blockPosition).append((BytecodeNode)pageBuilder).append((BytecodeNode)outputChannelOffset).push(pageBuilderOutputChannel++).append((BytecodeNode)OpCode.IADD).invokeVirtual(PageBuilder.class, "getBlockBuilder", BlockBuilder.class, new Class[]{Integer.TYPE}).invokeInterface(Type.class, "appendTo", Void.TYPE, new Class[]{Block.class, Integer.TYPE, BlockBuilder.class});
        }
        appendToBody.ret();
    }

    private static void generateIsPositionNull(ClassDefinition classDefinition, List<FieldDefinition> joinChannelFields) {
        Parameter blockIndex = Parameter.arg((String)"blockIndex", Integer.TYPE);
        Parameter blockPosition = Parameter.arg((String)"blockPosition", Integer.TYPE);
        MethodDefinition isPositionNullMethod = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "isPositionNull", ParameterizedType.type(Boolean.TYPE), new Parameter[]{blockIndex, blockPosition});
        for (FieldDefinition joinChannelField : joinChannelFields) {
            BytecodeExpression block = isPositionNullMethod.getThis().getField(joinChannelField).invoke("get", Object.class, new BytecodeExpression[]{blockIndex}).cast(Block.class);
            IfStatement ifStatement = new IfStatement();
            ifStatement.condition((BytecodeNode)block.invoke("isNull", Boolean.TYPE, new BytecodeExpression[]{blockPosition}));
            ifStatement.ifTrue((BytecodeNode)BytecodeExpressions.constantTrue().ret());
            isPositionNullMethod.getBody().append((BytecodeNode)ifStatement);
        }
        isPositionNullMethod.getBody().append((BytecodeNode)BytecodeExpressions.constantFalse().ret());
    }

    private void generateHashPositionMethod(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, List<Type> joinChannelTypes, List<FieldDefinition> joinChannelFields, FieldDefinition hashChannelField) {
        Parameter blockIndex = Parameter.arg((String)"blockIndex", Integer.TYPE);
        Parameter blockPosition = Parameter.arg((String)"blockPosition", Integer.TYPE);
        MethodDefinition hashPositionMethod = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "hashPosition", ParameterizedType.type(Long.TYPE), new Parameter[]{blockIndex, blockPosition});
        Variable thisVariable = hashPositionMethod.getThis();
        BytecodeExpression hashChannel = thisVariable.getField(hashChannelField);
        SqlTypeBytecodeExpression bigintType = SqlTypeBytecodeExpression.constantType(callSiteBinder, (Type)BigintType.BIGINT);
        IfStatement ifStatement = new IfStatement();
        ifStatement.condition((BytecodeNode)BytecodeExpressions.notEqual((BytecodeExpression)hashChannel, (BytecodeExpression)BytecodeExpressions.constantNull((ParameterizedType)hashChannelField.getType())));
        ifStatement.ifTrue((BytecodeNode)bigintType.invoke("getLong", Long.TYPE, new BytecodeExpression[]{hashChannel.invoke("get", Object.class, new BytecodeExpression[]{blockIndex}).cast(Block.class), blockPosition}).ret());
        hashPositionMethod.getBody().append((BytecodeNode)ifStatement);
        Variable resultVariable = hashPositionMethod.getScope().declareVariable(Long.TYPE, "result");
        hashPositionMethod.getBody().push((Number)0L).putVariable(resultVariable);
        for (int index = 0; index < joinChannelTypes.size(); ++index) {
            Type type = joinChannelTypes.get(index);
            BytecodeExpression block = hashPositionMethod.getThis().getField(joinChannelFields.get(index)).invoke("get", Object.class, new BytecodeExpression[]{blockIndex}).cast(Block.class);
            hashPositionMethod.getBody().getVariable(resultVariable).push((Number)31L).append((BytecodeNode)OpCode.LMUL).append(this.typeHashCode(callSiteBinder, type, block, (BytecodeExpression)blockPosition)).append((BytecodeNode)OpCode.LADD).putVariable(resultVariable);
        }
        hashPositionMethod.getBody().getVariable(resultVariable).retLong();
    }

    private void generateHashRowMethod(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, List<Type> joinChannelTypes) {
        Parameter position = Parameter.arg((String)"position", Integer.TYPE);
        Parameter page = Parameter.arg((String)"blocks", Page.class);
        MethodDefinition hashRowMethod = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "hashRow", ParameterizedType.type(Long.TYPE), new Parameter[]{position, page});
        Variable resultVariable = hashRowMethod.getScope().declareVariable(Long.TYPE, "result");
        hashRowMethod.getBody().push((Number)0L).putVariable(resultVariable);
        for (int index = 0; index < joinChannelTypes.size(); ++index) {
            Type type = joinChannelTypes.get(index);
            BytecodeExpression block = page.invoke("getBlock", Block.class, new BytecodeExpression[]{BytecodeExpressions.constantInt((int)index)});
            hashRowMethod.getBody().getVariable(resultVariable).push((Number)31L).append((BytecodeNode)OpCode.LMUL).append(this.typeHashCode(callSiteBinder, type, block, (BytecodeExpression)position)).append((BytecodeNode)OpCode.LADD).putVariable(resultVariable);
        }
        hashRowMethod.getBody().getVariable(resultVariable).retLong();
    }

    private BytecodeNode typeHashCode(CallSiteBinder callSiteBinder, Type type, BytecodeExpression blockRef, BytecodeExpression blockPosition) {
        MethodHandle hashCodeOperator = this.typeOperators.getHashCodeOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}));
        return new IfStatement().condition((BytecodeNode)blockRef.invoke("isNull", Boolean.TYPE, new BytecodeExpression[]{blockPosition})).ifTrue((BytecodeNode)BytecodeExpressions.constantLong((long)0L)).ifFalse((BytecodeNode)BytecodeExpressions.invokeDynamic((Method)Bootstrap.BOOTSTRAP_METHOD, (Iterable)ImmutableList.of((Object)callSiteBinder.bind(hashCodeOperator).getBindingId()), (String)"hash", (MethodType)hashCodeOperator.type(), (BytecodeExpression[])new BytecodeExpression[]{blockRef, blockPosition}));
    }

    private void generateRowEqualsRowMethod(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, List<Type> joinChannelTypes) {
        Parameter leftPosition = Parameter.arg((String)"leftPosition", Integer.TYPE);
        Parameter leftPage = Parameter.arg((String)"leftPage", Page.class);
        Parameter rightPosition = Parameter.arg((String)"rightPosition", Integer.TYPE);
        Parameter rightPage = Parameter.arg((String)"rightPage", Page.class);
        MethodDefinition rowEqualsRowMethod = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "rowEqualsRow", ParameterizedType.type(Boolean.TYPE), new Parameter[]{leftPosition, leftPage, rightPosition, rightPage});
        for (int index = 0; index < joinChannelTypes.size(); ++index) {
            Type type = joinChannelTypes.get(index);
            BytecodeExpression leftBlock = leftPage.invoke("getBlock", Block.class, new BytecodeExpression[]{BytecodeExpressions.constantInt((int)index)});
            BytecodeExpression rightBlock = rightPage.invoke("getBlock", Block.class, new BytecodeExpression[]{BytecodeExpressions.constantInt((int)index)});
            LabelNode checkNextField = new LabelNode("checkNextField");
            rowEqualsRowMethod.getBody().append(this.typeEquals(callSiteBinder, type, leftBlock, (BytecodeExpression)leftPosition, rightBlock, (BytecodeExpression)rightPosition)).ifTrueGoto(checkNextField).push(false).retBoolean().visitLabel(checkNextField);
        }
        rowEqualsRowMethod.getBody().push(true).retInt();
    }

    private void generateRowNotDistinctFromRowMethod(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, List<Type> joinChannelTypes) {
        Parameter leftPosition = Parameter.arg((String)"leftPosition", Integer.TYPE);
        Parameter leftPage = Parameter.arg((String)"leftPage", Page.class);
        Parameter rightPosition = Parameter.arg((String)"rightPosition", Integer.TYPE);
        Parameter rightPage = Parameter.arg((String)"rightPage", Page.class);
        MethodDefinition rowNotDistinctFromRowMethod = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "rowNotDistinctFromRow", ParameterizedType.type(Boolean.TYPE), new Parameter[]{leftPosition, leftPage, rightPosition, rightPage});
        for (int index = 0; index < joinChannelTypes.size(); ++index) {
            Type type = joinChannelTypes.get(index);
            BytecodeExpression leftBlock = leftPage.invoke("getBlock", Block.class, new BytecodeExpression[]{BytecodeExpressions.constantInt((int)index)});
            BytecodeExpression rightBlock = rightPage.invoke("getBlock", Block.class, new BytecodeExpression[]{BytecodeExpressions.constantInt((int)index)});
            LabelNode checkNextField = new LabelNode("checkNextField");
            rowNotDistinctFromRowMethod.getBody().append(this.typeDistinctFrom(callSiteBinder, type, leftBlock, (BytecodeExpression)leftPosition, rightBlock, (BytecodeExpression)rightPosition)).ifFalseGoto(checkNextField).push(false).retBoolean().visitLabel(checkNextField);
        }
        rowNotDistinctFromRowMethod.getBody().push(true).retInt();
    }

    private void generatePositionEqualsRowMethod(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, List<Type> joinChannelTypes, List<FieldDefinition> joinChannelFields, boolean ignoreNulls) {
        Parameter leftBlockIndex = Parameter.arg((String)"leftBlockIndex", Integer.TYPE);
        Parameter leftBlockPosition = Parameter.arg((String)"leftBlockPosition", Integer.TYPE);
        Parameter rightPosition = Parameter.arg((String)"rightPosition", Integer.TYPE);
        Parameter rightPage = Parameter.arg((String)"rightPage", Page.class);
        MethodDefinition positionEqualsRowMethod = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), ignoreNulls ? "positionEqualsRowIgnoreNulls" : "positionEqualsRow", ParameterizedType.type(Boolean.TYPE), new Parameter[]{leftBlockIndex, leftBlockPosition, rightPosition, rightPage});
        Variable thisVariable = positionEqualsRowMethod.getThis();
        for (int index = 0; index < joinChannelTypes.size(); ++index) {
            Type type = joinChannelTypes.get(index);
            BytecodeExpression leftBlock = thisVariable.getField(joinChannelFields.get(index)).invoke("get", Object.class, new BytecodeExpression[]{leftBlockIndex}).cast(Block.class);
            BytecodeExpression rightBlock = rightPage.invoke("getBlock", Block.class, new BytecodeExpression[]{BytecodeExpressions.constantInt((int)index)});
            BytecodeNode equalityCondition = ignoreNulls ? this.typeEqualsIgnoreNulls(callSiteBinder, type, leftBlock, (BytecodeExpression)leftBlockPosition, rightBlock, (BytecodeExpression)rightPosition) : this.typeEquals(callSiteBinder, type, leftBlock, (BytecodeExpression)leftBlockPosition, rightBlock, (BytecodeExpression)rightPosition);
            LabelNode checkNextField = new LabelNode("checkNextField");
            positionEqualsRowMethod.getBody().append(equalityCondition).ifTrueGoto(checkNextField).push(false).retBoolean().visitLabel(checkNextField);
        }
        positionEqualsRowMethod.getBody().push(true).retInt();
    }

    private void generatePositionNotDistinctFromRowMethod(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, List<Type> joinChannelTypes, List<FieldDefinition> joinChannelFields) {
        Parameter leftBlockIndex = Parameter.arg((String)"leftBlockIndex", Integer.TYPE);
        Parameter leftBlockPosition = Parameter.arg((String)"leftBlockPosition", Integer.TYPE);
        Parameter rightPosition = Parameter.arg((String)"rightPosition", Integer.TYPE);
        Parameter rightPage = Parameter.arg((String)"rightPage", Page.class);
        MethodDefinition positionNotDistinctFromRowPosition = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "positionNotDistinctFromRow", ParameterizedType.type(Boolean.TYPE), new Parameter[]{leftBlockIndex, leftBlockPosition, rightPosition, rightPage});
        Variable thisVariable = positionNotDistinctFromRowPosition.getThis();
        for (int index = 0; index < joinChannelTypes.size(); ++index) {
            Type type = joinChannelTypes.get(index);
            BytecodeExpression leftBlock = thisVariable.getField(joinChannelFields.get(index)).invoke("get", Object.class, new BytecodeExpression[]{leftBlockIndex}).cast(Block.class);
            BytecodeExpression rightBlock = rightPage.invoke("getBlock", Block.class, new BytecodeExpression[]{BytecodeExpressions.constantInt((int)index)});
            LabelNode checkNextField = new LabelNode("checkNextField");
            positionNotDistinctFromRowPosition.getBody().append(this.typeDistinctFrom(callSiteBinder, type, leftBlock, (BytecodeExpression)leftBlockPosition, rightBlock, (BytecodeExpression)rightPosition)).ifFalseGoto(checkNextField).push(false).retBoolean().visitLabel(checkNextField);
        }
        positionNotDistinctFromRowPosition.getBody().push(true).retInt();
    }

    private void generatePositionNotDistinctFromRowWithPageMethod(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, List<Type> joinChannelTypes, List<FieldDefinition> joinChannelFields) {
        Parameter leftBlockIndex = Parameter.arg((String)"leftBlockIndex", Integer.TYPE);
        Parameter leftBlockPosition = Parameter.arg((String)"leftBlockPosition", Integer.TYPE);
        Parameter rightPosition = Parameter.arg((String)"rightPosition", Integer.TYPE);
        Parameter page = Parameter.arg((String)"page", Page.class);
        Parameter rightChannels = Parameter.arg((String)"rightChannels", int[].class);
        MethodDefinition positionNotDistinctFromRowMethod = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "positionNotDistinctFromRow", ParameterizedType.type(Boolean.TYPE), new Parameter[]{leftBlockIndex, leftBlockPosition, rightPosition, page, rightChannels});
        Variable thisVariable = positionNotDistinctFromRowMethod.getThis();
        Scope scope = positionNotDistinctFromRowMethod.getScope();
        BytecodeBlock body = positionNotDistinctFromRowMethod.getBody();
        scope.declareVariable("wasNull", body, BytecodeExpressions.constantFalse());
        for (int index = 0; index < joinChannelTypes.size(); ++index) {
            BytecodeExpression leftBlock = thisVariable.getField(joinChannelFields.get(index)).invoke("get", Object.class, new BytecodeExpression[]{leftBlockIndex}).cast(Block.class);
            BytecodeExpression rightBlock = page.invoke("getBlock", Block.class, new BytecodeExpression[]{rightChannels.getElement(index)});
            Type type = joinChannelTypes.get(index);
            body.append((BytecodeNode)new IfStatement().condition(this.typeDistinctFrom(callSiteBinder, type, leftBlock, (BytecodeExpression)leftBlockPosition, rightBlock, (BytecodeExpression)rightPosition)).ifTrue((BytecodeNode)BytecodeExpressions.constantFalse().ret()));
        }
        body.append((BytecodeNode)BytecodeExpressions.constantTrue().ret());
    }

    private BytecodeNode typeDistinctFrom(CallSiteBinder callSiteBinder, Type type, BytecodeExpression leftBlock, BytecodeExpression leftBlockPosition, BytecodeExpression rightBlock, BytecodeExpression rightBlockPosition) {
        return new IfStatement().condition((BytecodeNode)BytecodeExpressions.or((BytecodeExpression)leftBlock.invoke("isNull", Boolean.TYPE, new BytecodeExpression[]{leftBlockPosition}), (BytecodeExpression)rightBlock.invoke("isNull", Boolean.TYPE, new BytecodeExpression[]{rightBlockPosition}))).ifTrue((BytecodeNode)BytecodeExpressions.not((BytecodeExpression)BytecodeExpressions.and((BytecodeExpression)leftBlock.invoke("isNull", Boolean.TYPE, new BytecodeExpression[]{leftBlockPosition}), (BytecodeExpression)rightBlock.invoke("isNull", Boolean.TYPE, new BytecodeExpression[]{rightBlockPosition})))).ifFalse((BytecodeNode)this.typeDistinctFromIgnoreNulls(callSiteBinder, type, leftBlock, leftBlockPosition, rightBlock, rightBlockPosition));
    }

    private BytecodeExpression typeDistinctFromIgnoreNulls(CallSiteBinder callSiteBinder, Type type, BytecodeExpression leftBlock, BytecodeExpression leftBlockPosition, BytecodeExpression rightBlock, BytecodeExpression rightBlockPosition) {
        MethodHandle distinctFromOperator = this.typeOperators.getDistinctFromOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}));
        return BytecodeExpressions.invokeDynamic((Method)Bootstrap.BOOTSTRAP_METHOD, (Iterable)ImmutableList.of((Object)callSiteBinder.bind(distinctFromOperator).getBindingId()), (String)"distinctFrom", (MethodType)distinctFromOperator.type(), (BytecodeExpression[])new BytecodeExpression[]{leftBlock, leftBlockPosition, rightBlock, rightBlockPosition});
    }

    private void generatePositionEqualsPositionMethod(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, List<Type> joinChannelTypes, List<FieldDefinition> joinChannelFields, boolean ignoreNulls) {
        Parameter leftBlockIndex = Parameter.arg((String)"leftBlockIndex", Integer.TYPE);
        Parameter leftBlockPosition = Parameter.arg((String)"leftBlockPosition", Integer.TYPE);
        Parameter rightBlockIndex = Parameter.arg((String)"rightBlockIndex", Integer.TYPE);
        Parameter rightBlockPosition = Parameter.arg((String)"rightBlockPosition", Integer.TYPE);
        MethodDefinition positionEqualsPositionMethod = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), ignoreNulls ? "positionEqualsPositionIgnoreNulls" : "positionEqualsPosition", ParameterizedType.type(Boolean.TYPE), new Parameter[]{leftBlockIndex, leftBlockPosition, rightBlockIndex, rightBlockPosition});
        Variable thisVariable = positionEqualsPositionMethod.getThis();
        for (int index = 0; index < joinChannelTypes.size(); ++index) {
            Type type = joinChannelTypes.get(index);
            BytecodeExpression leftBlock = thisVariable.getField(joinChannelFields.get(index)).invoke("get", Object.class, new BytecodeExpression[]{leftBlockIndex}).cast(Block.class);
            BytecodeExpression rightBlock = thisVariable.getField(joinChannelFields.get(index)).invoke("get", Object.class, new BytecodeExpression[]{rightBlockIndex}).cast(Block.class);
            BytecodeNode equalityCondition = ignoreNulls ? this.typeEqualsIgnoreNulls(callSiteBinder, type, leftBlock, (BytecodeExpression)leftBlockPosition, rightBlock, (BytecodeExpression)rightBlockPosition) : this.typeEquals(callSiteBinder, type, leftBlock, (BytecodeExpression)leftBlockPosition, rightBlock, (BytecodeExpression)rightBlockPosition);
            LabelNode checkNextField = new LabelNode("checkNextField");
            positionEqualsPositionMethod.getBody().append(equalityCondition).ifTrueGoto(checkNextField).push(false).retBoolean().visitLabel(checkNextField);
        }
        positionEqualsPositionMethod.getBody().push(true).retInt();
    }

    private void generatePositionNotDistinctFromPositionMethod(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, List<Type> joinChannelTypes, List<FieldDefinition> joinChannelFields) {
        Parameter leftBlockIndex = Parameter.arg((String)"leftBlockIndex", Integer.TYPE);
        Parameter leftBlockPosition = Parameter.arg((String)"leftBlockPosition", Integer.TYPE);
        Parameter rightBlockIndex = Parameter.arg((String)"rightBlockIndex", Integer.TYPE);
        Parameter rightBlockPosition = Parameter.arg((String)"rightBlockPosition", Integer.TYPE);
        MethodDefinition positionNotDistinctFromPositionMethod = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "positionNotDistinctFromPosition", ParameterizedType.type(Boolean.TYPE), new Parameter[]{leftBlockIndex, leftBlockPosition, rightBlockIndex, rightBlockPosition});
        Variable thisVariable = positionNotDistinctFromPositionMethod.getThis();
        for (int index = 0; index < joinChannelTypes.size(); ++index) {
            Type type = joinChannelTypes.get(index);
            BytecodeExpression leftBlock = thisVariable.getField(joinChannelFields.get(index)).invoke("get", Object.class, new BytecodeExpression[]{leftBlockIndex}).cast(Block.class);
            BytecodeExpression rightBlock = thisVariable.getField(joinChannelFields.get(index)).invoke("get", Object.class, new BytecodeExpression[]{rightBlockIndex}).cast(Block.class);
            LabelNode checkNextField = new LabelNode("checkNextField");
            positionNotDistinctFromPositionMethod.getBody().append(this.typeDistinctFrom(callSiteBinder, type, leftBlock, (BytecodeExpression)leftBlockPosition, rightBlock, (BytecodeExpression)rightBlockPosition)).ifFalseGoto(checkNextField).push(false).retBoolean().visitLabel(checkNextField);
        }
        positionNotDistinctFromPositionMethod.getBody().push(true).retInt();
    }

    private void generateCompareSortChannelPositionsMethod(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, List<Type> types, List<FieldDefinition> channelFields, Optional<Integer> sortChannel) {
        Parameter leftBlockIndex = Parameter.arg((String)"leftBlockIndex", Integer.TYPE);
        Parameter leftBlockPosition = Parameter.arg((String)"leftBlockPosition", Integer.TYPE);
        Parameter rightBlockIndex = Parameter.arg((String)"rightBlockIndex", Integer.TYPE);
        Parameter rightBlockPosition = Parameter.arg((String)"rightBlockPosition", Integer.TYPE);
        MethodDefinition compareMethod = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "compareSortChannelPositions", ParameterizedType.type(Integer.TYPE), new Parameter[]{leftBlockIndex, leftBlockPosition, rightBlockIndex, rightBlockPosition});
        if (sortChannel.isEmpty()) {
            compareMethod.getBody().append((BytecodeNode)BytecodeExpressions.newInstance(UnsupportedOperationException.class, (BytecodeExpression[])new BytecodeExpression[0])).throwObject();
            return;
        }
        Variable thisVariable = compareMethod.getThis();
        int index = sortChannel.get();
        BytecodeExpression leftBlock = thisVariable.getField(channelFields.get(index)).invoke("get", Object.class, new BytecodeExpression[]{leftBlockIndex}).cast(Block.class);
        BytecodeExpression rightBlock = thisVariable.getField(channelFields.get(index)).invoke("get", Object.class, new BytecodeExpression[]{rightBlockIndex}).cast(Block.class);
        MethodHandle comparisonOperator = this.typeOperators.getComparisonUnorderedLastOperator(types.get(index), InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}));
        BytecodeExpression comparison = BytecodeExpressions.invokeDynamic((Method)Bootstrap.BOOTSTRAP_METHOD, (Iterable)ImmutableList.of((Object)callSiteBinder.bind(comparisonOperator).getBindingId()), (String)"comparison", Long.TYPE, (BytecodeExpression[])new BytecodeExpression[]{leftBlock, leftBlockPosition, rightBlock, rightBlockPosition}).cast(Integer.TYPE).ret();
        compareMethod.getBody().append((BytecodeNode)comparison);
    }

    private static void generateIsSortChannelPositionNull(ClassDefinition classDefinition, List<FieldDefinition> channelFields, Optional<Integer> sortChannel) {
        Parameter blockIndex = Parameter.arg((String)"blockIndex", Integer.TYPE);
        Parameter blockPosition = Parameter.arg((String)"blockPosition", Integer.TYPE);
        MethodDefinition isSortChannelPositionNullMethod = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "isSortChannelPositionNull", ParameterizedType.type(Boolean.TYPE), new Parameter[]{blockIndex, blockPosition});
        if (sortChannel.isEmpty()) {
            isSortChannelPositionNullMethod.getBody().append((BytecodeNode)BytecodeExpressions.newInstance(UnsupportedOperationException.class, (BytecodeExpression[])new BytecodeExpression[0])).throwObject();
            return;
        }
        Variable thisVariable = isSortChannelPositionNullMethod.getThis();
        int index = sortChannel.get();
        BytecodeExpression block = thisVariable.getField(channelFields.get(index)).invoke("get", Object.class, new BytecodeExpression[]{blockIndex}).cast(Block.class);
        BytecodeExpression isNull = block.invoke("isNull", Boolean.TYPE, new BytecodeExpression[]{blockPosition}).ret();
        isSortChannelPositionNullMethod.getBody().append((BytecodeNode)isNull);
    }

    private BytecodeNode typeEquals(CallSiteBinder callSiteBinder, Type type, BytecodeExpression leftBlock, BytecodeExpression leftBlockPosition, BytecodeExpression rightBlock, BytecodeExpression rightBlockPosition) {
        IfStatement ifStatement = new IfStatement();
        ifStatement.condition().append((BytecodeNode)leftBlock.invoke("isNull", Boolean.TYPE, new BytecodeExpression[]{leftBlockPosition})).append((BytecodeNode)rightBlock.invoke("isNull", Boolean.TYPE, new BytecodeExpression[]{rightBlockPosition})).append((BytecodeNode)OpCode.IOR);
        ifStatement.ifTrue().append((BytecodeNode)leftBlock.invoke("isNull", Boolean.TYPE, new BytecodeExpression[]{leftBlockPosition})).append((BytecodeNode)rightBlock.invoke("isNull", Boolean.TYPE, new BytecodeExpression[]{rightBlockPosition})).append((BytecodeNode)OpCode.IAND);
        ifStatement.ifFalse().append(this.typeEqualsIgnoreNulls(callSiteBinder, type, leftBlock, leftBlockPosition, rightBlock, rightBlockPosition));
        return ifStatement;
    }

    private BytecodeNode typeEqualsIgnoreNulls(CallSiteBinder callSiteBinder, Type type, BytecodeExpression leftBlock, BytecodeExpression leftBlockPosition, BytecodeExpression rightBlock, BytecodeExpression rightBlockPosition) {
        MethodHandle equalOperator = this.typeOperators.getEqualOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}));
        BytecodeExpression equalInvocation = BytecodeExpressions.invokeDynamic((Method)Bootstrap.BOOTSTRAP_METHOD, (Iterable)ImmutableList.of((Object)callSiteBinder.bind(equalOperator).getBindingId()), (String)"equal", (MethodType)equalOperator.type(), (BytecodeExpression[])new BytecodeExpression[]{leftBlock, leftBlockPosition, rightBlock, rightBlockPosition});
        return BytecodeExpressions.equal((BytecodeExpression)equalInvocation, (BytecodeExpression)BytecodeExpressions.getStatic(Boolean.class, (String)"TRUE"));
    }

    private static final class CacheKey {
        private final List<Type> types;
        private final List<Integer> outputChannels;
        private final List<Integer> joinChannels;
        private final Optional<Integer> sortChannel;

        private CacheKey(List<? extends Type> types, List<Integer> outputChannels, List<Integer> joinChannels, Optional<Integer> sortChannel) {
            this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
            this.outputChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(outputChannels, "outputChannels is null"));
            this.joinChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(joinChannels, "joinChannels is null"));
            this.sortChannel = Objects.requireNonNull(sortChannel, "sortChannel is null");
        }

        private List<Type> getTypes() {
            return this.types;
        }

        private List<Integer> getOutputChannels() {
            return this.outputChannels;
        }

        private List<Integer> getJoinChannels() {
            return this.joinChannels;
        }

        private Optional<Integer> getSortChannel() {
            return this.sortChannel;
        }

        public int hashCode() {
            return Objects.hash(this.types, this.outputChannels, this.joinChannels, this.sortChannel);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            return Objects.equals(this.types, other.types) && Objects.equals(this.outputChannels, other.outputChannels) && Objects.equals(this.joinChannels, other.joinChannels) && Objects.equals(this.sortChannel, other.sortChannel);
        }
    }

    public static class LookupSourceSupplierFactory {
        private final Constructor<? extends LookupSourceSupplier> constructor;
        private final PagesHashStrategyFactory pagesHashStrategyFactory;
        private final OptionalInt singleBigintJoinChannel;

        public LookupSourceSupplierFactory(Class<? extends LookupSourceSupplier> joinHashSupplierClass, PagesHashStrategyFactory pagesHashStrategyFactory, OptionalInt singleBigintJoinChannel) {
            this.pagesHashStrategyFactory = pagesHashStrategyFactory;
            try {
                this.constructor = joinHashSupplierClass.getConstructor(Session.class, PagesHashStrategy.class, LongArrayList.class, List.class, Optional.class, Optional.class, List.class, HashArraySizeSupplier.class, OptionalInt.class);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            this.singleBigintJoinChannel = Objects.requireNonNull(singleBigintJoinChannel, "singleBigintJoinChannel is null");
        }

        public LookupSourceSupplier createLookupSourceSupplier(Session session, LongArrayList addresses, List<ObjectArrayList<Block>> channels, OptionalInt hashChannel, Optional<JoinFilterFunctionCompiler.JoinFilterFunctionFactory> filterFunctionFactory, Optional<Integer> sortChannel, List<JoinFilterFunctionCompiler.JoinFilterFunctionFactory> searchFunctionFactories, HashArraySizeSupplier hashArraySizeSupplier) {
            PagesHashStrategy pagesHashStrategy = this.pagesHashStrategyFactory.createPagesHashStrategy(channels, hashChannel);
            try {
                return this.constructor.newInstance(session, pagesHashStrategy, addresses, channels, filterFunctionFactory, sortChannel, searchFunctionFactories, hashArraySizeSupplier, this.singleBigintJoinChannel);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class PagesHashStrategyFactory {
        private final Constructor<? extends PagesHashStrategy> constructor;

        public PagesHashStrategyFactory(Class<? extends PagesHashStrategy> pagesHashStrategyClass) {
            try {
                this.constructor = pagesHashStrategyClass.getConstructor(List.class, OptionalInt.class);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }

        public PagesHashStrategy createPagesHashStrategy(List<ObjectArrayList<Block>> channels, OptionalInt hashChannel) {
            try {
                return this.constructor.newInstance(channels, hashChannel);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

