/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.connector.CatalogServiceProvider;
import io.trino.execution.scheduler.BucketNodeMap;
import io.trino.execution.scheduler.NodeScheduler;
import io.trino.execution.scheduler.NodeSelector;
import io.trino.metadata.InternalNode;
import io.trino.metadata.Split;
import io.trino.operator.BucketPartitionFunction;
import io.trino.operator.PartitionFunction;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.connector.BucketFunction;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.ConnectorBucketNodeMap;
import io.trino.spi.connector.ConnectorNodePartitioningProvider;
import io.trino.spi.connector.ConnectorPartitioningHandle;
import io.trino.spi.type.Type;
import io.trino.split.EmptySplit;
import io.trino.sql.planner.MergePartitioningHandle;
import io.trino.sql.planner.NodePartitionMap;
import io.trino.sql.planner.PartitioningHandle;
import io.trino.sql.planner.PartitioningScheme;
import io.trino.sql.planner.SystemPartitioningHandle;
import io.trino.type.BlockTypeOperators;
import io.trino.util.Failures;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.ToIntFunction;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.inject.Inject;

public class NodePartitioningManager {
    private final NodeScheduler nodeScheduler;
    private final BlockTypeOperators blockTypeOperators;
    private final CatalogServiceProvider<ConnectorNodePartitioningProvider> partitioningProvider;

    @Inject
    public NodePartitioningManager(NodeScheduler nodeScheduler, BlockTypeOperators blockTypeOperators, CatalogServiceProvider<ConnectorNodePartitioningProvider> partitioningProvider) {
        this.nodeScheduler = Objects.requireNonNull(nodeScheduler, "nodeScheduler is null");
        this.blockTypeOperators = Objects.requireNonNull(blockTypeOperators, "blockTypeOperators is null");
        this.partitioningProvider = Objects.requireNonNull(partitioningProvider, "partitioningProvider is null");
    }

    public PartitionFunction getPartitionFunction(Session session, PartitioningScheme partitioningScheme, List<Type> partitionChannelTypes) {
        int[] bucketToPartition = partitioningScheme.getBucketToPartition().orElseThrow(() -> new IllegalArgumentException("Bucket to partition must be set before a partition function can be created"));
        PartitioningHandle partitioningHandle = partitioningScheme.getPartitioning().getHandle();
        if (partitioningHandle.getConnectorHandle() instanceof SystemPartitioningHandle) {
            return ((SystemPartitioningHandle)partitioningHandle.getConnectorHandle()).getPartitionFunction(partitionChannelTypes, partitioningScheme.getHashColumn().isPresent(), bucketToPartition, this.blockTypeOperators);
        }
        ConnectorPartitioningHandle connectorPartitioningHandle = partitioningHandle.getConnectorHandle();
        if (connectorPartitioningHandle instanceof MergePartitioningHandle) {
            MergePartitioningHandle handle = (MergePartitioningHandle)connectorPartitioningHandle;
            return handle.getPartitionFunction((PartitioningScheme scheme, List<Type> types) -> this.getPartitionFunction(session, scheme, types, bucketToPartition), partitionChannelTypes, bucketToPartition);
        }
        return this.getPartitionFunction(session, partitioningScheme, partitionChannelTypes, bucketToPartition);
    }

    public PartitionFunction getPartitionFunction(Session session, PartitioningScheme partitioningScheme, List<Type> partitionChannelTypes, int[] bucketToPartition) {
        PartitioningHandle partitioningHandle = partitioningScheme.getPartitioning().getHandle();
        ConnectorPartitioningHandle connectorPartitioningHandle = partitioningHandle.getConnectorHandle();
        if (connectorPartitioningHandle instanceof SystemPartitioningHandle) {
            SystemPartitioningHandle handle = (SystemPartitioningHandle)connectorPartitioningHandle;
            return handle.getPartitionFunction(partitionChannelTypes, partitioningScheme.getHashColumn().isPresent(), bucketToPartition, this.blockTypeOperators);
        }
        BucketFunction bucketFunction = this.getBucketFunction(session, partitioningHandle, partitionChannelTypes, bucketToPartition.length);
        return new BucketPartitionFunction(bucketFunction, bucketToPartition);
    }

    public BucketFunction getBucketFunction(Session session, PartitioningHandle partitioningHandle, List<Type> partitionChannelTypes, int bucketCount) {
        CatalogHandle catalogHandle = NodePartitioningManager.requiredCatalogHandle(partitioningHandle);
        ConnectorNodePartitioningProvider partitioningProvider = this.getPartitioningProvider(catalogHandle);
        BucketFunction bucketFunction = partitioningProvider.getBucketFunction(partitioningHandle.getTransactionHandle().orElseThrow(), session.toConnectorSession(), partitioningHandle.getConnectorHandle(), partitionChannelTypes, bucketCount);
        Preconditions.checkArgument((bucketFunction != null ? 1 : 0) != 0, (String)"No bucket function for partitioning: %s", (Object)partitioningHandle);
        return bucketFunction;
    }

    public NodePartitionMap getNodePartitioningMap(Session session, PartitioningHandle partitioningHandle) {
        return this.getNodePartitioningMap(session, partitioningHandle, new HashMap<Integer, List<InternalNode>>(), new AtomicReference<List<InternalNode>>());
    }

    private NodePartitionMap getNodePartitioningMap(Session session, PartitioningHandle partitioningHandle, Map<Integer, List<InternalNode>> bucketToNodeCache, AtomicReference<List<InternalNode>> systemPartitioningCache) {
        List bucketToNode;
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(partitioningHandle, "partitioningHandle is null");
        if (partitioningHandle.getConnectorHandle() instanceof SystemPartitioningHandle) {
            return this.systemNodePartitionMap(session, partitioningHandle, systemPartitioningCache);
        }
        ConnectorPartitioningHandle connectorPartitioningHandle = partitioningHandle.getConnectorHandle();
        if (connectorPartitioningHandle instanceof MergePartitioningHandle) {
            MergePartitioningHandle mergeHandle = (MergePartitioningHandle)connectorPartitioningHandle;
            return mergeHandle.getNodePartitioningMap(handle -> this.getNodePartitioningMap(session, (PartitioningHandle)handle, bucketToNodeCache, systemPartitioningCache));
        }
        Optional<ConnectorBucketNodeMap> optionalMap = this.getConnectorBucketNodeMap(session, partitioningHandle);
        if (optionalMap.isEmpty()) {
            return this.systemNodePartitionMap(session, SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION, systemPartitioningCache);
        }
        ConnectorBucketNodeMap connectorBucketNodeMap = optionalMap.get();
        Preconditions.checkArgument((connectorBucketNodeMap.getBucketCount() < 1000000 ? 1 : 0) != 0, (String)"Too many buckets in partitioning: %s", (int)connectorBucketNodeMap.getBucketCount());
        if (connectorBucketNodeMap.hasFixedMapping()) {
            bucketToNode = NodePartitioningManager.getFixedMapping(connectorBucketNodeMap);
        } else {
            CatalogHandle catalogHandle = NodePartitioningManager.requiredCatalogHandle(partitioningHandle);
            bucketToNode = bucketToNodeCache.computeIfAbsent(connectorBucketNodeMap.getBucketCount(), bucketCount -> NodePartitioningManager.createArbitraryBucketToNode(this.getAllNodes(session, catalogHandle), bucketCount));
        }
        int[] bucketToPartition = new int[connectorBucketNodeMap.getBucketCount()];
        HashBiMap nodeToPartition = HashBiMap.create();
        int nextPartitionId = 0;
        for (int bucket = 0; bucket < bucketToNode.size(); ++bucket) {
            InternalNode node = (InternalNode)bucketToNode.get(bucket);
            Integer partitionId = (Integer)nodeToPartition.get((Object)node);
            if (partitionId == null) {
                partitionId = nextPartitionId;
                ++nextPartitionId;
                nodeToPartition.put((Object)node, (Object)partitionId);
            }
            bucketToPartition[bucket] = partitionId;
        }
        List partitionToNode = (List)IntStream.range(0, nodeToPartition.size()).mapToObj(arg_0 -> NodePartitioningManager.lambda$getNodePartitioningMap$4((BiMap)nodeToPartition, arg_0)).collect(ImmutableList.toImmutableList());
        return new NodePartitionMap(partitionToNode, bucketToPartition, this.getSplitToBucket(session, partitioningHandle));
    }

    private NodePartitionMap systemNodePartitionMap(Session session, PartitioningHandle partitioningHandle, AtomicReference<List<InternalNode>> nodesCache) {
        SystemPartitioningHandle.SystemPartitioning partitioning = ((SystemPartitioningHandle)partitioningHandle.getConnectorHandle()).getPartitioning();
        NodeSelector nodeSelector = this.nodeScheduler.createNodeSelector(session, Optional.empty());
        Object nodes = switch (partitioning) {
            case SystemPartitioningHandle.SystemPartitioning.COORDINATOR_ONLY -> ImmutableList.of((Object)nodeSelector.selectCurrentNode());
            case SystemPartitioningHandle.SystemPartitioning.SINGLE -> nodeSelector.selectRandomNodes(1);
            case SystemPartitioningHandle.SystemPartitioning.FIXED -> {
                List<InternalNode> value = nodesCache.get();
                if (value == null) {
                    value = nodeSelector.selectRandomNodes(SystemSessionProperties.getHashPartitionCount(session));
                    nodesCache.set(value);
                }
                yield value;
            }
            default -> throw new IllegalArgumentException("Unsupported plan distribution " + partitioning);
        };
        Failures.checkCondition(!nodes.isEmpty(), (ErrorCodeSupplier)StandardErrorCode.NO_NODES_AVAILABLE, "No worker nodes available", new Object[0]);
        return new NodePartitionMap((List<InternalNode>)nodes, split -> {
            throw new UnsupportedOperationException("System distribution does not support source splits");
        });
    }

    public BucketNodeMap getBucketNodeMap(Session session, PartitioningHandle partitioningHandle) {
        Optional<ConnectorBucketNodeMap> bucketNodeMap = this.getConnectorBucketNodeMap(session, partitioningHandle);
        ToIntFunction<Split> splitToBucket = this.getSplitToBucket(session, partitioningHandle);
        if (bucketNodeMap.map(ConnectorBucketNodeMap::hasFixedMapping).orElse(false).booleanValue()) {
            return new BucketNodeMap(splitToBucket, NodePartitioningManager.getFixedMapping(bucketNodeMap.get()));
        }
        List<InternalNode> nodes = this.getAllNodes(session, NodePartitioningManager.requiredCatalogHandle(partitioningHandle));
        int bucketCount = bucketNodeMap.map(ConnectorBucketNodeMap::getBucketCount).orElseGet(nodes::size);
        return new BucketNodeMap(splitToBucket, NodePartitioningManager.createArbitraryBucketToNode(nodes, bucketCount));
    }

    public int getBucketCount(Session session, PartitioningHandle partitioning) {
        if (partitioning.getConnectorHandle() instanceof MergePartitioningHandle) {
            return this.getNodePartitioningMap(session, partitioning).getBucketToPartition().length;
        }
        return this.getBucketNodeMap(session, partitioning).getBucketCount();
    }

    public int getNodeCount(Session session, PartitioningHandle partitioningHandle) {
        return this.getAllNodes(session, NodePartitioningManager.requiredCatalogHandle(partitioningHandle)).size();
    }

    private List<InternalNode> getAllNodes(Session session, CatalogHandle catalogHandle) {
        return this.nodeScheduler.createNodeSelector(session, Optional.of(catalogHandle)).allNodes();
    }

    private static List<InternalNode> getFixedMapping(ConnectorBucketNodeMap connectorBucketNodeMap) {
        return (List)connectorBucketNodeMap.getFixedMapping().stream().map(InternalNode.class::cast).collect(ImmutableList.toImmutableList());
    }

    public Optional<ConnectorBucketNodeMap> getConnectorBucketNodeMap(Session session, PartitioningHandle partitioningHandle) {
        CatalogHandle catalogHandle = NodePartitioningManager.requiredCatalogHandle(partitioningHandle);
        ConnectorNodePartitioningProvider partitioningProvider = this.getPartitioningProvider(catalogHandle);
        return partitioningProvider.getBucketNodeMapping(partitioningHandle.getTransactionHandle().orElseThrow(), session.toConnectorSession(catalogHandle), partitioningHandle.getConnectorHandle());
    }

    public ToIntFunction<Split> getSplitToBucket(Session session, PartitioningHandle partitioningHandle) {
        CatalogHandle catalogHandle = NodePartitioningManager.requiredCatalogHandle(partitioningHandle);
        ConnectorNodePartitioningProvider partitioningProvider = this.getPartitioningProvider(catalogHandle);
        ToIntFunction splitBucketFunction = partitioningProvider.getSplitBucketFunction(partitioningHandle.getTransactionHandle().orElseThrow(), session.toConnectorSession(catalogHandle), partitioningHandle.getConnectorHandle());
        Preconditions.checkArgument((splitBucketFunction != null ? 1 : 0) != 0, (String)"No partitioning %s", (Object)partitioningHandle);
        return split -> {
            int bucket = split.getConnectorSplit() instanceof EmptySplit ? 0 : splitBucketFunction.applyAsInt(split.getConnectorSplit());
            return bucket;
        };
    }

    private ConnectorNodePartitioningProvider getPartitioningProvider(CatalogHandle catalogHandle) {
        return this.partitioningProvider.getService(Objects.requireNonNull(catalogHandle, "catalogHandle is null"));
    }

    private static CatalogHandle requiredCatalogHandle(PartitioningHandle partitioningHandle) {
        return partitioningHandle.getCatalogHandle().orElseThrow(() -> new IllegalStateException("No catalog handle for partitioning handle: " + partitioningHandle));
    }

    private static List<InternalNode> createArbitraryBucketToNode(List<InternalNode> nodes, int bucketCount) {
        return (List)NodePartitioningManager.cyclingShuffledStream(nodes).limit(bucketCount).collect(ImmutableList.toImmutableList());
    }

    private static <T> Stream<T> cyclingShuffledStream(Collection<T> collection) {
        ArrayList list = new ArrayList(collection);
        Collections.shuffle(list);
        return Stream.generate(() -> list).flatMap(Collection::stream);
    }

    private static /* synthetic */ InternalNode lambda$getNodePartitioningMap$4(BiMap nodeToPartition, int partitionId) {
        return (InternalNode)nodeToPartition.inverse().get((Object)partitionId);
    }
}

