/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.plan;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.trino.sql.planner.OrderingScheme;
import io.trino.sql.planner.Symbol;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public class DataOrganizationSpecification {
    private final List<Symbol> partitionBy;
    private final Optional<OrderingScheme> orderingScheme;

    @JsonCreator
    public DataOrganizationSpecification(@JsonProperty(value="partitionBy") List<Symbol> partitionBy, @JsonProperty(value="orderingScheme") Optional<OrderingScheme> orderingScheme) {
        Objects.requireNonNull(partitionBy, "partitionBy is null");
        Objects.requireNonNull(orderingScheme, "orderingScheme is null");
        this.partitionBy = ImmutableList.copyOf(partitionBy);
        this.orderingScheme = Objects.requireNonNull(orderingScheme, "orderingScheme is null");
    }

    @JsonProperty
    public List<Symbol> getPartitionBy() {
        return this.partitionBy;
    }

    @JsonProperty
    public Optional<OrderingScheme> getOrderingScheme() {
        return this.orderingScheme;
    }

    public int hashCode() {
        return Objects.hash(this.partitionBy, this.orderingScheme);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DataOrganizationSpecification other = (DataOrganizationSpecification)obj;
        return Objects.equals(this.partitionBy, other.partitionBy) && Objects.equals(this.orderingScheme, other.orderingScheme);
    }
}

