/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.plan;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.metadata.TableFunctionHandle;
import io.trino.spi.ptf.Argument;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.plan.DataOrganizationSpecification;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.PlanVisitor;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public class TableFunctionNode
extends PlanNode {
    private final String name;
    private final Map<String, Argument> arguments;
    private final List<Symbol> properOutputs;
    private final List<PlanNode> sources;
    private final List<TableArgumentProperties> tableArgumentProperties;
    private final List<List<String>> copartitioningLists;
    private final TableFunctionHandle handle;

    @JsonCreator
    public TableFunctionNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="name") String name, @JsonProperty(value="arguments") Map<String, Argument> arguments, @JsonProperty(value="properOutputs") List<Symbol> properOutputs, @JsonProperty(value="sources") List<PlanNode> sources, @JsonProperty(value="tableArgumentProperties") List<TableArgumentProperties> tableArgumentProperties, @JsonProperty(value="copartitioningLists") List<List<String>> copartitioningLists, @JsonProperty(value="handle") TableFunctionHandle handle) {
        super(id);
        this.name = Objects.requireNonNull(name, "name is null");
        this.arguments = ImmutableMap.copyOf(arguments);
        this.properOutputs = ImmutableList.copyOf(properOutputs);
        this.sources = ImmutableList.copyOf(sources);
        this.tableArgumentProperties = ImmutableList.copyOf(tableArgumentProperties);
        this.copartitioningLists = (List)copartitioningLists.stream().map(ImmutableList::copyOf).collect(ImmutableList.toImmutableList());
        this.handle = Objects.requireNonNull(handle, "handle is null");
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public Map<String, Argument> getArguments() {
        return this.arguments;
    }

    @JsonProperty
    public List<Symbol> getProperOutputs() {
        return this.properOutputs;
    }

    @JsonProperty
    public List<TableArgumentProperties> getTableArgumentProperties() {
        return this.tableArgumentProperties;
    }

    @JsonProperty
    public List<List<String>> getCopartitioningLists() {
        return this.copartitioningLists;
    }

    @JsonProperty
    public TableFunctionHandle getHandle() {
        return this.handle;
    }

    @Override
    @JsonProperty
    public List<PlanNode> getSources() {
        return this.sources;
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        ImmutableList.Builder symbols = ImmutableList.builder();
        symbols.addAll(this.properOutputs);
        for (int i = 0; i < this.sources.size(); ++i) {
            TableArgumentProperties sourceProperties = this.tableArgumentProperties.get(i);
            if (sourceProperties.isPassThroughColumns()) {
                symbols.addAll(this.sources.get(i).getOutputSymbols());
                continue;
            }
            sourceProperties.getSpecification().map(DataOrganizationSpecification::getPartitionBy).ifPresent(arg_0 -> ((ImmutableList.Builder)symbols).addAll(arg_0));
        }
        return symbols.build();
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitTableFunction(this, context);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newSources) {
        Preconditions.checkArgument((this.sources.size() == newSources.size() ? 1 : 0) != 0, (Object)"wrong number of new children");
        return new TableFunctionNode(this.getId(), this.name, this.arguments, this.properOutputs, newSources, this.tableArgumentProperties, this.copartitioningLists, this.handle);
    }

    public static class TableArgumentProperties {
        private final String argumentName;
        private final boolean rowSemantics;
        private final boolean pruneWhenEmpty;
        private final boolean passThroughColumns;
        private final List<Symbol> requiredColumns;
        private final Optional<DataOrganizationSpecification> specification;

        @JsonCreator
        public TableArgumentProperties(@JsonProperty(value="argumentName") String argumentName, @JsonProperty(value="rowSemantics") boolean rowSemantics, @JsonProperty(value="pruneWhenEmpty") boolean pruneWhenEmpty, @JsonProperty(value="passThroughColumns") boolean passThroughColumns, @JsonProperty(value="requiredColumns") List<Symbol> requiredColumns, @JsonProperty(value="specification") Optional<DataOrganizationSpecification> specification) {
            this.argumentName = Objects.requireNonNull(argumentName, "argumentName is null");
            this.rowSemantics = rowSemantics;
            this.pruneWhenEmpty = pruneWhenEmpty;
            this.passThroughColumns = passThroughColumns;
            this.requiredColumns = ImmutableList.copyOf(requiredColumns);
            this.specification = Objects.requireNonNull(specification, "specification is null");
        }

        @JsonProperty
        public String getArgumentName() {
            return this.argumentName;
        }

        @JsonProperty
        public boolean isRowSemantics() {
            return this.rowSemantics;
        }

        @JsonProperty
        public boolean isPruneWhenEmpty() {
            return this.pruneWhenEmpty;
        }

        @JsonProperty
        public boolean isPassThroughColumns() {
            return this.passThroughColumns;
        }

        @JsonProperty
        public List<Symbol> getRequiredColumns() {
            return this.requiredColumns;
        }

        @JsonProperty
        public Optional<DataOrganizationSpecification> getSpecification() {
            return this.specification;
        }
    }
}

