/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.rewrite;

import io.trino.Session;
import io.trino.execution.QueryPreparer;
import io.trino.execution.warnings.WarningCollector;
import io.trino.sql.QueryUtil;
import io.trino.sql.analyzer.AnalyzerFactory;
import io.trino.sql.analyzer.QueryExplainer;
import io.trino.sql.analyzer.QueryExplainerFactory;
import io.trino.sql.rewrite.StatementRewrite;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Explain;
import io.trino.sql.tree.ExplainAnalyze;
import io.trino.sql.tree.ExplainFormat;
import io.trino.sql.tree.ExplainOption;
import io.trino.sql.tree.ExplainType;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.Parameter;
import io.trino.sql.tree.Statement;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;

public final class ExplainRewrite
implements StatementRewrite.Rewrite {
    private final QueryExplainerFactory queryExplainerFactory;
    private final QueryPreparer queryPreparer;

    @Inject
    public ExplainRewrite(QueryExplainerFactory queryExplainerFactory, QueryPreparer queryPreparer) {
        this.queryExplainerFactory = Objects.requireNonNull(queryExplainerFactory, "queryExplainerFactory is null");
        this.queryPreparer = Objects.requireNonNull(queryPreparer, "queryPreparer is null");
    }

    @Override
    public Statement rewrite(AnalyzerFactory analyzerFactory, Session session, Statement node, List<Expression> parameter, Map<NodeRef<Parameter>, Expression> parameterLookup, WarningCollector warningCollector) {
        return (Statement)new Visitor(session, this.queryPreparer, this.queryExplainerFactory.createQueryExplainer(analyzerFactory), warningCollector).process((Node)node, null);
    }

    private static final class Visitor
    extends AstVisitor<Node, Void> {
        private final Session session;
        private final QueryPreparer queryPreparer;
        private final QueryExplainer queryExplainer;
        private final WarningCollector warningCollector;

        public Visitor(Session session, QueryPreparer queryPreparer, QueryExplainer queryExplainer, WarningCollector warningCollector) {
            this.session = Objects.requireNonNull(session, "session is null");
            this.queryPreparer = Objects.requireNonNull(queryPreparer, "queryPreparer is null");
            this.queryExplainer = Objects.requireNonNull(queryExplainer, "queryExplainer is null");
            this.warningCollector = Objects.requireNonNull(warningCollector, "warningCollector is null");
        }

        protected Node visitExplainAnalyze(ExplainAnalyze node, Void context) {
            Statement statement = (Statement)this.process((Node)node.getStatement(), context);
            return new ExplainAnalyze(node.getLocation(), statement, node.isVerbose());
        }

        protected Node visitExplain(Explain node, Void context) {
            ExplainType.Type planType = ExplainType.Type.DISTRIBUTED;
            ExplainFormat.Type planFormat = ExplainFormat.Type.TEXT;
            List options = node.getOptions();
            for (ExplainOption option : options) {
                if (!(option instanceof ExplainType)) continue;
                planType = ((ExplainType)option).getType();
                if (planType != ExplainType.Type.IO) break;
                planFormat = ExplainFormat.Type.JSON;
                break;
            }
            for (ExplainOption option : options) {
                if (!(option instanceof ExplainFormat)) continue;
                planFormat = ((ExplainFormat)option).getType();
                break;
            }
            return this.getQueryPlan(node, planType, planFormat);
        }

        private Node getQueryPlan(Explain node, ExplainType.Type planType, ExplainFormat.Type planFormat) throws IllegalArgumentException {
            QueryPreparer.PreparedQuery preparedQuery = this.queryPreparer.prepareQuery(this.session, node.getStatement());
            if (planType == ExplainType.Type.VALIDATE) {
                this.queryExplainer.validate(this.session, preparedQuery.getStatement(), preparedQuery.getParameters(), this.warningCollector);
                return QueryUtil.singleValueQuery((String)"Valid", (boolean)true);
            }
            return QueryUtil.singleValueQuery((String)"Query Plan", (String)(switch (planFormat) {
                case ExplainFormat.Type.GRAPHVIZ -> this.queryExplainer.getGraphvizPlan(this.session, preparedQuery.getStatement(), planType, preparedQuery.getParameters(), this.warningCollector);
                case ExplainFormat.Type.JSON -> this.queryExplainer.getJsonPlan(this.session, preparedQuery.getStatement(), planType, preparedQuery.getParameters(), this.warningCollector);
                case ExplainFormat.Type.TEXT -> this.queryExplainer.getPlan(this.session, preparedQuery.getStatement(), planType, preparedQuery.getParameters(), this.warningCollector);
                default -> throw new IllegalArgumentException("Invalid Explain Format: " + planFormat);
            }));
        }

        protected Node visitNode(Node node, Void context) {
            return node;
        }
    }
}

