/*
 * Decompiled with CFR 0.152.
 */
package io.trino.transaction;

import com.google.common.util.concurrent.ListenableFuture;
import io.trino.metadata.CatalogInfo;
import io.trino.metadata.CatalogMetadata;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.transaction.IsolationLevel;
import io.trino.transaction.TransactionId;
import io.trino.transaction.TransactionInfo;
import java.util.List;
import java.util.Optional;

public interface TransactionManager {
    public static final IsolationLevel DEFAULT_ISOLATION = IsolationLevel.READ_UNCOMMITTED;
    public static final boolean DEFAULT_READ_ONLY = false;

    public boolean transactionExists(TransactionId var1);

    public TransactionInfo getTransactionInfo(TransactionId var1);

    public Optional<TransactionInfo> getTransactionInfoIfExist(TransactionId var1);

    public List<TransactionInfo> getAllTransactionInfos();

    public TransactionId beginTransaction(boolean var1);

    public TransactionId beginTransaction(IsolationLevel var1, boolean var2, boolean var3);

    public List<CatalogInfo> getCatalogs(TransactionId var1);

    public List<CatalogInfo> getActiveCatalogs(TransactionId var1);

    public Optional<CatalogHandle> getCatalogHandle(TransactionId var1, String var2);

    default public CatalogMetadata getRequiredCatalogMetadata(TransactionId transactionId, String catalogName) {
        return this.getOptionalCatalogMetadata(transactionId, catalogName).orElseThrow(() -> new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Catalog does not exist: " + catalogName));
    }

    public Optional<CatalogMetadata> getOptionalCatalogMetadata(TransactionId var1, String var2);

    public CatalogMetadata getCatalogMetadata(TransactionId var1, CatalogHandle var2);

    public CatalogMetadata getCatalogMetadataForWrite(TransactionId var1, CatalogHandle var2);

    public CatalogMetadata getCatalogMetadataForWrite(TransactionId var1, String var2);

    public ConnectorTransactionHandle getConnectorTransaction(TransactionId var1, String var2);

    public ConnectorTransactionHandle getConnectorTransaction(TransactionId var1, CatalogHandle var2);

    public void checkAndSetActive(TransactionId var1);

    public void trySetActive(TransactionId var1);

    public void trySetInactive(TransactionId var1);

    public ListenableFuture<Void> asyncCommit(TransactionId var1);

    public ListenableFuture<Void> asyncAbort(TransactionId var1);

    public void fail(TransactionId var1);
}

