/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.HyperLogLogType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimeWithTimeZoneType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.VarcharType;
import io.trino.type.CodePointsType;
import io.trino.type.JoniRegexpType;
import io.trino.type.JsonPathType;
import io.trino.type.Re2JRegexpType;
import io.trino.type.UnknownType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public final class TypeCoercion {
    private final Function<TypeSignature, Type> lookupType;

    public TypeCoercion(Function<TypeSignature, Type> lookupType) {
        this.lookupType = Objects.requireNonNull(lookupType, "lookupType is null");
    }

    public boolean isTypeOnlyCoercion(Type source, Type result) {
        String resultTypeBase;
        if (source.equals(result)) {
            return true;
        }
        if (!this.canCoerce(source, result)) {
            return false;
        }
        if (source instanceof VarcharType && result instanceof VarcharType) {
            return true;
        }
        if (source instanceof DecimalType && result instanceof DecimalType) {
            DecimalType sourceDecimal = (DecimalType)source;
            DecimalType resultDecimal = (DecimalType)result;
            boolean sameDecimalSubtype = sourceDecimal.isShort() && resultDecimal.isShort() || !sourceDecimal.isShort() && !resultDecimal.isShort();
            boolean sameScale = sourceDecimal.getScale() == resultDecimal.getScale();
            boolean sourcePrecisionIsLessOrEqualToResultPrecision = sourceDecimal.getPrecision() <= resultDecimal.getPrecision();
            return sameDecimalSubtype && sameScale && sourcePrecisionIsLessOrEqualToResultPrecision;
        }
        if (source instanceof RowType && result instanceof RowType) {
            RowType sourceType = (RowType)source;
            RowType resultType = (RowType)result;
            List sourceFields = sourceType.getFields();
            List resultFields = resultType.getFields();
            if (sourceFields.size() != resultFields.size()) {
                return false;
            }
            for (int i = 0; i < sourceFields.size(); ++i) {
                if (this.isTypeOnlyCoercion(((RowType.Field)sourceFields.get(i)).getType(), ((RowType.Field)resultFields.get(i)).getType())) continue;
                return false;
            }
            return true;
        }
        String sourceTypeBase = source.getBaseName();
        if (sourceTypeBase.equals(resultTypeBase = result.getBaseName()) && TypeCoercion.isCovariantParametrizedType(source)) {
            List sourceTypeParameters = source.getTypeParameters();
            List resultTypeParameters = result.getTypeParameters();
            Preconditions.checkState((sourceTypeParameters.size() == resultTypeParameters.size() ? 1 : 0) != 0);
            for (int i = 0; i < sourceTypeParameters.size(); ++i) {
                if (this.isTypeOnlyCoercion((Type)sourceTypeParameters.get(i), (Type)resultTypeParameters.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isInjectiveCoercion(Type source, Type result) {
        if (source.equals(BigintType.BIGINT) && result.equals(DoubleType.DOUBLE) || source.equals(BigintType.BIGINT) && result.equals(RealType.REAL) || source.equals(IntegerType.INTEGER) && result.equals(RealType.REAL) || result instanceof TimestampWithTimeZoneType || result instanceof TimeWithTimeZoneType) {
            return false;
        }
        if (source instanceof DecimalType) {
            int precision = ((DecimalType)source).getPrecision();
            if (precision > 15 && result.equals(DoubleType.DOUBLE)) {
                return false;
            }
            if (precision > 7 && result.equals(RealType.REAL)) {
                return false;
            }
        }
        return this.canCoerce(source, result);
    }

    public Optional<Type> getCommonSuperType(Type firstType, Type secondType) {
        TypeCompatibility compatibility = this.compatibility(firstType, secondType);
        if (!compatibility.isCompatible()) {
            return Optional.empty();
        }
        return Optional.of(compatibility.getCommonSuperType());
    }

    public boolean isCompatible(Type fromType, Type toType) {
        TypeCompatibility typeCompatibility = this.compatibility(fromType, toType);
        return typeCompatibility.isCompatible();
    }

    public boolean canCoerce(Type fromType, Type toType) {
        TypeCompatibility typeCompatibility = this.compatibility(fromType, toType);
        return typeCompatibility.isCoercible();
    }

    private TypeCompatibility compatibility(Type fromType, Type toType) {
        String toTypeBaseName;
        if (fromType.equals(toType)) {
            return TypeCompatibility.compatible(toType, true);
        }
        if (fromType.equals((Object)UnknownType.UNKNOWN)) {
            return TypeCompatibility.compatible(toType, true);
        }
        if (toType.equals((Object)UnknownType.UNKNOWN)) {
            return TypeCompatibility.compatible(fromType, false);
        }
        String fromTypeBaseName = fromType.getBaseName();
        if (fromTypeBaseName.equals(toTypeBaseName = toType.getBaseName())) {
            if (fromTypeBaseName.equals("decimal")) {
                Type commonSuperType = TypeCoercion.getCommonSuperTypeForDecimal((DecimalType)fromType, (DecimalType)toType);
                return TypeCompatibility.compatible(commonSuperType, commonSuperType.equals(toType));
            }
            if (fromTypeBaseName.equals("varchar")) {
                Type commonSuperType = TypeCoercion.getCommonSuperTypeForVarchar((VarcharType)fromType, (VarcharType)toType);
                return TypeCompatibility.compatible(commonSuperType, commonSuperType.equals(toType));
            }
            if (fromTypeBaseName.equals("char")) {
                Type commonSuperType = TypeCoercion.getCommonSuperTypeForChar((CharType)fromType, (CharType)toType);
                return TypeCompatibility.compatible(commonSuperType, commonSuperType.equals(toType));
            }
            if (fromTypeBaseName.equals("row")) {
                return this.typeCompatibilityForRow((RowType)fromType, (RowType)toType);
            }
            if (fromTypeBaseName.equals("timestamp")) {
                TimestampType commonSuperType = TimestampType.createTimestampType((int)Math.max(((TimestampType)fromType).getPrecision(), ((TimestampType)toType).getPrecision()));
                return TypeCompatibility.compatible((Type)commonSuperType, commonSuperType.equals(toType));
            }
            if (fromTypeBaseName.equals("timestamp with time zone")) {
                TimestampWithTimeZoneType commonSuperType = TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)Math.max(((TimestampWithTimeZoneType)fromType).getPrecision(), ((TimestampWithTimeZoneType)toType).getPrecision()));
                return TypeCompatibility.compatible((Type)commonSuperType, commonSuperType.equals(toType));
            }
            if (fromTypeBaseName.equals("time")) {
                TimeType commonSuperType = TimeType.createTimeType((int)Math.max(((TimeType)fromType).getPrecision(), ((TimeType)toType).getPrecision()));
                return TypeCompatibility.compatible((Type)commonSuperType, commonSuperType.equals(toType));
            }
            if (fromTypeBaseName.equals("time with time zone")) {
                TimeWithTimeZoneType commonSuperType = TimeWithTimeZoneType.createTimeWithTimeZoneType((int)Math.max(((TimeWithTimeZoneType)fromType).getPrecision(), ((TimeWithTimeZoneType)toType).getPrecision()));
                return TypeCompatibility.compatible((Type)commonSuperType, commonSuperType.equals(toType));
            }
            if (TypeCoercion.isCovariantParametrizedType(fromType)) {
                return this.typeCompatibilityForCovariantParametrizedType(fromType, toType);
            }
            return TypeCompatibility.incompatible();
        }
        Optional<Type> coercedType = this.coerceTypeBase(fromType, toType.getBaseName());
        if (coercedType.isPresent()) {
            return this.compatibility(coercedType.get(), toType);
        }
        coercedType = this.coerceTypeBase(toType, fromType.getBaseName());
        if (coercedType.isPresent()) {
            TypeCompatibility typeCompatibility = this.compatibility(fromType, coercedType.get());
            if (!typeCompatibility.isCompatible()) {
                return TypeCompatibility.incompatible();
            }
            return TypeCompatibility.compatible(typeCompatibility.getCommonSuperType(), false);
        }
        return TypeCompatibility.incompatible();
    }

    private static Type getCommonSuperTypeForDecimal(DecimalType firstType, DecimalType secondType) {
        int targetScale = Math.max(firstType.getScale(), secondType.getScale());
        int targetPrecision = Math.max(firstType.getPrecision() - firstType.getScale(), secondType.getPrecision() - secondType.getScale()) + targetScale;
        targetPrecision = Math.min(38, targetPrecision);
        return DecimalType.createDecimalType((int)targetPrecision, (int)targetScale);
    }

    private static Type getCommonSuperTypeForVarchar(VarcharType firstType, VarcharType secondType) {
        if (firstType.isUnbounded() || secondType.isUnbounded()) {
            return VarcharType.createUnboundedVarcharType();
        }
        return VarcharType.createVarcharType((int)Math.max(firstType.getBoundedLength(), secondType.getBoundedLength()));
    }

    private static Type getCommonSuperTypeForChar(CharType firstType, CharType secondType) {
        return CharType.createCharType((int)Math.max(firstType.getLength(), secondType.getLength()));
    }

    private TypeCompatibility typeCompatibilityForRow(RowType firstType, RowType secondType) {
        List firstFields = firstType.getFields();
        List secondFields = secondType.getFields();
        if (firstFields.size() != secondFields.size()) {
            return TypeCompatibility.incompatible();
        }
        ImmutableList.Builder fields = ImmutableList.builder();
        boolean coercible = true;
        for (int i = 0; i < firstFields.size(); ++i) {
            Optional secondParameterName;
            Type secondFieldType;
            Type firstFieldType = ((RowType.Field)firstFields.get(i)).getType();
            TypeCompatibility typeCompatibility = this.compatibility(firstFieldType, secondFieldType = ((RowType.Field)secondFields.get(i)).getType());
            if (!typeCompatibility.isCompatible()) {
                return TypeCompatibility.incompatible();
            }
            Type commonParameterType = typeCompatibility.getCommonSuperType();
            Optional firstParameterName = ((RowType.Field)firstFields.get(i)).getName();
            Optional commonName = firstParameterName.equals(secondParameterName = ((RowType.Field)secondFields.get(i)).getName()) ? firstParameterName : Optional.empty();
            coercible &= typeCompatibility.isCoercible();
            fields.add((Object)new RowType.Field(commonName, commonParameterType));
        }
        return TypeCompatibility.compatible((Type)RowType.from((List)fields.build()), coercible);
    }

    private TypeCompatibility typeCompatibilityForCovariantParametrizedType(Type fromType, Type toType) {
        Preconditions.checkState((boolean)fromType.getClass().equals(toType.getClass()));
        ImmutableList.Builder commonParameterTypes = ImmutableList.builder();
        List fromTypeParameters = fromType.getTypeParameters();
        List toTypeParameters = toType.getTypeParameters();
        if (fromTypeParameters.size() != toTypeParameters.size()) {
            return TypeCompatibility.incompatible();
        }
        boolean coercible = true;
        for (int i = 0; i < fromTypeParameters.size(); ++i) {
            TypeCompatibility compatibility = this.compatibility((Type)fromTypeParameters.get(i), (Type)toTypeParameters.get(i));
            if (!compatibility.isCompatible()) {
                return TypeCompatibility.incompatible();
            }
            coercible &= compatibility.isCoercible();
            commonParameterTypes.add((Object)TypeSignatureParameter.typeParameter((TypeSignature)compatibility.getCommonSuperType().getTypeSignature()));
        }
        String typeBase = fromType.getBaseName();
        return TypeCompatibility.compatible(this.lookupType.apply(new TypeSignature(typeBase, (List)commonParameterTypes.build())), coercible);
    }

    public Optional<Type> coerceTypeBase(Type sourceType, String resultTypeBase) {
        String sourceTypeName = sourceType.getBaseName();
        if (sourceTypeName.equals(resultTypeBase)) {
            return Optional.of(sourceType);
        }
        switch (sourceTypeName) {
            case "unknown": {
                switch (resultTypeBase) {
                    case "boolean": 
                    case "bigint": 
                    case "integer": 
                    case "double": 
                    case "real": 
                    case "varbinary": 
                    case "date": 
                    case "time": 
                    case "time with time zone": 
                    case "timestamp": 
                    case "timestamp with time zone": 
                    case "HyperLogLog": 
                    case "SetDigest": 
                    case "P4HyperLogLog": 
                    case "json": 
                    case "interval year to month": 
                    case "interval day to second": 
                    case "JoniRegExp": 
                    case "JsonPath": 
                    case "color": 
                    case "CodePoints": {
                        return Optional.of(this.lookupType.apply(new TypeSignature(resultTypeBase, new TypeSignatureParameter[0])));
                    }
                    case "varchar": {
                        return Optional.of(VarcharType.createVarcharType((int)0));
                    }
                    case "char": {
                        return Optional.of(CharType.createCharType((int)0));
                    }
                    case "decimal": {
                        return Optional.of(DecimalType.createDecimalType((int)1, (int)0));
                    }
                }
                return Optional.empty();
            }
            case "tinyint": {
                switch (resultTypeBase) {
                    case "smallint": {
                        return Optional.of(SmallintType.SMALLINT);
                    }
                    case "integer": {
                        return Optional.of(IntegerType.INTEGER);
                    }
                    case "bigint": {
                        return Optional.of(BigintType.BIGINT);
                    }
                    case "real": {
                        return Optional.of(RealType.REAL);
                    }
                    case "double": {
                        return Optional.of(DoubleType.DOUBLE);
                    }
                    case "decimal": {
                        return Optional.of(DecimalType.createDecimalType((int)3, (int)0));
                    }
                }
                return Optional.empty();
            }
            case "smallint": {
                switch (resultTypeBase) {
                    case "integer": {
                        return Optional.of(IntegerType.INTEGER);
                    }
                    case "bigint": {
                        return Optional.of(BigintType.BIGINT);
                    }
                    case "real": {
                        return Optional.of(RealType.REAL);
                    }
                    case "double": {
                        return Optional.of(DoubleType.DOUBLE);
                    }
                    case "decimal": {
                        return Optional.of(DecimalType.createDecimalType((int)5, (int)0));
                    }
                }
                return Optional.empty();
            }
            case "integer": {
                switch (resultTypeBase) {
                    case "bigint": {
                        return Optional.of(BigintType.BIGINT);
                    }
                    case "real": {
                        return Optional.of(RealType.REAL);
                    }
                    case "double": {
                        return Optional.of(DoubleType.DOUBLE);
                    }
                    case "decimal": {
                        return Optional.of(DecimalType.createDecimalType((int)10, (int)0));
                    }
                }
                return Optional.empty();
            }
            case "bigint": {
                switch (resultTypeBase) {
                    case "real": {
                        return Optional.of(RealType.REAL);
                    }
                    case "double": {
                        return Optional.of(DoubleType.DOUBLE);
                    }
                    case "decimal": {
                        return Optional.of(DecimalType.createDecimalType((int)19, (int)0));
                    }
                }
                return Optional.empty();
            }
            case "decimal": {
                switch (resultTypeBase) {
                    case "real": {
                        return Optional.of(RealType.REAL);
                    }
                    case "double": {
                        return Optional.of(DoubleType.DOUBLE);
                    }
                }
                return Optional.empty();
            }
            case "real": {
                switch (resultTypeBase) {
                    case "double": {
                        return Optional.of(DoubleType.DOUBLE);
                    }
                }
                return Optional.empty();
            }
            case "date": {
                switch (resultTypeBase) {
                    case "timestamp": {
                        return Optional.of(TimestampType.createTimestampType((int)0));
                    }
                    case "timestamp with time zone": {
                        return Optional.of(TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS);
                    }
                }
                return Optional.empty();
            }
            case "time": {
                switch (resultTypeBase) {
                    case "time with time zone": {
                        return Optional.of(TimeWithTimeZoneType.TIME_WITH_TIME_ZONE);
                    }
                }
                return Optional.empty();
            }
            case "timestamp": {
                switch (resultTypeBase) {
                    case "timestamp with time zone": {
                        return Optional.of(TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)((TimestampType)sourceType).getPrecision()));
                    }
                }
                return Optional.empty();
            }
            case "varchar": {
                switch (resultTypeBase) {
                    case "char": {
                        VarcharType varcharType = (VarcharType)sourceType;
                        if (varcharType.isUnbounded()) {
                            return Optional.of(CharType.createCharType((int)65536));
                        }
                        return Optional.of(CharType.createCharType((int)Math.min(65536, varcharType.getBoundedLength())));
                    }
                    case "JoniRegExp": {
                        return Optional.of(JoniRegexpType.JONI_REGEXP);
                    }
                    case "Re2JRegExp": {
                        return Optional.of(this.lookupType.apply(Re2JRegexpType.RE2J_REGEXP_SIGNATURE));
                    }
                    case "JsonPath": {
                        return Optional.of(JsonPathType.JSON_PATH);
                    }
                    case "CodePoints": {
                        return Optional.of(CodePointsType.CODE_POINTS);
                    }
                }
                return Optional.empty();
            }
            case "char": {
                switch (resultTypeBase) {
                    case "varchar": {
                        return Optional.empty();
                    }
                    case "JoniRegExp": {
                        return Optional.of(JoniRegexpType.JONI_REGEXP);
                    }
                    case "Re2JRegExp": {
                        return Optional.of(this.lookupType.apply(Re2JRegexpType.RE2J_REGEXP_SIGNATURE));
                    }
                    case "JsonPath": {
                        return Optional.of(JsonPathType.JSON_PATH);
                    }
                    case "CodePoints": {
                        return Optional.of(CodePointsType.CODE_POINTS);
                    }
                }
                return Optional.empty();
            }
            case "P4HyperLogLog": {
                switch (resultTypeBase) {
                    case "HyperLogLog": {
                        return Optional.of(HyperLogLogType.HYPER_LOG_LOG);
                    }
                }
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    public static boolean isCovariantTypeBase(String typeBase) {
        return typeBase.equals("array") || typeBase.equals("map");
    }

    private static boolean isCovariantParametrizedType(Type type) {
        return type instanceof MapType || type instanceof ArrayType;
    }

    public static class TypeCompatibility {
        private final Optional<Type> commonSuperType;
        private final boolean coercible;

        private TypeCompatibility(Optional<Type> commonSuperType, boolean coercible) {
            Preconditions.checkArgument((!coercible || commonSuperType.isPresent() ? 1 : 0) != 0);
            this.commonSuperType = commonSuperType;
            this.coercible = coercible;
        }

        private static TypeCompatibility compatible(Type commonSuperType, boolean coercible) {
            return new TypeCompatibility(Optional.of(commonSuperType), coercible);
        }

        private static TypeCompatibility incompatible() {
            return new TypeCompatibility(Optional.empty(), false);
        }

        public boolean isCompatible() {
            return this.commonSuperType.isPresent();
        }

        public Type getCommonSuperType() {
            Preconditions.checkState((boolean)this.commonSuperType.isPresent(), (Object)"Types are not compatible");
            return this.commonSuperType.get();
        }

        public boolean isCoercible() {
            return this.coercible;
        }
    }
}

