/*
 * Decompiled with CFR 0.152.
 */
package io.trino;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slice;
import io.trino.Session;
import io.trino.client.ProtocolHeaders;
import io.trino.metadata.SessionPropertyManager;
import io.trino.spi.QueryId;
import io.trino.spi.security.BasicPrincipal;
import io.trino.spi.security.Identity;
import io.trino.spi.security.SelectedRole;
import io.trino.spi.session.ResourceEstimates;
import io.trino.spi.type.TimeZoneKey;
import io.trino.sql.SqlPath;
import io.trino.transaction.TransactionId;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public final class SessionRepresentation {
    private final String queryId;
    private final Optional<TransactionId> transactionId;
    private final boolean clientTransactionSupport;
    private final String user;
    private final Set<String> groups;
    private final Optional<String> principal;
    private final Set<String> enabledRoles;
    private final Optional<String> source;
    private final Optional<String> catalog;
    private final Optional<String> schema;
    private final SqlPath path;
    private final Optional<String> traceToken;
    private final TimeZoneKey timeZoneKey;
    private final Locale locale;
    private final Optional<String> remoteUserAddress;
    private final Optional<String> userAgent;
    private final Optional<String> clientInfo;
    private final Set<String> clientTags;
    private final Set<String> clientCapabilities;
    private final Instant start;
    private final ResourceEstimates resourceEstimates;
    private final Map<String, String> systemProperties;
    private final Map<String, Map<String, String>> catalogProperties;
    private final Map<String, SelectedRole> catalogRoles;
    private final Map<String, String> preparedStatements;
    private final String protocolName;

    @JsonCreator
    public SessionRepresentation(@JsonProperty(value="queryId") String queryId, @JsonProperty(value="transactionId") Optional<TransactionId> transactionId, @JsonProperty(value="clientTransactionSupport") boolean clientTransactionSupport, @JsonProperty(value="user") String user, @JsonProperty(value="groups") Set<String> groups, @JsonProperty(value="principal") Optional<String> principal, @JsonProperty(value="enabledRoles") Set<String> enabledRoles, @JsonProperty(value="source") Optional<String> source, @JsonProperty(value="catalog") Optional<String> catalog, @JsonProperty(value="schema") Optional<String> schema, @JsonProperty(value="path") SqlPath path, @JsonProperty(value="traceToken") Optional<String> traceToken, @JsonProperty(value="timeZoneKey") TimeZoneKey timeZoneKey, @JsonProperty(value="locale") Locale locale, @JsonProperty(value="remoteUserAddress") Optional<String> remoteUserAddress, @JsonProperty(value="userAgent") Optional<String> userAgent, @JsonProperty(value="clientInfo") Optional<String> clientInfo, @JsonProperty(value="clientTags") Set<String> clientTags, @JsonProperty(value="clientCapabilities") Set<String> clientCapabilities, @JsonProperty(value="resourceEstimates") ResourceEstimates resourceEstimates, @JsonProperty(value="start") Instant start, @JsonProperty(value="systemProperties") Map<String, String> systemProperties, @JsonProperty(value="catalogProperties") Map<String, Map<String, String>> catalogProperties, @JsonProperty(value="catalogRoles") Map<String, SelectedRole> catalogRoles, @JsonProperty(value="preparedStatements") Map<String, String> preparedStatements, @JsonProperty(value="protocolName") String protocolName) {
        this.queryId = Objects.requireNonNull(queryId, "queryId is null");
        this.transactionId = Objects.requireNonNull(transactionId, "transactionId is null");
        this.clientTransactionSupport = clientTransactionSupport;
        this.user = Objects.requireNonNull(user, "user is null");
        this.groups = Objects.requireNonNull(groups, "groups is null");
        this.principal = Objects.requireNonNull(principal, "principal is null");
        this.enabledRoles = ImmutableSet.copyOf((Collection)Objects.requireNonNull(enabledRoles, "enabledRoles is null"));
        this.source = Objects.requireNonNull(source, "source is null");
        this.catalog = Objects.requireNonNull(catalog, "catalog is null");
        this.schema = Objects.requireNonNull(schema, "schema is null");
        this.path = Objects.requireNonNull(path, "path is null");
        this.traceToken = Objects.requireNonNull(traceToken, "traceToken is null");
        this.timeZoneKey = Objects.requireNonNull(timeZoneKey, "timeZoneKey is null");
        this.locale = Objects.requireNonNull(locale, "locale is null");
        this.remoteUserAddress = Objects.requireNonNull(remoteUserAddress, "remoteUserAddress is null");
        this.userAgent = Objects.requireNonNull(userAgent, "userAgent is null");
        this.clientInfo = Objects.requireNonNull(clientInfo, "clientInfo is null");
        this.clientTags = Objects.requireNonNull(clientTags, "clientTags is null");
        this.clientCapabilities = Objects.requireNonNull(clientCapabilities, "clientCapabilities is null");
        this.resourceEstimates = Objects.requireNonNull(resourceEstimates, "resourceEstimates is null");
        this.start = start;
        this.systemProperties = ImmutableMap.copyOf(systemProperties);
        this.catalogRoles = ImmutableMap.copyOf(catalogRoles);
        this.preparedStatements = ImmutableMap.copyOf(preparedStatements);
        this.protocolName = Objects.requireNonNull(protocolName, "protocolName is null");
        ImmutableMap.Builder catalogPropertiesBuilder = ImmutableMap.builder();
        for (Map.Entry<String, Map<String, String>> entry : catalogProperties.entrySet()) {
            catalogPropertiesBuilder.put((Object)entry.getKey(), (Object)ImmutableMap.copyOf(entry.getValue()));
        }
        this.catalogProperties = catalogPropertiesBuilder.buildOrThrow();
    }

    @JsonProperty
    public String getQueryId() {
        return this.queryId;
    }

    @JsonProperty
    public Optional<TransactionId> getTransactionId() {
        return this.transactionId;
    }

    @JsonProperty
    public boolean isClientTransactionSupport() {
        return this.clientTransactionSupport;
    }

    @JsonProperty
    public String getUser() {
        return this.user;
    }

    @JsonProperty
    public Set<String> getGroups() {
        return this.groups;
    }

    @JsonProperty
    public Optional<String> getPrincipal() {
        return this.principal;
    }

    @JsonProperty
    public Set<String> getEnabledRoles() {
        return this.enabledRoles;
    }

    @JsonProperty
    public Optional<String> getSource() {
        return this.source;
    }

    @JsonProperty
    public Optional<String> getTraceToken() {
        return this.traceToken;
    }

    @JsonProperty
    public Optional<String> getCatalog() {
        return this.catalog;
    }

    @JsonProperty
    public Optional<String> getSchema() {
        return this.schema;
    }

    @JsonProperty
    public SqlPath getPath() {
        return this.path;
    }

    @JsonProperty
    public TimeZoneKey getTimeZoneKey() {
        return this.timeZoneKey;
    }

    @JsonProperty
    public Locale getLocale() {
        return this.locale;
    }

    @JsonProperty
    public Optional<String> getRemoteUserAddress() {
        return this.remoteUserAddress;
    }

    @JsonProperty
    public Optional<String> getUserAgent() {
        return this.userAgent;
    }

    @JsonProperty
    public Optional<String> getClientInfo() {
        return this.clientInfo;
    }

    @JsonProperty
    public Set<String> getClientTags() {
        return this.clientTags;
    }

    @JsonProperty
    public Set<String> getClientCapabilities() {
        return this.clientCapabilities;
    }

    @JsonProperty
    public Instant getStart() {
        return this.start;
    }

    @JsonProperty
    public ResourceEstimates getResourceEstimates() {
        return this.resourceEstimates;
    }

    @JsonProperty
    public Map<String, String> getSystemProperties() {
        return this.systemProperties;
    }

    @JsonProperty
    public Map<String, Map<String, String>> getCatalogProperties() {
        return this.catalogProperties;
    }

    @JsonProperty
    public Map<String, SelectedRole> getCatalogRoles() {
        return this.catalogRoles;
    }

    @JsonProperty
    public Map<String, String> getPreparedStatements() {
        return this.preparedStatements;
    }

    @JsonProperty
    public String getProtocolName() {
        return this.protocolName;
    }

    @JsonProperty
    public String getTimeZone() {
        return this.timeZoneKey.getId();
    }

    public Identity toIdentity() {
        return this.toIdentity(Collections.emptyMap());
    }

    public Identity toIdentity(Map<String, String> extraCredentials) {
        return Identity.forUser((String)this.user).withGroups(this.groups).withPrincipal(this.principal.map(BasicPrincipal::new)).withEnabledRoles(this.enabledRoles).withConnectorRoles(this.catalogRoles).withExtraCredentials(extraCredentials).build();
    }

    public Session toSession(SessionPropertyManager sessionPropertyManager) {
        return this.toSession(sessionPropertyManager, Collections.emptyMap(), Optional.empty());
    }

    public Session toSession(SessionPropertyManager sessionPropertyManager, Map<String, String> extraCredentials, Optional<Slice> exchangeEncryptionKey) {
        return new Session(new QueryId(this.queryId), this.transactionId, this.clientTransactionSupport, this.toIdentity(extraCredentials), this.source, this.catalog, this.schema, this.path, this.traceToken, this.timeZoneKey, this.locale, this.remoteUserAddress, this.userAgent, this.clientInfo, this.clientTags, this.clientCapabilities, this.resourceEstimates, this.start, this.systemProperties, this.catalogProperties, sessionPropertyManager, this.preparedStatements, ProtocolHeaders.createProtocolHeaders((String)this.protocolName), exchangeEncryptionKey);
    }
}

