/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import io.airlift.configuration.ConfigBinder;
import io.trino.connector.ConnectorServicesProvider;
import io.trino.connector.DefaultCatalogFactory;
import io.trino.connector.LazyCatalogFactory;
import io.trino.connector.StaticCatalogManager;
import io.trino.connector.StaticCatalogManagerConfig;
import io.trino.connector.system.GlobalSystemConnector;
import io.trino.metadata.CatalogManager;
import javax.inject.Inject;

public class StaticCatalogManagerModule
implements Module {
    public void configure(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(StaticCatalogManagerConfig.class);
        binder.bind(StaticCatalogManager.class).in(Scopes.SINGLETON);
        binder.bind(ConnectorServicesProvider.class).to(StaticCatalogManager.class).in(Scopes.SINGLETON);
        binder.bind(CatalogManager.class).to(StaticCatalogManager.class).in(Scopes.SINGLETON);
        binder.bind(LazyRegister.class).asEagerSingleton();
    }

    private static class LazyRegister {
        @Inject
        public LazyRegister(DefaultCatalogFactory defaultCatalogFactory, LazyCatalogFactory lazyCatalogFactory, StaticCatalogManager catalogManager, GlobalSystemConnector globalSystemConnector) {
            lazyCatalogFactory.setCatalogFactory(defaultCatalogFactory);
            catalogManager.registerGlobalSystemConnector(globalSystemConnector);
        }
    }
}

