/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.trino.Session;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataUtil;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.RedirectionAwareTableHandle;
import io.trino.security.AccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.SetTableAuthorization;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class SetTableAuthorizationTask
implements DataDefinitionTask<SetTableAuthorization> {
    private final Metadata metadata;
    private final AccessControl accessControl;

    @Inject
    public SetTableAuthorizationTask(Metadata metadata, AccessControl accessControl) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
    }

    @Override
    public String getName() {
        return "SET TABLE AUTHORIZATION";
    }

    @Override
    public ListenableFuture<Void> execute(SetTableAuthorization statement, QueryStateMachine stateMachine, List<Expression> parameters, WarningCollector warningCollector) {
        Session session = stateMachine.getSession();
        QualifiedObjectName tableName = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getSource());
        MetadataUtil.getRequiredCatalogHandle(this.metadata, session, (Node)statement, tableName.getCatalogName());
        RedirectionAwareTableHandle redirection = this.metadata.getRedirectionAwareTableHandle(session, tableName);
        if (redirection.getTableHandle().isEmpty()) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)statement, "Table '%s' does not exist", tableName);
        }
        if (redirection.getRedirectedTableName().isPresent()) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)statement, "Table %s is redirected to %s and SET TABLE AUTHORIZATION is not supported with table redirections", tableName, redirection.getRedirectedTableName().get());
        }
        TrinoPrincipal principal = MetadataUtil.createPrincipal(statement.getPrincipal());
        MetadataUtil.checkRoleExists(session, (Node)statement, this.metadata, principal, Optional.of(tableName.getCatalogName()).filter(catalog -> this.metadata.isCatalogManagedSecurity(session, (String)catalog)));
        this.accessControl.checkCanSetTableAuthorization(session.toSecurityContext(), tableName, principal);
        this.metadata.setTableAuthorization(session, tableName.asCatalogSchemaTableName(), principal);
        return Futures.immediateVoidFuture();
    }
}

