/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.DefunctConfig;
import io.airlift.configuration.LegacyConfig;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.airlift.units.MaxDuration;
import io.airlift.units.MinDuration;
import io.trino.util.MachineInfo;
import io.trino.util.PowerOfTwo;
import it.unimi.dsi.fastutil.HashCommon;
import java.math.BigDecimal;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

@DefunctConfig(value={"experimental.big-query-max-task-memory", "task.max-memory", "task.http-notification-threads", "task.info-refresh-max-wait", "task.operator-pre-allocated-memory", "sink.new-implementation", "task.legacy-scheduling-behavior", "task.level-absolute-priority"})
public class TaskManagerConfig {
    private boolean perOperatorCpuTimerEnabled = true;
    private boolean taskCpuTimerEnabled = true;
    private boolean statisticsCpuTimerEnabled = true;
    private DataSize maxPartialAggregationMemoryUsage = DataSize.of((long)16L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private DataSize maxPartialTopNMemory = DataSize.of((long)16L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private DataSize maxLocalExchangeBufferSize = DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private DataSize maxIndexMemoryUsage = DataSize.of((long)64L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private boolean shareIndexLoading;
    private int maxWorkerThreads = Runtime.getRuntime().availableProcessors() * 2;
    private Integer minDrivers;
    private Integer initialSplitsPerNode;
    private int minDriversPerTask = 3;
    private int maxDriversPerTask = Integer.MAX_VALUE;
    private Duration splitConcurrencyAdjustmentInterval = new Duration(100.0, TimeUnit.MILLISECONDS);
    private DataSize sinkMaxBufferSize = DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private DataSize sinkMaxBroadcastBufferSize = DataSize.of((long)200L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private DataSize maxPagePartitioningBufferSize = DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private int pagePartitioningBufferPoolSize = 8;
    private Duration clientTimeout = new Duration(2.0, TimeUnit.MINUTES);
    private Duration infoMaxAge = new Duration(15.0, TimeUnit.MINUTES);
    private Duration statusRefreshMaxWait = new Duration(1.0, TimeUnit.SECONDS);
    private Duration infoUpdateInterval = new Duration(3.0, TimeUnit.SECONDS);
    private boolean interruptStuckSplitTasksEnabled = true;
    private Duration interruptStuckSplitTasksWarningThreshold = new Duration(10.0, TimeUnit.MINUTES);
    private Duration interruptStuckSplitTasksTimeout = new Duration(15.0, TimeUnit.MINUTES);
    private Duration interruptStuckSplitTasksDetectionInterval = new Duration(2.0, TimeUnit.MINUTES);
    private boolean scaleWritersEnabled = true;
    private int scaleWritersMaxWriterCount = Math.min(MachineInfo.getAvailablePhysicalProcessorCount(), 32);
    private int writerCount = 1;
    private int partitionedWriterCount = Math.min(Math.max(HashCommon.nextPowerOfTwo((int)MachineInfo.getAvailablePhysicalProcessorCount()), 2), 32);
    private int taskConcurrency = Math.min(Math.max(HashCommon.nextPowerOfTwo((int)MachineInfo.getAvailablePhysicalProcessorCount()), 2), 32);
    private int httpResponseThreads = 100;
    private int httpTimeoutThreads = 3;
    private int taskNotificationThreads = 5;
    private int taskYieldThreads = 3;
    private BigDecimal levelTimeMultiplier = new BigDecimal(2.0);

    @MinDuration(value="1ms")
    @MaxDuration(value="10s")
    @NotNull
    public @MinDuration(value="1ms") @MaxDuration(value="10s") @NotNull Duration getStatusRefreshMaxWait() {
        return this.statusRefreshMaxWait;
    }

    @Config(value="task.status-refresh-max-wait")
    public TaskManagerConfig setStatusRefreshMaxWait(Duration statusRefreshMaxWait) {
        this.statusRefreshMaxWait = statusRefreshMaxWait;
        return this;
    }

    @MinDuration(value="1ms")
    @MaxDuration(value="10s")
    @NotNull
    public @MinDuration(value="1ms") @MaxDuration(value="10s") @NotNull Duration getInfoUpdateInterval() {
        return this.infoUpdateInterval;
    }

    @Config(value="task.info-update-interval")
    @ConfigDescription(value="Interval between updating task data")
    public TaskManagerConfig setInfoUpdateInterval(Duration infoUpdateInterval) {
        this.infoUpdateInterval = infoUpdateInterval;
        return this;
    }

    public boolean isPerOperatorCpuTimerEnabled() {
        return this.perOperatorCpuTimerEnabled;
    }

    @LegacyConfig(value={"task.verbose-stats"})
    @Config(value="task.per-operator-cpu-timer-enabled")
    public TaskManagerConfig setPerOperatorCpuTimerEnabled(boolean perOperatorCpuTimerEnabled) {
        this.perOperatorCpuTimerEnabled = perOperatorCpuTimerEnabled;
        return this;
    }

    public boolean isTaskCpuTimerEnabled() {
        return this.taskCpuTimerEnabled;
    }

    @Config(value="task.cpu-timer-enabled")
    public TaskManagerConfig setTaskCpuTimerEnabled(boolean taskCpuTimerEnabled) {
        this.taskCpuTimerEnabled = taskCpuTimerEnabled;
        return this;
    }

    public boolean isStatisticsCpuTimerEnabled() {
        return this.statisticsCpuTimerEnabled;
    }

    @Config(value="task.statistics-cpu-timer-enabled")
    public TaskManagerConfig setStatisticsCpuTimerEnabled(boolean statisticsCpuTimerEnabled) {
        this.statisticsCpuTimerEnabled = statisticsCpuTimerEnabled;
        return this;
    }

    @NotNull
    public DataSize getMaxPartialAggregationMemoryUsage() {
        return this.maxPartialAggregationMemoryUsage;
    }

    @Config(value="task.max-partial-aggregation-memory")
    public TaskManagerConfig setMaxPartialAggregationMemoryUsage(DataSize maxPartialAggregationMemoryUsage) {
        this.maxPartialAggregationMemoryUsage = maxPartialAggregationMemoryUsage;
        return this;
    }

    @NotNull
    public DataSize getMaxPartialTopNMemory() {
        return this.maxPartialTopNMemory;
    }

    @Config(value="task.max-partial-top-n-memory")
    public TaskManagerConfig setMaxPartialTopNMemory(DataSize maxPartialTopNMemory) {
        this.maxPartialTopNMemory = maxPartialTopNMemory;
        return this;
    }

    @NotNull
    public DataSize getMaxLocalExchangeBufferSize() {
        return this.maxLocalExchangeBufferSize;
    }

    @Config(value="task.max-local-exchange-buffer-size")
    public TaskManagerConfig setMaxLocalExchangeBufferSize(DataSize size) {
        this.maxLocalExchangeBufferSize = size;
        return this;
    }

    @NotNull
    public DataSize getMaxIndexMemoryUsage() {
        return this.maxIndexMemoryUsage;
    }

    @Config(value="task.max-index-memory")
    public TaskManagerConfig setMaxIndexMemoryUsage(DataSize maxIndexMemoryUsage) {
        this.maxIndexMemoryUsage = maxIndexMemoryUsage;
        return this;
    }

    @NotNull
    public boolean isShareIndexLoading() {
        return this.shareIndexLoading;
    }

    @Config(value="task.share-index-loading")
    public TaskManagerConfig setShareIndexLoading(boolean shareIndexLoading) {
        this.shareIndexLoading = shareIndexLoading;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) BigDecimal getLevelTimeMultiplier() {
        return this.levelTimeMultiplier;
    }

    @Config(value="task.level-time-multiplier")
    @ConfigDescription(value="Factor that determines the target scheduled time for a level relative to the next")
    public TaskManagerConfig setLevelTimeMultiplier(BigDecimal levelTimeMultiplier) {
        this.levelTimeMultiplier = levelTimeMultiplier;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxWorkerThreads() {
        return this.maxWorkerThreads;
    }

    @LegacyConfig(value={"task.shard.max-threads"})
    @Config(value="task.max-worker-threads")
    public TaskManagerConfig setMaxWorkerThreads(int maxWorkerThreads) {
        this.maxWorkerThreads = maxWorkerThreads;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getInitialSplitsPerNode() {
        if (this.initialSplitsPerNode == null) {
            return this.maxWorkerThreads;
        }
        return this.initialSplitsPerNode;
    }

    @Config(value="task.initial-splits-per-node")
    public TaskManagerConfig setInitialSplitsPerNode(int initialSplitsPerNode) {
        this.initialSplitsPerNode = initialSplitsPerNode;
        return this;
    }

    @MinDuration(value="1ms")
    public @MinDuration(value="1ms") Duration getSplitConcurrencyAdjustmentInterval() {
        return this.splitConcurrencyAdjustmentInterval;
    }

    @Config(value="task.split-concurrency-adjustment-interval")
    public TaskManagerConfig setSplitConcurrencyAdjustmentInterval(Duration splitConcurrencyAdjustmentInterval) {
        this.splitConcurrencyAdjustmentInterval = splitConcurrencyAdjustmentInterval;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMinDrivers() {
        if (this.minDrivers == null) {
            return 2 * this.maxWorkerThreads;
        }
        return this.minDrivers;
    }

    @Config(value="task.min-drivers")
    public TaskManagerConfig setMinDrivers(int minDrivers) {
        this.minDrivers = minDrivers;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxDriversPerTask() {
        return this.maxDriversPerTask;
    }

    @Config(value="task.max-drivers-per-task")
    @ConfigDescription(value="Maximum number of drivers a task can run")
    public TaskManagerConfig setMaxDriversPerTask(int maxDriversPerTask) {
        this.maxDriversPerTask = maxDriversPerTask;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMinDriversPerTask() {
        return this.minDriversPerTask;
    }

    @Config(value="task.min-drivers-per-task")
    @ConfigDescription(value="Minimum number of drivers guaranteed to run per task given there is sufficient work to do")
    public TaskManagerConfig setMinDriversPerTask(int minDriversPerTask) {
        this.minDriversPerTask = minDriversPerTask;
        return this;
    }

    @NotNull
    public DataSize getSinkMaxBufferSize() {
        return this.sinkMaxBufferSize;
    }

    @Config(value="sink.max-buffer-size")
    public TaskManagerConfig setSinkMaxBufferSize(DataSize sinkMaxBufferSize) {
        this.sinkMaxBufferSize = sinkMaxBufferSize;
        return this;
    }

    public DataSize getSinkMaxBroadcastBufferSize() {
        return this.sinkMaxBroadcastBufferSize;
    }

    @Config(value="sink.max-broadcast-buffer-size")
    public TaskManagerConfig setSinkMaxBroadcastBufferSize(DataSize sinkMaxBroadcastBufferSize) {
        this.sinkMaxBroadcastBufferSize = sinkMaxBroadcastBufferSize;
        return this;
    }

    @NotNull
    public DataSize getMaxPagePartitioningBufferSize() {
        return this.maxPagePartitioningBufferSize;
    }

    @Config(value="driver.max-page-partitioning-buffer-size")
    public TaskManagerConfig setMaxPagePartitioningBufferSize(DataSize size) {
        this.maxPagePartitioningBufferSize = size;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getPagePartitioningBufferPoolSize() {
        return this.pagePartitioningBufferPoolSize;
    }

    @Config(value="driver.page-partitioning-buffer-pool-size")
    @ConfigDescription(value="Maximum number of free buffers in the per task partitioned page buffer pool. Setting this to zero effectively disables the pool")
    public TaskManagerConfig setPagePartitioningBufferPoolSize(int pagePartitioningBufferPoolSize) {
        this.pagePartitioningBufferPoolSize = pagePartitioningBufferPoolSize;
        return this;
    }

    @MinDuration(value="5s")
    @NotNull
    public @MinDuration(value="5s") @NotNull Duration getClientTimeout() {
        return this.clientTimeout;
    }

    @Config(value="task.client.timeout")
    public TaskManagerConfig setClientTimeout(Duration clientTimeout) {
        this.clientTimeout = clientTimeout;
        return this;
    }

    @NotNull
    public Duration getInfoMaxAge() {
        return this.infoMaxAge;
    }

    @Config(value="task.info.max-age")
    public TaskManagerConfig setInfoMaxAge(Duration infoMaxAge) {
        this.infoMaxAge = infoMaxAge;
        return this;
    }

    public boolean isScaleWritersEnabled() {
        return this.scaleWritersEnabled;
    }

    @Config(value="task.scale-writers.enabled")
    @ConfigDescription(value="Scale the number of concurrent table writers per task based on throughput")
    public TaskManagerConfig setScaleWritersEnabled(boolean scaleWritersEnabled) {
        this.scaleWritersEnabled = scaleWritersEnabled;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getScaleWritersMaxWriterCount() {
        return this.scaleWritersMaxWriterCount;
    }

    @Config(value="task.scale-writers.max-writer-count")
    @ConfigDescription(value="Maximum number of writers per task up to which scaling will happen if task.scale-writers.enabled is set")
    public TaskManagerConfig setScaleWritersMaxWriterCount(int scaleWritersMaxWriterCount) {
        this.scaleWritersMaxWriterCount = scaleWritersMaxWriterCount;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getWriterCount() {
        return this.writerCount;
    }

    @Config(value="task.writer-count")
    @ConfigDescription(value="Number of local parallel table writers per task when prefer partitioning and task writer scaling are not used")
    public TaskManagerConfig setWriterCount(int writerCount) {
        this.writerCount = writerCount;
        return this;
    }

    @Min(value=1L)
    @PowerOfTwo
    public @Min(value=1L) int getPartitionedWriterCount() {
        return this.partitionedWriterCount;
    }

    @Config(value="task.partitioned-writer-count")
    @ConfigDescription(value="Number of local parallel table writers per task when prefer partitioning is used")
    public TaskManagerConfig setPartitionedWriterCount(int partitionedWriterCount) {
        this.partitionedWriterCount = partitionedWriterCount;
        return this;
    }

    @Min(value=1L)
    @PowerOfTwo
    public @Min(value=1L) int getTaskConcurrency() {
        return this.taskConcurrency;
    }

    @Config(value="task.concurrency")
    @ConfigDescription(value="Default number of local parallel jobs per worker")
    public TaskManagerConfig setTaskConcurrency(int taskConcurrency) {
        this.taskConcurrency = taskConcurrency;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getHttpResponseThreads() {
        return this.httpResponseThreads;
    }

    @Config(value="task.http-response-threads")
    public TaskManagerConfig setHttpResponseThreads(int httpResponseThreads) {
        this.httpResponseThreads = httpResponseThreads;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getHttpTimeoutThreads() {
        return this.httpTimeoutThreads;
    }

    @Config(value="task.http-timeout-threads")
    public TaskManagerConfig setHttpTimeoutThreads(int httpTimeoutThreads) {
        this.httpTimeoutThreads = httpTimeoutThreads;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getTaskNotificationThreads() {
        return this.taskNotificationThreads;
    }

    @Config(value="task.task-notification-threads")
    @ConfigDescription(value="Number of threads used for internal task event notifications")
    public TaskManagerConfig setTaskNotificationThreads(int taskNotificationThreads) {
        this.taskNotificationThreads = taskNotificationThreads;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getTaskYieldThreads() {
        return this.taskYieldThreads;
    }

    @Config(value="task.task-yield-threads")
    @ConfigDescription(value="Number of threads used for setting yield signals")
    public TaskManagerConfig setTaskYieldThreads(int taskYieldThreads) {
        this.taskYieldThreads = taskYieldThreads;
        return this;
    }

    public boolean isInterruptStuckSplitTasksEnabled() {
        return this.interruptStuckSplitTasksEnabled;
    }

    @Config(value="task.interrupt-stuck-split-tasks-enabled")
    public TaskManagerConfig setInterruptStuckSplitTasksEnabled(boolean interruptStuckSplitTasksEnabled) {
        this.interruptStuckSplitTasksEnabled = interruptStuckSplitTasksEnabled;
        return this;
    }

    @MinDuration(value="1m")
    public @MinDuration(value="1m") Duration getInterruptStuckSplitTasksWarningThreshold() {
        return this.interruptStuckSplitTasksWarningThreshold;
    }

    @Config(value="task.interrupt-stuck-split-tasks-warning-threshold")
    @ConfigDescription(value="Print out call stacks and generate JMX metrics for splits running longer than the threshold")
    public TaskManagerConfig setInterruptStuckSplitTasksWarningThreshold(Duration interruptStuckSplitTasksWarningThreshold) {
        this.interruptStuckSplitTasksWarningThreshold = interruptStuckSplitTasksWarningThreshold;
        return this;
    }

    @MinDuration(value="3m")
    public @MinDuration(value="3m") Duration getInterruptStuckSplitTasksTimeout() {
        return this.interruptStuckSplitTasksTimeout;
    }

    @Config(value="task.interrupt-stuck-split-tasks-timeout")
    @ConfigDescription(value="Interrupt task processing thread after this timeout if the thread is stuck in certain external libraries used by Trino functions")
    public TaskManagerConfig setInterruptStuckSplitTasksTimeout(Duration interruptStuckSplitTasksTimeout) {
        this.interruptStuckSplitTasksTimeout = interruptStuckSplitTasksTimeout;
        return this;
    }

    @MinDuration(value="1m")
    public @MinDuration(value="1m") Duration getInterruptStuckSplitTasksDetectionInterval() {
        return this.interruptStuckSplitTasksDetectionInterval;
    }

    @Config(value="task.interrupt-stuck-split-tasks-detection-interval")
    @ConfigDescription(value="Interval between detecting stuck split")
    public TaskManagerConfig setInterruptStuckSplitTasksDetectionInterval(Duration interruptStuckSplitTasksDetectionInterval) {
        this.interruptStuckSplitTasksDetectionInterval = interruptStuckSplitTasksDetectionInterval;
        return this;
    }

    public void applyFaultTolerantExecutionDefaults() {
        this.taskConcurrency = 8;
    }
}

